/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.core;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentType;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.utils.Bits;
import com.badlogic.gdx.utils.ObjectMap;

public class Family {
    private static ObjectMap<String, Family> families = new ObjectMap();
    private static int familyIndex = 0;
    private static final Builder builder = new Builder();
    private static final Bits zeroBits = new Bits();
    private final Bits all;
    private final Bits one;
    private final Bits exclude;
    private final int index;

    private Family(Bits all2, Bits any2, Bits exclude) {
        this.all = all2;
        this.one = any2;
        this.exclude = exclude;
        this.index = familyIndex++;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean matches(Entity entity) {
        Bits entityComponentBits = entity.getComponentBits();
        if (!entityComponentBits.containsAll(this.all)) {
            return false;
        }
        if (!this.one.isEmpty() && !this.one.intersects(entityComponentBits)) {
            return false;
        }
        return this.exclude.isEmpty() || !this.exclude.intersects(entityComponentBits);
    }

    @SafeVarargs
    public static final Builder all(Class<? extends Component> ... componentTypes) {
        return builder.reset().all(componentTypes);
    }

    @SafeVarargs
    public static final Builder one(Class<? extends Component> ... componentTypes) {
        return builder.reset().one(componentTypes);
    }

    @SafeVarargs
    public static final Builder exclude(Class<? extends Component> ... componentTypes) {
        return builder.reset().exclude(componentTypes);
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    private static String getFamilyHash(Bits all2, Bits one, Bits exclude) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!all2.isEmpty()) {
            stringBuilder.append("{all:").append(Family.getBitsString(all2)).append("}");
        }
        if (!one.isEmpty()) {
            stringBuilder.append("{one:").append(Family.getBitsString(one)).append("}");
        }
        if (!exclude.isEmpty()) {
            stringBuilder.append("{exclude:").append(Family.getBitsString(exclude)).append("}");
        }
        return stringBuilder.toString();
    }

    private static String getBitsString(Bits bits) {
        StringBuilder stringBuilder = new StringBuilder();
        int numBits = bits.length();
        for (int i = 0; i < numBits; ++i) {
            stringBuilder.append(bits.get(i) ? "1" : "0");
        }
        return stringBuilder.toString();
    }

    public static class Builder {
        private Bits all = Family.access$000();
        private Bits one = Family.access$000();
        private Bits exclude = Family.access$000();

        Builder() {
        }

        public Builder reset() {
            this.all = zeroBits;
            this.one = zeroBits;
            this.exclude = zeroBits;
            return this;
        }

        @SafeVarargs
        public final Builder all(Class<? extends Component> ... componentTypes) {
            this.all = ComponentType.getBitsFor(componentTypes);
            return this;
        }

        @SafeVarargs
        public final Builder one(Class<? extends Component> ... componentTypes) {
            this.one = ComponentType.getBitsFor(componentTypes);
            return this;
        }

        @SafeVarargs
        public final Builder exclude(Class<? extends Component> ... componentTypes) {
            this.exclude = ComponentType.getBitsFor(componentTypes);
            return this;
        }

        public Family get() {
            String hash = Family.getFamilyHash(this.all, this.one, this.exclude);
            Family family = families.get(hash, null);
            if (family == null) {
                family = new Family(this.all, this.one, this.exclude);
                families.put(hash, family);
            }
            return family;
        }
    }
}

