/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.Drawing;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.input.GlobalKeyMapper;
import org.veiset.kgame.engine.sound.SoundPlayer;
import org.veiset.kgame.game.GameState;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\nH\u00c6\u0003J\t\u0010 \u001a\u00020\fH\u00c6\u0003JE\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001J\u0006\u0010)\u001a\u00020*R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006+"}, d2={"Lorg/veiset/kgame/engine/Globals;", "", "drawGfx", "Lorg/veiset/kgame/engine/Drawing;", "drawUi", "soundPlayer", "Lorg/veiset/kgame/engine/sound/SoundPlayer;", "assetManager", "Lorg/veiset/kgame/engine/asset/AssetManager;", "keyMapper", "Lorg/veiset/kgame/engine/input/GlobalKeyMapper;", "state", "Lorg/veiset/kgame/game/GameState;", "(Lorg/veiset/kgame/engine/Drawing;Lorg/veiset/kgame/engine/Drawing;Lorg/veiset/kgame/engine/sound/SoundPlayer;Lorg/veiset/kgame/engine/asset/AssetManager;Lorg/veiset/kgame/engine/input/GlobalKeyMapper;Lorg/veiset/kgame/game/GameState;)V", "getAssetManager", "()Lorg/veiset/kgame/engine/asset/AssetManager;", "getDrawGfx", "()Lorg/veiset/kgame/engine/Drawing;", "getDrawUi", "getKeyMapper", "()Lorg/veiset/kgame/engine/input/GlobalKeyMapper;", "getSoundPlayer", "()Lorg/veiset/kgame/engine/sound/SoundPlayer;", "getState", "()Lorg/veiset/kgame/game/GameState;", "setState", "(Lorg/veiset/kgame/game/GameState;)V", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "updateDrawMatrix", "", "kgame2"})
public final class Globals {
    @NotNull
    private final Drawing drawGfx;
    @NotNull
    private final Drawing drawUi;
    @NotNull
    private final SoundPlayer soundPlayer;
    @NotNull
    private final AssetManager assetManager;
    @NotNull
    private final GlobalKeyMapper keyMapper;
    @NotNull
    private GameState state;

    public Globals(@NotNull Drawing drawGfx, @NotNull Drawing drawUi, @NotNull SoundPlayer soundPlayer, @NotNull AssetManager assetManager, @NotNull GlobalKeyMapper keyMapper, @NotNull GameState state) {
        Intrinsics.checkNotNullParameter(drawGfx, "drawGfx");
        Intrinsics.checkNotNullParameter(drawUi, "drawUi");
        Intrinsics.checkNotNullParameter(soundPlayer, "soundPlayer");
        Intrinsics.checkNotNullParameter(assetManager, "assetManager");
        Intrinsics.checkNotNullParameter(keyMapper, "keyMapper");
        Intrinsics.checkNotNullParameter(state, "state");
        this.drawGfx = drawGfx;
        this.drawUi = drawUi;
        this.soundPlayer = soundPlayer;
        this.assetManager = assetManager;
        this.keyMapper = keyMapper;
        this.state = state;
    }

    public /* synthetic */ Globals(Drawing drawing, Drawing drawing2, SoundPlayer soundPlayer, AssetManager assetManager, GlobalKeyMapper globalKeyMapper, GameState gameState, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            soundPlayer = new SoundPlayer(false, 1, null);
        }
        if ((n & 8) != 0) {
            assetManager = new AssetManager();
        }
        if ((n & 0x20) != 0) {
            gameState = new GameState(0L, 0L, 0, false, false, 0, null, 127, null);
        }
        this(drawing, drawing2, soundPlayer, assetManager, globalKeyMapper, gameState);
    }

    @NotNull
    public final Drawing getDrawGfx() {
        return this.drawGfx;
    }

    @NotNull
    public final Drawing getDrawUi() {
        return this.drawUi;
    }

    @NotNull
    public final SoundPlayer getSoundPlayer() {
        return this.soundPlayer;
    }

    @NotNull
    public final AssetManager getAssetManager() {
        return this.assetManager;
    }

    @NotNull
    public final GlobalKeyMapper getKeyMapper() {
        return this.keyMapper;
    }

    @NotNull
    public final GameState getState() {
        return this.state;
    }

    public final void setState(@NotNull GameState gameState) {
        Intrinsics.checkNotNullParameter(gameState, "<set-?>");
        this.state = gameState;
    }

    public final void updateDrawMatrix() {
        OrthographicCamera camera = this.drawGfx.getCamera();
        ShapeRenderer shapeRenderer = this.drawGfx.getShapeRenderer();
        SpriteBatch spriteBatch = this.drawGfx.getSpriteBatch();
        camera.update();
        shapeRenderer.setProjectionMatrix(camera.combined);
        spriteBatch.setProjectionMatrix(camera.combined);
        TBEngineKt.getGlobals().drawGfx.getViewport().update(GameFilesKt.getGameConfig().getScreenWidth(), GameFilesKt.getGameConfig().getScreenHeight());
    }

    @NotNull
    public final Drawing component1() {
        return this.drawGfx;
    }

    @NotNull
    public final Drawing component2() {
        return this.drawUi;
    }

    @NotNull
    public final SoundPlayer component3() {
        return this.soundPlayer;
    }

    @NotNull
    public final AssetManager component4() {
        return this.assetManager;
    }

    @NotNull
    public final GlobalKeyMapper component5() {
        return this.keyMapper;
    }

    @NotNull
    public final GameState component6() {
        return this.state;
    }

    @NotNull
    public final Globals copy(@NotNull Drawing drawGfx, @NotNull Drawing drawUi, @NotNull SoundPlayer soundPlayer, @NotNull AssetManager assetManager, @NotNull GlobalKeyMapper keyMapper, @NotNull GameState state) {
        Intrinsics.checkNotNullParameter(drawGfx, "drawGfx");
        Intrinsics.checkNotNullParameter(drawUi, "drawUi");
        Intrinsics.checkNotNullParameter(soundPlayer, "soundPlayer");
        Intrinsics.checkNotNullParameter(assetManager, "assetManager");
        Intrinsics.checkNotNullParameter(keyMapper, "keyMapper");
        Intrinsics.checkNotNullParameter(state, "state");
        return new Globals(drawGfx, drawUi, soundPlayer, assetManager, keyMapper, state);
    }

    public static /* synthetic */ Globals copy$default(Globals globals, Drawing drawing, Drawing drawing2, SoundPlayer soundPlayer, AssetManager assetManager, GlobalKeyMapper globalKeyMapper, GameState gameState, int n, Object object) {
        if ((n & 1) != 0) {
            drawing = globals.drawGfx;
        }
        if ((n & 2) != 0) {
            drawing2 = globals.drawUi;
        }
        if ((n & 4) != 0) {
            soundPlayer = globals.soundPlayer;
        }
        if ((n & 8) != 0) {
            assetManager = globals.assetManager;
        }
        if ((n & 0x10) != 0) {
            globalKeyMapper = globals.keyMapper;
        }
        if ((n & 0x20) != 0) {
            gameState = globals.state;
        }
        return globals.copy(drawing, drawing2, soundPlayer, assetManager, globalKeyMapper, gameState);
    }

    @NotNull
    public String toString() {
        return "Globals(drawGfx=" + this.drawGfx + ", drawUi=" + this.drawUi + ", soundPlayer=" + this.soundPlayer + ", assetManager=" + this.assetManager + ", keyMapper=" + this.keyMapper + ", state=" + this.state + ')';
    }

    public int hashCode() {
        int result2 = this.drawGfx.hashCode();
        result2 = result2 * 31 + this.drawUi.hashCode();
        result2 = result2 * 31 + this.soundPlayer.hashCode();
        result2 = result2 * 31 + this.assetManager.hashCode();
        result2 = result2 * 31 + this.keyMapper.hashCode();
        result2 = result2 * 31 + this.state.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Globals)) {
            return false;
        }
        Globals globals = (Globals)other;
        if (!Intrinsics.areEqual(this.drawGfx, globals.drawGfx)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.drawUi, globals.drawUi)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.soundPlayer, globals.soundPlayer)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.assetManager, globals.assetManager)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keyMapper, globals.keyMapper)) {
            return false;
        }
        return Intrinsics.areEqual(this.state, globals.state);
    }
}

