/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.CLICol;
import org.veiset.kgame.engine.CLIStyle;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.LogLevel;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u001aE\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\f0\u0013\u00a2\u0006\u0002\u0010\u0014\u001a\u0012\u0010\u0015\u001a\u00020\u000e*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b\u001a\u0012\u0010\u0018\u001a\u00020\u000e*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b\u001a\u0012\u0010\u0019\u001a\u00020\u000e*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b\u001a\u0012\u0010\u001a\u001a\u00020\u000e*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"formatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "uncolorRegex", "Lkotlin/text/Regex;", "log", "", "msg", "", "level", "Lorg/veiset/kgame/engine/LogLevel;", "logTimed", "T", "key", "", "splitKey", "padding", "", "f", "Lkotlin/Function0;", "(Ljava/lang/String;Lorg/veiset/kgame/engine/LogLevel;Ljava/lang/String;ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "c", "Lorg/veiset/kgame/engine/CLICol;", "s", "cb", "cbu", "cu", "kgame2"})
public final class LoggerKt {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSSS");
    @NotNull
    private static final Regex uncolorRegex = new Regex("\u001b\\[\\d?\\dm");

    public static final void log(@NotNull Object msg, @NotNull LogLevel level) {
        String string2;
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter((Object)level, "level");
        if (EngineConfig.Debug.INSTANCE.getLOG_LEVEL().getLevel() > level.getLevel() || !EngineConfig.Debug.INSTANCE.getPRINT()) {
            return;
        }
        String timestamp = LocalDateTime.now().format(formatter);
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                string2 = '[' + timestamp + "] " + msg;
                break;
            }
            case 2: {
                string2 = Intrinsics.stringPlus(LoggerKt.c(CLICol.GREEN, '[' + timestamp + "] "), msg);
                break;
            }
            case 3: {
                string2 = Intrinsics.stringPlus(LoggerKt.c(CLICol.YELLOW, '[' + timestamp + "] "), msg);
                break;
            }
            case 4: {
                string2 = Intrinsics.stringPlus(LoggerKt.cb(CLICol.RED, '[' + timestamp + "] "), msg);
                break;
            }
            case 5: {
                string2 = Intrinsics.stringPlus(LoggerKt.cb(CLICol.RED, '[' + timestamp + "] " + msg), " ");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String message = string2;
        System.out.println((Object)message);
        if (GameFilesKt.getGameConfig() != null && GameFilesKt.getGameConfig().getLogToFile()) {
            CharSequence charSequence = msg.toString();
            Regex regex = uncolorRegex;
            String string3 = "";
            String uncolor = regex.replace(charSequence, string3);
            Log.INSTANCE.getFileLogger().println(timestamp + ':' + StringsKt.padEnd$default(level.toString(), 9, '\u0000', 2, null) + "\uff5c  " + uncolor);
        }
    }

    public static /* synthetic */ void log$default(Object object, LogLevel logLevel, int n, Object object2) {
        if ((n & 2) != 0) {
            logLevel = LogLevel.DEBUG;
        }
        LoggerKt.log(object, logLevel);
    }

    @NotNull
    public static final String c(@NotNull CLICol $this$c, @NotNull Object s) {
        Intrinsics.checkNotNullParameter((Object)$this$c, "<this>");
        Intrinsics.checkNotNullParameter(s, "s");
        return $this$c.getColorCode() + s + CLIStyle.RESET.getCode();
    }

    @NotNull
    public static final String cb(@NotNull CLICol $this$cb, @NotNull Object s) {
        Intrinsics.checkNotNullParameter((Object)$this$cb, "<this>");
        Intrinsics.checkNotNullParameter(s, "s");
        return Intrinsics.stringPlus(CLIStyle.BOLD.getCode(), LoggerKt.c($this$cb, s));
    }

    @NotNull
    public static final String cu(@NotNull CLICol $this$cu, @NotNull Object s) {
        Intrinsics.checkNotNullParameter((Object)$this$cu, "<this>");
        Intrinsics.checkNotNullParameter(s, "s");
        return Intrinsics.stringPlus(CLIStyle.UNDERLINE.getCode(), LoggerKt.c($this$cu, s));
    }

    @NotNull
    public static final String cbu(@NotNull CLICol $this$cbu, @NotNull Object s) {
        Intrinsics.checkNotNullParameter((Object)$this$cbu, "<this>");
        Intrinsics.checkNotNullParameter(s, "s");
        return CLIStyle.UNDERLINE.getCode() + CLIStyle.BOLD.getCode() + LoggerKt.c($this$cbu, s);
    }

    public static final <T> T logTimed(@NotNull String key, @NotNull LogLevel level, @NotNull String splitKey, int padding, @NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter((Object)level, "level");
        Intrinsics.checkNotNullParameter(splitKey, "splitKey");
        Intrinsics.checkNotNullParameter(f, "f");
        if (EngineConfig.Debug.INSTANCE.getLOG_LEVEL().getLevel() > level.getLevel()) {
            f.invoke();
        }
        boolean $i$f$measureTimedValue = false;
        TimeSource $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        TimeMark mark$iv$iv = $this$measureTimedValue$iv$iv.markNow();
        T result$iv$iv = f.invoke();
        TimedValue timed = new TimedValue(result$iv$iv, mark$iv$iv.elapsedNow-UwyO8pc(), null);
        float ms = (float)Duration.getInWholeNanoseconds-impl(timed.getDuration-UwyO8pc()) / 1000000.0f;
        CLICol color = ms <= 16.0f ? CLICol.BLUE : (ms < 500.0f ? CLICol.YELLOW : CLICol.RED);
        Object[] objectArray = new Object[]{Float.valueOf(ms)};
        String string2 = String.format("%.4f", Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
        String formattedNumber = StringsKt.padStart$default(string2, padding, '\u0000', 2, null);
        LoggerKt.log(LoggerKt.cb(color, "\u23f2") + ' ' + formattedNumber + "ms " + splitKey + ' ' + key, level);
        return timed.getValue();
    }

    public static /* synthetic */ Object logTimed$default(String string2, LogLevel logLevel, String string3, int n, Function0 function0, int n2, Object object) {
        if ((n2 & 2) != 0) {
            logLevel = LogLevel.DEBUG;
        }
        if ((n2 & 4) != 0) {
            string3 = "-";
        }
        if ((n2 & 8) != 0) {
            n = 8;
        }
        return LoggerKt.logTimed(string2, logLevel, string3, n, function0);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogLevel.values().length];
            nArray[LogLevel.DEBUG.ordinal()] = 1;
            nArray[LogLevel.INFO.ordinal()] = 2;
            nArray[LogLevel.WARN.ordinal()] = 3;
            nArray[LogLevel.ERROR.ordinal()] = 4;
            nArray[LogLevel.CRITICAL.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

