/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine;

import com.badlogic.ashley.core.Engine;
import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.ScreenUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.GlobalVars;
import org.veiset.kgame.engine.CLIStyle;
import org.veiset.kgame.engine.Drawing;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.GameConfig;
import org.veiset.kgame.engine.GameFile;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.GameModule;
import org.veiset.kgame.engine.Globals;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.SaveGame;
import org.veiset.kgame.engine.StartupConfig;
import org.veiset.kgame.engine.TBEngine;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.core.component.levelselect.GameLevelComponent;
import org.veiset.kgame.engine.input.GlobalKeyMapper;
import org.veiset.kgame.engine.math.MathUtilsKt;
import org.veiset.kgame.engine.sound.SoundPlayer;
import org.veiset.kgame.engine.state.GameLevelState;
import org.veiset.kgame.engine.state.LevelMonsters;
import org.veiset.kgame.engine.tools.editor.area.AreaEditor;
import org.veiset.kgame.engine.tools.editor.tileset.WorldgenModule;
import org.veiset.kgame.engine.values.Asset;
import org.veiset.kgame.engine.world.FireBossTiles;
import org.veiset.kgame.module.AssetLoadModule;
import org.veiset.kgame.module.GameWorldModule;
import org.veiset.kgame.module.LevelSelectModule;
import org.veiset.kgame.module.MainMenuModule;
import org.veiset.kgame.module.SplashScreenModule;
import org.veiset.kgame.presentation.PPresentation;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020+H\u0016J#\u0010-\u001a\u00020+2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020+H\u0016J\u0018\u00100\u001a\u00020+2\u0006\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u000bH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0011X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u001a\u0010\u0018\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\r\"\u0004\b\u001a\u0010\u000fR\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010#\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\r\"\u0004\b%\u0010\u000fR\u000e\u0010&\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u00063"}, d2={"Lorg/veiset/kgame/engine/TBEngine;", "Lcom/badlogic/gdx/ApplicationAdapter;", "args", "", "", "startupConfig", "Lorg/veiset/kgame/engine/StartupConfig;", "(Ljava/util/List;Lorg/veiset/kgame/engine/StartupConfig;)V", "getArgs", "()Ljava/util/List;", "fps", "", "getFps", "()I", "setFps", "(I)V", "fpsCounter", "", "getFpsCounter", "()F", "setFpsCounter", "(F)V", "fpsSampleSize", "getFpsSampleSize", "frame", "getFrame", "setFrame", "frameTimes", "", "", "getFrameTimes", "()[Ljava/lang/Long;", "setFrameTimes", "([Ljava/lang/Long;)V", "[Ljava/lang/Long;", "frames", "getFrames", "setFrames", "gameModule", "Lorg/veiset/kgame/engine/GameModule;", "getStartupConfig", "()Lorg/veiset/kgame/engine/StartupConfig;", "create", "", "dispose", "drawFrames", "([Ljava/lang/Long;I)V", "render", "resize", "width", "height", "kgame2"})
public final class TBEngine
extends ApplicationAdapter {
    @NotNull
    private final List<String> args;
    @NotNull
    private final StartupConfig startupConfig;
    @NotNull
    private Long[] frameTimes;
    private int frame;
    private float fpsCounter;
    private int frames;
    private int fps;
    private final float fpsSampleSize;
    private GameModule gameModule;

    public TBEngine(@NotNull List<String> args2, @NotNull StartupConfig startupConfig) {
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(startupConfig, "startupConfig");
        this.args = args2;
        this.startupConfig = startupConfig;
        int n = 0;
        Long[] longArray = new Long[10];
        TBEngine tBEngine = this;
        while (n < 10) {
            int n2 = n++;
            longArray[n2] = 0L;
        }
        tBEngine.frameTimes = longArray;
        this.fpsSampleSize = 0.1f;
    }

    public /* synthetic */ TBEngine(List list, StartupConfig startupConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            startupConfig = new StartupConfig(false, null, null, 0L, 15, null);
        }
        this(list, startupConfig);
    }

    @NotNull
    public final List<String> getArgs() {
        return this.args;
    }

    @NotNull
    public final StartupConfig getStartupConfig() {
        return this.startupConfig;
    }

    @NotNull
    public final Long[] getFrameTimes() {
        return this.frameTimes;
    }

    public final void setFrameTimes(@NotNull Long[] longArray) {
        Intrinsics.checkNotNullParameter(longArray, "<set-?>");
        this.frameTimes = longArray;
    }

    public final int getFrame() {
        return this.frame;
    }

    public final void setFrame(int n) {
        this.frame = n;
    }

    public final float getFpsCounter() {
        return this.fpsCounter;
    }

    public final void setFpsCounter(float f) {
        this.fpsCounter = f;
    }

    public final int getFrames() {
        return this.frames;
    }

    public final void setFrames(int n) {
        this.frames = n;
    }

    public final int getFps() {
        return this.fps;
    }

    public final void setFps(int n) {
        this.fps = n;
    }

    public final float getFpsSampleSize() {
        return this.fpsSampleSize;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void create() {
        this.startupConfig.getPreSetup().invoke();
        Log.INSTANCE.debug(Intrinsics.stringPlus("Arguments: ", this.args));
        Log.INSTANCE.debug("Booting ...");
        Log.INSTANCE.debug(" - LibGdx: " + (System.currentTimeMillis() - this.startupConfig.getStartupTime()) + " ms");
        startTimeModule = System.currentTimeMillis();
        TBEngineKt.setGlobals(new Globals(new Drawing(), new Drawing(), new SoundPlayer(this.startupConfig.getPreloadSounds()), new AssetManager(), new GlobalKeyMapper(false, 1, null), null, 32, null));
        engine = new Engine();
        Log.INSTANCE.debug(" - Bootstrap (LibGdx, Resources, Engine): " + (System.currentTimeMillis() - startTimeModule) + " ms");
        startTimeModule = System.currentTimeMillis();
        Log.INSTANCE.debug("Loading start module ...");
        if (((Collection)this.args).isEmpty() == false) {
            EngineConfig.Engine.INSTANCE.setPRODUCTION_MODE(false);
        }
        if (this.args.isEmpty()) {
            EngineConfig.Engine.INSTANCE.setPRODUCTION_MODE(true);
        }
        Log.INSTANCE.info(Intrinsics.stringPlus("Production mode: ", EngineConfig.Engine.INSTANCE.getPRODUCTION_MODE()));
        var6_3 = CollectionsKt.firstOrNull(this.args);
        if (var6_3 == null) {
            v0 = null;
        } else {
            var7_4 = var6_3.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(var7_4, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            v0 = var5_5 = var7_4;
        }
        if (var5_5 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var5_5.hashCode()) {
            case -7694696: {
                if (var5_5.equals("mainmenu")) {
                    tmp = 1;
                }
                break;
            }
            case 3029869: {
                if (var5_5.equals("boss")) {
                    tmp = 2;
                }
                break;
            }
            case 3449392: {
                if (var5_5.equals("pres")) {
                    tmp = 3;
                }
                break;
            }
            case 36237950: {
                if (var5_5.equals("worldgen")) {
                    tmp = 4;
                }
                break;
            }
            case -1611195008: {
                if (var5_5.equals("levelselect")) {
                    tmp = 5;
                }
                break;
            }
            case -1038695314: {
                if (var5_5.equals("editor.area")) {
                    tmp = 6;
                }
                break;
            }
            case -1294047452: {
                if (var5_5.equals("test.attack")) {
                    tmp = 7;
                }
                break;
            }
            case 1023178464: {
                if (var5_5.equals("gameworld")) {
                    tmp = 8;
                }
                break;
            }
        }
        switch (tmp) {
            case 6: {
                v1 = new Function0<AreaEditor>(engine){
                    final /* synthetic */ Engine $engine;
                    {
                        this.$engine = $engine;
                        super(0);
                    }

                    @NotNull
                    public final AreaEditor invoke() {
                        return new AreaEditor(this.$engine, null, null, 6, null);
                    }
                };
                break;
            }
            case 4: {
                v1 = new Function0<GameModule>(engine){
                    final /* synthetic */ Engine $engine;
                    {
                        this.$engine = $engine;
                        super(0);
                    }

                    @NotNull
                    public final GameModule invoke() {
                        return new WorldgenModule(this.$engine, null, 0.0f, 6, null);
                    }
                };
                break;
            }
            case 5: {
                v1 = new Function0<GameModule>(engine){
                    final /* synthetic */ Engine $engine;
                    {
                        this.$engine = $engine;
                        super(0);
                    }

                    @NotNull
                    public final GameModule invoke() {
                        return new LevelSelectModule(this.$engine, new GameLevelState(null, null, null, null, 15, null));
                    }
                };
                break;
            }
            case 8: {
                v1 = new Function0<GameModule>(engine){
                    final /* synthetic */ Engine $engine;
                    {
                        this.$engine = $engine;
                        super(0);
                    }

                    @NotNull
                    public final GameModule invoke() {
                        return new GameWorldModule(this.$engine, null, new GameLevelState(null, null, null, null, 15, null), 2, null);
                    }
                };
                break;
            }
            case 1: {
                v1 = new Function0<GameModule>(engine){
                    final /* synthetic */ Engine $engine;
                    {
                        this.$engine = $engine;
                        super(0);
                    }

                    @NotNull
                    public final GameModule invoke() {
                        return new MainMenuModule(this.$engine);
                    }
                };
                break;
            }
            case 3: {
                v1 = new Function0<GameModule>(engine){
                    final /* synthetic */ Engine $engine;
                    {
                        this.$engine = $engine;
                        super(0);
                    }

                    @NotNull
                    public final GameModule invoke() {
                        return new PPresentation(this.$engine);
                    }
                };
                break;
            }
            case 7: {
                v1 = create.gameModuleTemp.7.INSTANCE;
                break;
            }
            case 2: {
                v1 = new Function0<GameModule>(engine){
                    final /* synthetic */ Engine $engine;
                    {
                        this.$engine = $engine;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final GameModule invoke() {
                        void it;
                        GameLevelState gameLevelState = new GameLevelState(null, null, null, null, 15, null);
                        World world = null;
                        Engine engine = this.$engine;
                        boolean bl = false;
                        GameLevelState gameLevelState2 = GameLevelState.copy$default((GameLevelState)it, null, null, null, GameLevelComponent.copy$default(it.getSelectedLevel(), null, null, new FireBossTiles(null, null, 3, null), false, new LevelMonsters(0, 0, 1), 0, 0L, 107, null), 7, null);
                        DefaultConstructorMarker defaultConstructorMarker = null;
                        int n = 2;
                        GameLevelState gameLevelState3 = gameLevelState2;
                        World world2 = world;
                        Engine engine2 = engine;
                        return new GameWorldModule(engine2, world2, gameLevelState3, n, defaultConstructorMarker);
                    }
                };
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v1 = new Function0<GameModule>(engine){
                    final /* synthetic */ Engine $engine;
                    {
                        this.$engine = $engine;
                        super(0);
                    }

                    @NotNull
                    public final GameModule invoke() {
                        return new SplashScreenModule(this.$engine);
                    }
                };
            }
        }
        gameModuleTemp = v1;
        this.gameModule = new AssetLoadModule(engine, gameModuleTemp, create.1.INSTANCE, true);
        Log.INSTANCE.debug(" + Start module loaded: " + (System.currentTimeMillis() - startTimeModule) + " ms");
        Log.INSTANCE.debug(CLIStyle.Companion.u("Total boot time: " + (System.currentTimeMillis() - GlobalVars.INSTANCE.getStartTime()) + " ms"));
        this.startupConfig.getPostSetup().invoke();
    }

    @Override
    public void resize(int width, int height) {
        GameFilesKt.getGameConfig().setScreenWidth(width);
        GameFilesKt.getGameConfig().setScreenHeight(height);
        TBEngineKt.getGlobals().getDrawGfx().getViewport().update(width, height);
        TBEngineKt.getGlobals().getDrawUi().getViewport().update(width, height);
        EngineConfig.Window.INSTANCE.setGutterHeight(TBEngineKt.getGlobals().getDrawGfx().getViewport().getTopGutterHeight() + TBEngineKt.getGlobals().getDrawGfx().getViewport().getBottomGutterHeight());
        EngineConfig.Window.INSTANCE.setGutterWidth(TBEngineKt.getGlobals().getDrawGfx().getViewport().getLeftGutterWidth() + TBEngineKt.getGlobals().getDrawGfx().getViewport().getRightGutterWidth());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void render() {
        GameModule gameModule;
        GameModule nextState2;
        GameModule gameModule2;
        GameModule state;
        void blue$iv;
        void green$iv;
        void red$iv;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float alpha$iv = 1.0f;
        boolean clearDepth$iv = true;
        boolean $i$f$clearScreen = false;
        ScreenUtils.clear((float)red$iv, (float)green$iv, (float)blue$iv, alpha$iv, clearDepth$iv);
        this.fpsCounter += Gdx.graphics.getDeltaTime();
        ++this.frames;
        if (this.fpsCounter >= this.fpsSampleSize) {
            this.fps = (int)((float)this.frames / this.fpsSampleSize);
            this.frames = 0;
            this.fpsCounter -= this.fpsSampleSize;
        }
        boolean $i$f$measureNanoTime = false;
        long start$iv = System.nanoTime();
        boolean bl = false;
        GameModule gameModule3 = this.gameModule;
        if (gameModule3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gameModule");
            gameModule3 = state = null;
        }
        if ((gameModule2 = this.gameModule) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gameModule");
            gameModule2 = null;
        }
        if (!Intrinsics.areEqual(state, nextState2 = gameModule2.nextState())) {
            Log.INSTANCE.debug("Next module: " + state + " -> " + nextState2);
            state.teardown();
            this.gameModule = nextState2;
        }
        if ((gameModule = this.gameModule) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gameModule");
            gameModule = null;
        }
        gameModule.update(Gdx.graphics.getDeltaTime() * EngineConfig.Engine.INSTANCE.getSpeed());
        if (GameFilesKt.getGameConfig().getPerformanceDisplayFPS()) {
            this.drawFrames(this.getFrameTimes(), this.getFps());
        }
        long time = System.nanoTime() - start$iv;
        ++this.frame;
        this.frame %= 10;
        this.frameTimes[this.frame] = time;
    }

    /*
     * WARNING - void declaration
     */
    private final void drawFrames(Long[] frameTimes, int fps) {
        BitmapFont bitmapFont;
        void this_$iv;
        AssetManager assetManager = TBEngineKt.getGlobals().getAssetManager();
        Object assetRef$iv = Asset.Font.INSTANCE.getJbt16();
        boolean $i$f$contains = false;
        if (!this_$iv.getAssets().containsKey(assetRef$iv)) {
            return;
        }
        assetRef$iv = TBEngineKt.getGlobals().getAssetManager();
        AssetRef assetRef$iv2 = Asset.Font.INSTANCE.getJbt16();
        boolean $i$f$get = false;
        try {
            void this_$iv2;
            Object object = this_$iv2.getAssets().get(assetRef$iv2);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv2 + " not loaded");
            throw ex$iv;
        }
        BitmapFont font = bitmapFont;
        SpriteBatch uiSpriteBatch = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
        double avgFrame = ArraysKt.averageOfLong(frameTimes);
        float frameTime = (float)avgFrame / (float)1000000;
        Object[] objectArray = new Object[]{Float.valueOf(MathUtilsKt.round(frameTime, 3))};
        String string2 = String.format("%.3f", Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
        String dt = string2;
        uiSpriteBatch.begin();
        font.draw((Batch)uiSpriteBatch, dt + " dt - " + fps + " fps", 3.6f, 1076.4f);
        uiSpriteBatch.end();
    }

    @Override
    public void dispose() {
        GameFile this_$iv;
        String fileName$iv;
        super.dispose();
        GameFile gameFile = GameFile.INSTANCE;
        String string2 = "save.json";
        Object data$iv = GameFilesKt.getSaveGame();
        boolean $i$f$save = false;
        Log.INSTANCE.info("Saving file: '" + fileName$iv + "' of type " + SaveGame.class);
        StringFormat $this$encodeToString$iv$iv = this_$iv.getFormat();
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv$iv = $this$encodeToString$iv$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer<Object> $this$cast$iv$iv$iv$iv = SerializersKt.serializer($this$serializer$iv$iv$iv, Reflection.typeOf(SaveGame.class));
        boolean $i$f$cast = false;
        String d$iv = $this$encodeToString$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv, data$iv);
        FilesKt.writeText$default(new File(fileName$iv), d$iv, null, 2, null);
        if (GameFilesKt.getGameConfig().getEngineSaveSettingsOnClose()) {
            this_$iv = GameFile.INSTANCE;
            fileName$iv = "config.json";
            data$iv = GameFilesKt.getGameConfig();
            $i$f$save = false;
            Log.INSTANCE.info("Saving file: '" + fileName$iv + "' of type " + GameConfig.class);
            $this$encodeToString$iv$iv = this_$iv.getFormat();
            $i$f$encodeToString = false;
            $this$serializer$iv$iv$iv = $this$encodeToString$iv$iv.getSerializersModule();
            $i$f$serializer = false;
            $this$cast$iv$iv$iv$iv = SerializersKt.serializer($this$serializer$iv$iv$iv, Reflection.typeOf(GameConfig.class));
            $i$f$cast = false;
            d$iv = $this$encodeToString$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv, data$iv);
            FilesKt.writeText$default(new File(fileName$iv), d$iv, null, 2, null);
        }
        Log.INSTANCE.info("Game closed");
        Log.INSTANCE.getFileLogger().flush();
        Log.INSTANCE.getFileLogger().close();
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }
}

