/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.attack.system;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentMapper;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IteratingSystem;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.ecs.attack.component.skills.AttackDirectComponent;
import org.veiset.kgame.engine.ecs.attack.component.skills.HomingComponent;
import org.veiset.kgame.engine.ecs.attack.component.skills.ProjectileComponent;
import org.veiset.kgame.engine.ecs.attack.system.ProjectileAttackSystem$processEntity$;
import org.veiset.kgame.engine.ecs.core.component.PositionComponent;
import org.veiset.kgame.engine.ecs.core.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.core.system.attack.PlayerAttackSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.util.EntityUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/veiset/kgame/engine/ecs/attack/system/ProjectileAttackSystem;", "Lcom/badlogic/ashley/systems/IteratingSystem;", "()V", "processEntity", "", "entity", "Lcom/badlogic/ashley/core/Entity;", "deltaTime", "", "kgame2"})
public final class ProjectileAttackSystem
extends IteratingSystem {
    public ProjectileAttackSystem() {
        Class[] classArray = new Class[]{AttackDirectComponent.class, ProjectileComponent.class, PositionComponent.class, VelocityComponent.class};
        super(Family.all(classArray).get());
    }

    @Override
    protected void processEntity(@NotNull Entity entity, float deltaTime) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Entity $this$get$iv = entity;
        boolean $i$f$get = false;
        boolean $i$f$addMapperIfNone = false;
        if (!EntityUtilsKt.getMappers().containsKey(AttackDirectComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", AttackDirectComponent.class), null, null, 0, processEntity$$inlined$get$1.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(AttackDirectComponent.class);
        Intrinsics.checkNotNull(componentMapper);
        Object obj = componentMapper.get($this$get$iv);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.attack.component.skills.AttackDirectComponent");
        }
        AttackDirectComponent attack = (AttackDirectComponent)((Component)((AttackDirectComponent)obj));
        Entity $this$get$iv2 = entity;
        boolean $i$f$get2 = false;
        boolean $i$f$addMapperIfNone2 = false;
        if (!EntityUtilsKt.getMappers().containsKey(ProjectileComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", ProjectileComponent.class), null, null, 0, processEntity$$inlined$get$2.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper2 = EntityUtilsKt.getMappers().get(ProjectileComponent.class);
        Intrinsics.checkNotNull(componentMapper2);
        Object obj2 = componentMapper2.get($this$get$iv2);
        if (obj2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.attack.component.skills.ProjectileComponent");
        }
        ProjectileComponent projectile = (ProjectileComponent)((Component)((ProjectileComponent)obj2));
        Entity $this$get$iv3 = entity;
        boolean $i$f$get3 = false;
        boolean $i$f$addMapperIfNone3 = false;
        if (!EntityUtilsKt.getMappers().containsKey(PositionComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", PositionComponent.class), null, null, 0, processEntity$$inlined$get$3.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper3 = EntityUtilsKt.getMappers().get(PositionComponent.class);
        Intrinsics.checkNotNull(componentMapper3);
        Object obj3 = componentMapper3.get($this$get$iv3);
        if (obj3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.PositionComponent");
        }
        PositionComponent position = (PositionComponent)((Component)((PositionComponent)obj3));
        Entity $this$get$iv4 = entity;
        boolean $i$f$get4 = false;
        boolean $i$f$addMapperIfNone4 = false;
        if (!EntityUtilsKt.getMappers().containsKey(VelocityComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", VelocityComponent.class), null, null, 0, processEntity$$inlined$get$4.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper4 = EntityUtilsKt.getMappers().get(VelocityComponent.class);
        Intrinsics.checkNotNull(componentMapper4);
        Object obj4 = componentMapper4.get($this$get$iv4);
        if (obj4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.physics.VelocityComponent");
        }
        VelocityComponent velocity = (VelocityComponent)((Component)((VelocityComponent)obj4));
        Entity $this$getOrNull$iv = entity;
        boolean $i$f$getOrNull2 = false;
        boolean $i$f$addMapperIfNone5 = false;
        if (!EntityUtilsKt.getMappers().containsKey(HomingComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", HomingComponent.class), null, null, 0, processEntity$$inlined$getOrNull$1.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper5 = EntityUtilsKt.getMappers().get(HomingComponent.class);
        HomingComponent homing = (HomingComponent)((Component)(componentMapper5 == null ? null : componentMapper5.get($this$getOrNull$iv)));
        attack.setDuration(attack.getDuration() + deltaTime);
        if (homing == null) {
            velocity.setSpeed(projectile.getInitialVelocity());
        } else {
            if (homing.getTarget().dst(position.getPos()) < 0.2f) {
                Engine $i$f$getOrNull2 = this.getEngine();
                Intrinsics.checkNotNullExpressionValue($i$f$getOrNull2, "engine");
                Vector2 vector2 = PlayerAttackSystemKt.closestMonsterPos($i$f$getOrNull2, position.getPos());
                if (vector2 == null) {
                    return;
                }
                homing.setTarget(vector2);
            }
            Vector2 initComponent = Vector2Kt.times(projectile.getInitialVelocity(), 1.0f / (attack.getDuration() + 1.0f));
            Vector2 vector2 = Vector2Kt.minus(homing.getTarget(), position.getPos()).nor();
            Intrinsics.checkNotNullExpressionValue(vector2, "homing.target - position.pos).nor()");
            Vector2 homingVelocity = Vector2Kt.times(Vector2Kt.times(vector2, attack.getDuration()), 1.0f / homing.getRampUp());
            vector2 = Vector2Kt.plus(Vector2Kt.times(homingVelocity, homing.getForce()), initComponent).nor().scl(projectile.getSpeed());
            Intrinsics.checkNotNullExpressionValue(vector2, "homingVelocity * homing.\u2026r().scl(projectile.speed)");
            velocity.setSpeed(vector2);
        }
    }
}

