/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.collision.system;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IteratingSystem;
import com.badlogic.gdx.physics.box2d.World;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.ecs.attack.component.skills.AttackAreaComponent;
import org.veiset.kgame.engine.ecs.collision.component.AreaCollisionComponent;
import org.veiset.kgame.engine.ecs.collision.component.AttackCollisionComponent;
import org.veiset.kgame.engine.ecs.core.component.PositionComponent;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/veiset/kgame/engine/ecs/collision/system/AreaCollisionResolveSystem;", "Lcom/badlogic/ashley/systems/IteratingSystem;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "(Lcom/badlogic/gdx/physics/box2d/World;)V", "getWorld", "()Lcom/badlogic/gdx/physics/box2d/World;", "processEntity", "", "entity", "Lcom/badlogic/ashley/core/Entity;", "deltaTime", "", "kgame2"})
public final class AreaCollisionResolveSystem
extends IteratingSystem {
    @NotNull
    private final World world;

    public AreaCollisionResolveSystem(@NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        Class[] classArray = new Class[]{AreaCollisionComponent.class, AttackAreaComponent.class, PositionComponent.class};
        super(Family.all(classArray).get());
        this.world = world;
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    @Override
    protected void processEntity(@NotNull Entity entity, float deltaTime) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Log.INSTANCE.info("Collision resolving");
        entity.remove(AttackCollisionComponent.class);
        this.getEngine().removeEntity(entity);
    }
}

