/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.component.camera;

import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.ecs.core.component.camera.CameraMovementI;
import org.veiset.kgame.engine.ecs.core.component.camera.LinearCameraMove;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0005H\u0016J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000b\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/veiset/kgame/engine/ecs/core/component/camera/CameraShake;", "Lorg/veiset/kgame/engine/ecs/core/component/camera/CameraMovementI;", "direction", "Lcom/badlogic/gdx/math/Vector2;", "intensity", "", "duration", "(Lcom/badlogic/gdx/math/Vector2;FF)V", "getDirection", "()Lcom/badlogic/gdx/math/Vector2;", "getDuration", "()F", "elapsed", "getElapsed", "setElapsed", "(F)V", "getIntensity", "v1", "Lorg/veiset/kgame/engine/ecs/core/component/camera/LinearCameraMove;", "v2", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "offset", "delta", "toString", "", "kgame2"})
public final class CameraShake
implements CameraMovementI {
    @NotNull
    private final Vector2 direction;
    private final float intensity;
    private final float duration;
    private float elapsed;
    @NotNull
    private final LinearCameraMove v1;
    @NotNull
    private final LinearCameraMove v2;

    public CameraShake(@NotNull Vector2 direction, float intensity, float duration) {
        Intrinsics.checkNotNullParameter(direction, "direction");
        this.direction = direction;
        this.intensity = intensity;
        this.duration = duration;
        this.v1 = new LinearCameraMove(Vector2Kt.x(0.0f, 0.0f), Vector2Kt.times(new Vector2(this.intensity, this.intensity), this.direction), this.getDuration() / 2.0f);
        this.v2 = new LinearCameraMove(Vector2Kt.x(0.0f, 0.0f), Vector2Kt.times(new Vector2(-this.intensity, -this.intensity), this.direction), this.getDuration() / 2.0f);
    }

    @NotNull
    public final Vector2 getDirection() {
        return this.direction;
    }

    public final float getIntensity() {
        return this.intensity;
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    @Override
    public float getElapsed() {
        return this.elapsed;
    }

    @Override
    public void setElapsed(float f) {
        this.elapsed = f;
    }

    @Override
    @NotNull
    public Vector2 offset(float delta) {
        this.setElapsed(Math.min(this.getElapsed() + delta, this.getDuration()));
        return this.getElapsed() < this.getDuration() / 2.0f ? this.v1.offset(delta / 2.0f) : this.v2.offset(delta / 2.0f);
    }

    @NotNull
    public final Vector2 component1() {
        return this.direction;
    }

    public final float component2() {
        return this.intensity;
    }

    public final float component3() {
        return this.getDuration();
    }

    @NotNull
    public final CameraShake copy(@NotNull Vector2 direction, float intensity, float duration) {
        Intrinsics.checkNotNullParameter(direction, "direction");
        return new CameraShake(direction, intensity, duration);
    }

    public static /* synthetic */ CameraShake copy$default(CameraShake cameraShake, Vector2 vector2, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = cameraShake.direction;
        }
        if ((n & 2) != 0) {
            f = cameraShake.intensity;
        }
        if ((n & 4) != 0) {
            f2 = cameraShake.getDuration();
        }
        return cameraShake.copy(vector2, f, f2);
    }

    @NotNull
    public String toString() {
        return "CameraShake(direction=" + this.direction + ", intensity=" + this.intensity + ", duration=" + this.getDuration() + ')';
    }

    public int hashCode() {
        int result2 = this.direction.hashCode();
        result2 = result2 * 31 + Float.hashCode(this.intensity);
        result2 = result2 * 31 + Float.hashCode(this.getDuration());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CameraShake)) {
            return false;
        }
        CameraShake cameraShake = (CameraShake)other;
        if (!Intrinsics.areEqual(this.direction, cameraShake.direction)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.intensity), (Object)Float.valueOf(cameraShake.intensity))) {
            return false;
        }
        return Intrinsics.areEqual((Object)Float.valueOf(this.getDuration()), (Object)Float.valueOf(cameraShake.getDuration()));
    }
}

