/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentMapper;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IteratingSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.ecs.core.component.PositionComponent;
import org.veiset.kgame.engine.ecs.core.component.ui.MoveGfxToTargetComponent;
import org.veiset.kgame.engine.ecs.core.component.ui.UiGfxComponent;
import org.veiset.kgame.engine.ecs.core.system.MoveGfxToTargetSystem$processEntity$;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.util.EntityUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/MoveGfxToTargetSystem;", "Lcom/badlogic/ashley/systems/IteratingSystem;", "()V", "processEntity", "", "entity", "Lcom/badlogic/ashley/core/Entity;", "deltaTime", "", "kgame2"})
public final class MoveGfxToTargetSystem
extends IteratingSystem {
    public MoveGfxToTargetSystem() {
        Class[] classArray = new Class[]{MoveGfxToTargetComponent.class, PositionComponent.class, UiGfxComponent.class};
        super(Family.all(classArray).get());
    }

    @Override
    protected void processEntity(@NotNull Entity entity, float deltaTime) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Entity $this$get$iv = entity;
        boolean $i$f$get = false;
        boolean $i$f$addMapperIfNone = false;
        if (!EntityUtilsKt.getMappers().containsKey(MoveGfxToTargetComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", MoveGfxToTargetComponent.class), null, null, 0, processEntity$$inlined$get$1.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(MoveGfxToTargetComponent.class);
        Intrinsics.checkNotNull(componentMapper);
        Object obj = componentMapper.get($this$get$iv);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.ui.MoveGfxToTargetComponent");
        }
        MoveGfxToTargetComponent moveGfx = (MoveGfxToTargetComponent)((Component)((MoveGfxToTargetComponent)obj));
        Entity $this$get$iv2 = entity;
        boolean $i$f$get2 = false;
        boolean $i$f$addMapperIfNone2 = false;
        if (!EntityUtilsKt.getMappers().containsKey(PositionComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", PositionComponent.class), null, null, 0, processEntity$$inlined$get$2.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper2 = EntityUtilsKt.getMappers().get(PositionComponent.class);
        Intrinsics.checkNotNull(componentMapper2);
        Object obj2 = componentMapper2.get($this$get$iv2);
        if (obj2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.PositionComponent");
        }
        PositionComponent position = (PositionComponent)((Component)((PositionComponent)obj2));
        Entity $this$get$iv3 = entity;
        boolean $i$f$get3 = false;
        boolean $i$f$addMapperIfNone3 = false;
        if (!EntityUtilsKt.getMappers().containsKey(UiGfxComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", UiGfxComponent.class), null, null, 0, processEntity$$inlined$get$3.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper3 = EntityUtilsKt.getMappers().get(UiGfxComponent.class);
        Intrinsics.checkNotNull(componentMapper3);
        Object obj3 = componentMapper3.get($this$get$iv3);
        if (obj3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.ui.UiGfxComponent");
        }
        UiGfxComponent uiGfx = (UiGfxComponent)((Component)((UiGfxComponent)obj3));
        moveGfx.setCurrentTime(moveGfx.getCurrentTime() + deltaTime);
        if (moveGfx.getCurrentTime() >= moveGfx.getDuration()) {
            moveGfx.getOnEnd().invoke();
            if (moveGfx.getRemoveOnEnd()) {
                this.getEngine().removeEntity(entity);
            }
            return;
        }
        float currentDelta = moveGfx.getCurrentTime() / moveGfx.getDuration();
        float dx = moveGfx.getInterpolation().apply(currentDelta);
        float xPos = Vector2Kt.lerp(dx, moveGfx.getStartPos().x, moveGfx.getEndPos().x);
        float yPos = Vector2Kt.lerp(dx, moveGfx.getStartPos().y, moveGfx.getEndPos().y);
        float xSize = Vector2Kt.lerp(dx, moveGfx.getStartSize().x, moveGfx.getEndSize().x);
        float ySize = Vector2Kt.lerp(dx, moveGfx.getStartSize().y, moveGfx.getEndSize().y);
        position.setPos(Vector2Kt.x(xPos, yPos));
        uiGfx.setSize(Vector2Kt.x(xSize, ySize));
    }
}

