/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.core.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.ui.ProceedToSummaryUI;
import org.veiset.kgame.engine.util.FontUtilsKt;
import org.veiset.kgame.engine.util.GdxUtilsKt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/PlayerDeathAnimationSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "opened", "", "players", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "sb", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "time", "", "ui", "Lorg/veiset/kgame/engine/ui/ProceedToSummaryUI;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "kgame2"})
public final class PlayerDeathAnimationSystem
extends EntitySystem {
    private ImmutableArray<Entity> players;
    @NotNull
    private final SpriteBatch sb = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
    @NotNull
    private final AssetManager am;
    @NotNull
    private final BitmapFont font;
    private float time;
    @NotNull
    private final ProceedToSummaryUI ui;
    private boolean opened;

    /*
     * WARNING - void declaration
     */
    public PlayerDeathAnimationSystem() {
        BitmapFont bitmapFont;
        void assetRef$iv;
        AssetManager assetManager = this.am = TBEngineKt.getGlobals().getAssetManager();
        AssetRef assetRef = Asset.Font.INSTANCE.getJbb32();
        PlayerDeathAnimationSystem playerDeathAnimationSystem = this;
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        playerDeathAnimationSystem.font = bitmapFont;
        this.ui = new ProceedToSummaryUI();
    }

    @Override
    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Class[] classArray = new Class[]{PlayerCharacterComponent.class};
        ImmutableArray<Entity> immutableArray = engine.getEntitiesFor(Family.one(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.players = immutableArray;
        EngineConfig.Engine.INSTANCE.setSpeed(0.2f);
    }

    @Override
    public void update(float deltaTime) {
        this.time += deltaTime;
        EngineConfig.Engine.INSTANCE.setSpeed(Math.max(EngineConfig.Engine.INSTANCE.getSpeed() - 0.1f * deltaTime, 0.01f));
        TBEngineKt.getGlobals().getDrawGfx().getCamera().zoom = Math.max(TBEngineKt.getGlobals().getDrawGfx().getCamera().zoom - deltaTime, 0.3f);
        if (this.time > 0.02f && !this.opened) {
            this.ui.open();
        }
        if ((double)this.time > 0.04) {
            this.sb.begin();
            GdxUtilsKt.draw(this.font, this.sb, "You have died...", Vector2Kt.dw(FontUtilsKt.middle(this.font, "You have died...")));
            this.sb.end();
        }
        this.ui.draw(deltaTime);
    }
}

