/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.enemy;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.core.component.enemy.BossComponent;
import org.veiset.kgame.engine.ecs.core.component.stats.HealthComponent;
import org.veiset.kgame.engine.ecs.core.system.Mapper;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.util.FontUtilsKt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/enemy/BossHealthBarSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "boss", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "draw", "name", "", "health", "Lorg/veiset/kgame/engine/ecs/core/component/stats/HealthComponent;", "update", "deltaTime", "", "kgame2"})
public final class BossHealthBarSystem
extends EntitySystem {
    private ImmutableArray<Entity> boss;
    @NotNull
    private final AssetManager am = TBEngineKt.getGlobals().getAssetManager();

    @Override
    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Class[] classArray = new Class[]{BossComponent.class, HealthComponent.class};
        ImmutableArray<Entity> immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.boss = immutableArray;
    }

    @Override
    public void update(float deltaTime) {
        ImmutableArray<Entity> immutableArray = this.boss;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException("boss");
            immutableArray = null;
        }
        Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)immutableArray);
        if (entity == null) {
            return;
        }
        Entity boss = entity;
        BossComponent bossComponent = boss.getComponent(BossComponent.class);
        HealthComponent health = Mapper.INSTANCE.getHealth().get(boss);
        String string2 = bossComponent.getName();
        Intrinsics.checkNotNullExpressionValue(health, "health");
        this.draw(string2, health);
    }

    /*
     * WARNING - void declaration
     */
    public final void draw(@NotNull String name, @NotNull HealthComponent health) {
        BitmapFont bitmapFont;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(health, "health");
        AssetManager assetManager = this.am;
        AssetRef assetRef$iv = Asset.Font.INSTANCE.getJbb32();
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        BitmapFont font = bitmapFont;
        SpriteBatch sb = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
        ShapeRenderer sr = TBEngineKt.getGlobals().getDrawUi().getShapeRenderer();
        String text = String.valueOf(name);
        float remindingHealthP = health.getCurrentHealth() / health.getMaxHealth();
        float healthLength = Vector2Kt.lerp(remindingHealthP, 0.0f, 16.0f);
        Vector2 textpos = FontUtilsKt.middle(font, text);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        sr.begin(ShapeRenderer.ShapeType.Filled);
        sr.setColor(ColorKt.color(1.0f, 0.0f, 0.0f, 0.6f));
        ShapeRendererKt.rect(sr, Vector2Kt.dw(Vector2Kt.x(0.0f, 8.7f)), Vector2Kt.dw(Vector2Kt.x(healthLength, 9.0f)));
        sr.setColor(ColorKt.color(0.0f, 0.0f, 0.0f, 0.6f));
        ShapeRendererKt.rect(sr, Vector2Kt.dw(Vector2Kt.x(healthLength, 8.7f)), Vector2Kt.dw(Vector2Kt.x(16.0f, 9.0f)));
        sr.end();
        sb.begin();
        font.draw((Batch)sb, text, textpos.x * 120.0f, 1074.0f);
        sb.end();
        Gdx.gl.glDisable(3042);
    }
}

