/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.enemy;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.core.component.PositionComponent;
import org.veiset.kgame.engine.ecs.core.component.enemy.ArrowMarkerComponent;
import org.veiset.kgame.engine.ecs.core.component.enemy.MonsterComponent;
import org.veiset.kgame.engine.ecs.core.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.core.system.MapperNullable;
import org.veiset.kgame.engine.ui.ProceedToNextLevelUI;
import org.veiset.kgame.engine.util.FontUtilsKt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0017J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/enemy/EnemyRemindingSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "clearTriggered", "", "cleared", "getCleared", "()Z", "setCleared", "(Z)V", "enemies", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "players", "remindingMonsters", "", "getRemindingMonsters", "()I", "setRemindingMonsters", "(I)V", "time", "", "ui", "Lorg/veiset/kgame/engine/ui/ProceedToNextLevelUI;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "draw", "deltaTime", "update", "kgame2"})
public final class EnemyRemindingSystem
extends EntitySystem {
    @NotNull
    private final AssetManager am = TBEngineKt.getGlobals().getAssetManager();
    private ImmutableArray<Entity> enemies;
    private ImmutableArray<Entity> players;
    private float time;
    private boolean cleared;
    private int remindingMonsters = 1000;
    private boolean clearTriggered;
    @NotNull
    private final ProceedToNextLevelUI ui = new ProceedToNextLevelUI();

    @Override
    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Class[] classArray = new Class[]{MonsterComponent.class};
        ImmutableArray<Entity> immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.enemies = immutableArray;
        classArray = new Class[]{PlayerCharacterComponent.class, PositionComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.players = immutableArray;
    }

    public final boolean getCleared() {
        return this.cleared;
    }

    public final void setCleared(boolean bl) {
        this.cleared = bl;
    }

    public final int getRemindingMonsters() {
        return this.remindingMonsters;
    }

    public final void setRemindingMonsters(int n) {
        this.remindingMonsters = n;
    }

    @Override
    public void update(float deltaTime) {
        ImmutableArray<Entity> immutableArray;
        this.time += deltaTime;
        ImmutableArray<Entity> immutableArray2 = this.players;
        if (immutableArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("players");
            immutableArray2 = null;
        }
        Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)immutableArray2);
        if (entity == null) {
            return;
        }
        Entity player = entity;
        ImmutableArray<Entity> immutableArray3 = this.enemies;
        if (immutableArray3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("enemies");
            immutableArray3 = null;
        }
        if (immutableArray3.size() <= 3) {
            ImmutableArray<Entity> immutableArray4 = this.enemies;
            if (immutableArray4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("enemies");
                immutableArray4 = null;
            }
            Iterable $this$forEach$iv = immutableArray4;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entity it = (Entity)element$iv;
                boolean bl = false;
                if (MapperNullable.INSTANCE.getArrowMarker().get(it) != null) continue;
                Color color = Color.RED;
                Intrinsics.checkNotNullExpressionValue(color, "RED");
                it.add(new ArrowMarkerComponent(color, 0.7f, 0.0f, 4, null));
            }
        }
        if (this.time >= 1.0f) {
            ImmutableArray<Entity> immutableArray5 = this.enemies;
            if (immutableArray5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("enemies");
                immutableArray5 = null;
            }
            this.remindingMonsters = immutableArray5.size();
        }
        if ((immutableArray = this.enemies) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("enemies");
            immutableArray = null;
        }
        if (immutableArray.size() == 0 && this.time >= 1.0f) {
            if (!this.clearTriggered) {
                this.clearTriggered = true;
                this.ui.open();
            }
            this.draw(deltaTime);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void draw(float deltaTime) {
        BitmapFont bitmapFont;
        AssetManager assetManager = this.am;
        AssetRef assetRef$iv = Asset.Font.INSTANCE.getRetron46();
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        BitmapFont font = bitmapFont;
        SpriteBatch sb = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
        String text = "Level cleared!";
        Vector2 textpos = FontUtilsKt.middle(font, text);
        sb.begin();
        font.draw((Batch)sb, text, textpos.x * 120.0f, (textpos.y - 1.0f) * 120.0f);
        sb.end();
        this.ui.draw(deltaTime);
    }
}

