/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.enemy;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentMapper;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.core.component.PositionComponent;
import org.veiset.kgame.engine.ecs.core.component.draw.DynamicAnimationComponent;
import org.veiset.kgame.engine.ecs.core.component.enemy.ArrowMarkerComponent;
import org.veiset.kgame.engine.ecs.core.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.core.system.Mapper;
import org.veiset.kgame.engine.ecs.core.system.enemy.PointToEnemySystem$update$;
import org.veiset.kgame.engine.ecs.core.system.enemy.PointToEnemySystem$update$lambda-0$;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.util.EntityUtilsKt;
import org.veiset.kgame.engine.util.GdxUtilsKt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/enemy/PointToEnemySystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "arrowSize", "", "markers", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "playerCharacter", "sb", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "texture", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "time", "getTime", "()F", "setTime", "(F)V", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "kgame2"})
public final class PointToEnemySystem
extends EntitySystem {
    private ImmutableArray<Entity> playerCharacter;
    private ImmutableArray<Entity> markers;
    @NotNull
    private final SpriteBatch sb = TBEngineKt.getGlobals().getDrawGfx().getSpriteBatch();
    @NotNull
    private final TextureRegion texture;
    private final float arrowSize;
    private float time;

    /*
     * WARNING - void declaration
     */
    public PointToEnemySystem() {
        TextureRegion textureRegion;
        void assetRef$iv;
        AssetManager assetManager = TBEngineKt.getGlobals().getAssetManager();
        AssetRef assetRef = Asset.Texture.INSTANCE.getArrow();
        PointToEnemySystem pointToEnemySystem = this;
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        pointToEnemySystem.texture = textureRegion;
        this.arrowSize = 0.3f;
    }

    @Override
    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Class[] classArray = new Class[]{PlayerCharacterComponent.class};
        ImmutableArray<Entity> immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.playerCharacter = immutableArray;
        classArray = new Class[]{ArrowMarkerComponent.class, PositionComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.markers = immutableArray;
    }

    public final float getTime() {
        return this.time;
    }

    public final void setTime(float f) {
        this.time = f;
    }

    @Override
    public void update(float deltaTime) {
        ImmutableArray<Entity> immutableArray = this.playerCharacter;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException("playerCharacter");
            immutableArray = null;
        }
        if (immutableArray.size() == 0) {
            return;
        }
        this.time = (this.time + deltaTime) % Float.MAX_VALUE;
        ImmutableArray<Entity> immutableArray2 = this.playerCharacter;
        if (immutableArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("playerCharacter");
            immutableArray2 = null;
        }
        Entity entity = immutableArray2.first();
        Intrinsics.checkNotNullExpressionValue(entity, "playerCharacter.first()");
        Entity $this$get$iv = entity;
        boolean $i$f$get = false;
        boolean $i$f$addMapperIfNone = false;
        if (!EntityUtilsKt.getMappers().containsKey(PositionComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", PositionComponent.class), null, null, 0, update$$inlined$get$1.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(PositionComponent.class);
        Intrinsics.checkNotNull(componentMapper);
        Object obj = componentMapper.get($this$get$iv);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.PositionComponent");
        }
        Vector2 playerPos = Vector2Kt.copy(((PositionComponent)((Component)((PositionComponent)obj))).getPos());
        ImmutableArray<Entity> immutableArray3 = this.markers;
        if (immutableArray3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("markers");
            immutableArray3 = null;
        }
        Iterable $this$forEach$iv = immutableArray3;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            Vector2 monsterPos = Mapper.INSTANCE.getPosition().get(it).getPos();
            float distance = playerPos.dst(monsterPos);
            Intrinsics.checkNotNullExpressionValue(it, "it");
            Entity $this$get$iv2 = it;
            boolean $i$f$get2 = false;
            boolean $i$f$addMapperIfNone22 = false;
            if (!EntityUtilsKt.getMappers().containsKey(ArrowMarkerComponent.class)) {
                LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", ArrowMarkerComponent.class), null, null, 0, update$lambda-0$$inlined$get$1.INSTANCE, 14, null);
            }
            ComponentMapper<?> componentMapper2 = EntityUtilsKt.getMappers().get(ArrowMarkerComponent.class);
            Intrinsics.checkNotNull(componentMapper2);
            Object obj2 = componentMapper2.get($this$get$iv2);
            if (obj2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.enemy.ArrowMarkerComponent");
            }
            ArrowMarkerComponent marker = (ArrowMarkerComponent)((Component)((ArrowMarkerComponent)obj2));
            float animationOffset = (float)Math.cos((this.getTime() + marker.getFloatOffset()) * 6.0f) * 0.1f;
            this.sb.begin();
            Color $i$f$addMapperIfNone22 = this.sb.getColor();
            Intrinsics.checkNotNullExpressionValue($i$f$addMapperIfNone22, "sb.color");
            Color c = ColorKt.copy$default($i$f$addMapperIfNone22, null, null, null, null, 15, null);
            this.sb.setColor(ColorKt.color(marker.getColor().r, marker.getColor().g, marker.getColor().b, marker.getOpacity()));
            if (distance < 3.5f) {
                float f;
                Entity $this$getOrNull$iv = it;
                boolean $i$f$getOrNull = false;
                boolean $i$f$addMapperIfNone3 = false;
                if (!EntityUtilsKt.getMappers().containsKey(DynamicAnimationComponent.class)) {
                    LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", DynamicAnimationComponent.class), null, null, 0, update$lambda-0$$inlined$getOrNull$1.INSTANCE, 14, null);
                }
                ComponentMapper<?> componentMapper3 = EntityUtilsKt.getMappers().get(DynamicAnimationComponent.class);
                DynamicAnimationComponent dynamicAnimationComponent = (DynamicAnimationComponent)((Component)(componentMapper3 == null ? null : componentMapper3.get($this$getOrNull$iv)));
                if (dynamicAnimationComponent == null) {
                    f = 0.0f;
                } else {
                    Vector2 vector2 = dynamicAnimationComponent.getSize();
                    if (vector2 == null) {
                        f = 0.0f;
                    } else {
                        float f2;
                        float f3 = vector2.x;
                        f = f2 = f3 / 4.0f;
                    }
                }
                float bodyWidth = f;
                GdxUtilsKt.draw(this.sb, this.texture, Vector2Kt.dw(Vector2Kt.plus(monsterPos, Vector2Kt.x(-bodyWidth, 0.8f + animationOffset))), Vector2Kt.dw(Vector2Kt.x(this.arrowSize, this.arrowSize)), 90.0f);
            } else {
                Vector2 vector2 = Vector2Kt.copy(Vector2Kt.minus(monsterPos, playerPos)).nor().scl(3.0f + animationOffset);
                Intrinsics.checkNotNullExpressionValue(vector2, "monsterPos - playerPos).\u2026scl(3f + animationOffset)");
                Vector2 p = Vector2Kt.plus(playerPos, vector2);
                float angle = Vector2Kt.minus(playerPos, monsterPos).angleDeg();
                GdxUtilsKt.draw(this.sb, this.texture, Vector2Kt.dw(p), Vector2Kt.dw(Vector2Kt.x(this.arrowSize, this.arrowSize)), angle);
            }
            this.sb.end();
            this.sb.setColor(c);
        }
    }
}

