/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.graphics;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.ecs.core.component.draw.Direction;
import org.veiset.kgame.engine.ecs.core.system.graphics.DrawInstruction;
import org.veiset.kgame.engine.ecs.core.system.graphics.DrawSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\t\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\tH\u00c6\u0003J\t\u0010'\u001a\u00020\u000fH\u00c6\u0003Jc\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0003H\u0016J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J\t\u00100\u001a\u00020\u0005H\u00d6\u0001J\t\u00101\u001a\u000202H\u00d6\u0001R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018\u00a8\u00063"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/graphics/DrawSprite;", "Lorg/veiset/kgame/engine/ecs/core/system/graphics/DrawInstruction;", "y", "", "layer", "", "texture", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "size", "Lcom/badlogic/gdx/math/Vector2;", "position", "rotation", "opacity", "offset", "direction", "Lorg/veiset/kgame/engine/ecs/core/component/draw/Direction;", "(FILcom/badlogic/gdx/graphics/g2d/TextureRegion;Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;FFLcom/badlogic/gdx/math/Vector2;Lorg/veiset/kgame/engine/ecs/core/component/draw/Direction;)V", "getDirection", "()Lorg/veiset/kgame/engine/ecs/core/component/draw/Direction;", "getLayer", "()I", "getOffset", "()Lcom/badlogic/gdx/math/Vector2;", "getOpacity", "()F", "getPosition", "getRotation", "getSize", "getTexture", "()Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "getY", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "draw", "", "delta", "equals", "", "other", "", "hashCode", "toString", "", "kgame2"})
public final class DrawSprite
implements DrawInstruction {
    private final float y;
    private final int layer;
    @NotNull
    private final TextureRegion texture;
    @NotNull
    private final Vector2 size;
    @NotNull
    private final Vector2 position;
    private final float rotation;
    private final float opacity;
    @NotNull
    private final Vector2 offset;
    @NotNull
    private final Direction direction;

    public DrawSprite(float y, int layer, @NotNull TextureRegion texture, @NotNull Vector2 size, @NotNull Vector2 position, float rotation, float opacity, @NotNull Vector2 offset, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter(texture, "texture");
        Intrinsics.checkNotNullParameter(size, "size");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(offset, "offset");
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        this.y = y;
        this.layer = layer;
        this.texture = texture;
        this.size = size;
        this.position = position;
        this.rotation = rotation;
        this.opacity = opacity;
        this.offset = offset;
        this.direction = direction;
    }

    public /* synthetic */ DrawSprite(float f, int n, TextureRegion textureRegion, Vector2 vector2, Vector2 vector22, float f2, float f3, Vector2 vector23, Direction direction, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            f2 = 0.0f;
        }
        if ((n2 & 0x40) != 0) {
            f3 = 1.0f;
        }
        if ((n2 & 0x80) != 0) {
            vector23 = Vector2Kt.x(0.0f, 0.0f);
        }
        if ((n2 & 0x100) != 0) {
            direction = Direction.RIGHT;
        }
        this(f, n, textureRegion, vector2, vector22, f2, f3, vector23, direction);
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public int getLayer() {
        return this.layer;
    }

    @NotNull
    public final TextureRegion getTexture() {
        return this.texture;
    }

    @NotNull
    public final Vector2 getSize() {
        return this.size;
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    public final float getRotation() {
        return this.rotation;
    }

    public final float getOpacity() {
        return this.opacity;
    }

    @NotNull
    public final Vector2 getOffset() {
        return this.offset;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    @Override
    public void draw(float delta) {
        Color c;
        Vector2 vector2 = this.position;
        float x = Vector2Kt.component1(vector2);
        float y = Vector2Kt.component2(vector2);
        Vector2 vector22 = this.size;
        float sx = Vector2Kt.component1(vector22);
        float sy = Vector2Kt.component2(vector22);
        Vector2 vector23 = this.offset;
        float ox = Vector2Kt.component1(vector23);
        float oy = Vector2Kt.component2(vector23);
        if (!(this.opacity == 1.0f)) {
            c = DrawSystemKt.access$getSpriteBatch$p().getColor();
            DrawSystemKt.access$getSpriteBatch$p().setColor(c.r, c.g, c.b, this.opacity);
        }
        if (!(this.rotation == 0.0f)) {
            if (this.direction == Direction.RIGHT) {
                DrawSystemKt.access$getSpriteBatch$p().draw(this.texture, (x + ox - sx / 2.0f) * 120.0f, (y + oy - sy / 2.0f) * 120.0f, (sx + ox) / 2.0f * 120.0f, (sy + oy) / 2.0f * 120.0f, sx * 120.0f, sy * 120.0f, 1.0f, 1.0f, this.rotation);
            } else if (this.direction == Direction.LEFT) {
                DrawSystemKt.access$getSpriteBatch$p().draw(this.texture, (x + ox - sx / 2.0f + sx) * 120.0f, (y + oy - sy / 2.0f) * 120.0f, (sx + ox) / 2.0f * 120.0f, (sy + oy) / 2.0f * 120.0f, -sx * 120.0f, sy * 120.0f, 1.0f, 1.0f, this.rotation);
            }
        } else if (this.direction == Direction.RIGHT) {
            DrawSystemKt.access$getSpriteBatch$p().draw(this.texture, (x + ox - sx / 2.0f) * 120.0f, (y + oy - sy / 2.0f) * 120.0f, sx * 120.0f, sy * 120.0f);
        } else if (this.direction == Direction.LEFT) {
            DrawSystemKt.access$getSpriteBatch$p().draw(this.texture, (x + ox - sx / 2.0f + sx) * 120.0f, (y + oy - sy / 2.0f) * 120.0f, -sx * 120.0f, sy * 120.0f);
        }
        if (!(this.opacity == 1.0f)) {
            c = DrawSystemKt.access$getSpriteBatch$p().getColor();
            DrawSystemKt.access$getSpriteBatch$p().setColor(c.r, c.g, c.b, 1.0f);
        }
    }

    public final float component1() {
        return this.getY();
    }

    public final int component2() {
        return this.getLayer();
    }

    @NotNull
    public final TextureRegion component3() {
        return this.texture;
    }

    @NotNull
    public final Vector2 component4() {
        return this.size;
    }

    @NotNull
    public final Vector2 component5() {
        return this.position;
    }

    public final float component6() {
        return this.rotation;
    }

    public final float component7() {
        return this.opacity;
    }

    @NotNull
    public final Vector2 component8() {
        return this.offset;
    }

    @NotNull
    public final Direction component9() {
        return this.direction;
    }

    @NotNull
    public final DrawSprite copy(float y, int layer, @NotNull TextureRegion texture, @NotNull Vector2 size, @NotNull Vector2 position, float rotation, float opacity, @NotNull Vector2 offset, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter(texture, "texture");
        Intrinsics.checkNotNullParameter(size, "size");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(offset, "offset");
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        return new DrawSprite(y, layer, texture, size, position, rotation, opacity, offset, direction);
    }

    public static /* synthetic */ DrawSprite copy$default(DrawSprite drawSprite, float f, int n, TextureRegion textureRegion, Vector2 vector2, Vector2 vector22, float f2, float f3, Vector2 vector23, Direction direction, int n2, Object object) {
        if ((n2 & 1) != 0) {
            f = drawSprite.getY();
        }
        if ((n2 & 2) != 0) {
            n = drawSprite.getLayer();
        }
        if ((n2 & 4) != 0) {
            textureRegion = drawSprite.texture;
        }
        if ((n2 & 8) != 0) {
            vector2 = drawSprite.size;
        }
        if ((n2 & 0x10) != 0) {
            vector22 = drawSprite.position;
        }
        if ((n2 & 0x20) != 0) {
            f2 = drawSprite.rotation;
        }
        if ((n2 & 0x40) != 0) {
            f3 = drawSprite.opacity;
        }
        if ((n2 & 0x80) != 0) {
            vector23 = drawSprite.offset;
        }
        if ((n2 & 0x100) != 0) {
            direction = drawSprite.direction;
        }
        return drawSprite.copy(f, n, textureRegion, vector2, vector22, f2, f3, vector23, direction);
    }

    @NotNull
    public String toString() {
        return "DrawSprite(y=" + this.getY() + ", layer=" + this.getLayer() + ", texture=" + this.texture + ", size=" + this.size + ", position=" + this.position + ", rotation=" + this.rotation + ", opacity=" + this.opacity + ", offset=" + this.offset + ", direction=" + (Object)((Object)this.direction) + ')';
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.getY());
        result2 = result2 * 31 + Integer.hashCode(this.getLayer());
        result2 = result2 * 31 + this.texture.hashCode();
        result2 = result2 * 31 + this.size.hashCode();
        result2 = result2 * 31 + this.position.hashCode();
        result2 = result2 * 31 + Float.hashCode(this.rotation);
        result2 = result2 * 31 + Float.hashCode(this.opacity);
        result2 = result2 * 31 + this.offset.hashCode();
        result2 = result2 * 31 + this.direction.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DrawSprite)) {
            return false;
        }
        DrawSprite drawSprite = (DrawSprite)other;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.getY()), (Object)Float.valueOf(drawSprite.getY()))) {
            return false;
        }
        if (this.getLayer() != drawSprite.getLayer()) {
            return false;
        }
        if (!Intrinsics.areEqual(this.texture, drawSprite.texture)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.size, drawSprite.size)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.position, drawSprite.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.rotation), (Object)Float.valueOf(drawSprite.rotation))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.opacity), (Object)Float.valueOf(drawSprite.opacity))) {
            return false;
        }
        if (!Intrinsics.areEqual(this.offset, drawSprite.offset)) {
            return false;
        }
        return this.direction == drawSprite.direction;
    }
}

