/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.graphics;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.core.component.PositionComponent;
import org.veiset.kgame.engine.ecs.core.component.draw.ShapeCircleGfxComponent;
import org.veiset.kgame.engine.ecs.core.component.draw.ShapeGfxComponent;
import org.veiset.kgame.engine.ecs.core.component.stats.HealthBarComponent;
import org.veiset.kgame.engine.ecs.core.component.stats.HealthComponent;
import org.veiset.kgame.engine.ecs.core.system.Mapper;
import org.veiset.kgame.engine.ecs.core.system.graphics.DrawInstruction;
import org.veiset.kgame.engine.ecs.core.system.graphics.DrawSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u001a\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u001a\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u001a\u0014\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u001a\u0014\u0010\u0012\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u001a\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u001a\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u001a\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u001a\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u001a\u001a\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"camera", "Lcom/badlogic/gdx/graphics/OrthographicCamera;", "shapeRenderer", "Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "spriteBatch", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "animationDrawInstruction", "Lkotlin/sequences/Sequence;", "Lorg/veiset/kgame/engine/ecs/core/system/graphics/DrawInstruction;", "animations", "Lcom/badlogic/ashley/core/Entity;", "drawAnimationFrameInstruction", "sprites", "drawCircleShape", "", "shapes", "drawHealthBars", "healthBars", "drawShapes", "spriteDrawInstructions", "statsLabelsDrawInstructions", "textLabels", "textLabelsDrawInstructions", "textureShadowDrawInstructions", "animationShadows", "shouldRender", "", "Lcom/badlogic/gdx/graphics/Camera;", "position", "Lcom/badlogic/gdx/math/Vector2;", "size", "kgame2"})
public final class DrawSystemKt {
    @NotNull
    private static final OrthographicCamera camera = TBEngineKt.getGlobals().getDrawGfx().getCamera();
    @NotNull
    private static final ShapeRenderer shapeRenderer = TBEngineKt.getGlobals().getDrawGfx().getShapeRenderer();
    @NotNull
    private static final SpriteBatch spriteBatch = TBEngineKt.getGlobals().getDrawGfx().getSpriteBatch();

    @NotNull
    public static final Sequence<DrawInstruction> animationDrawInstruction(@NotNull Sequence<? extends Entity> animations) {
        Intrinsics.checkNotNullParameter(animations, "animations");
        return SequencesKt.map(animations, animationDrawInstruction.1.INSTANCE);
    }

    @NotNull
    public static final Sequence<DrawInstruction> drawAnimationFrameInstruction(@NotNull Sequence<? extends Entity> sprites) {
        Intrinsics.checkNotNullParameter(sprites, "sprites");
        return SequencesKt.map(sprites, drawAnimationFrameInstruction.1.INSTANCE);
    }

    @NotNull
    public static final Sequence<DrawInstruction> spriteDrawInstructions(@NotNull Sequence<? extends Entity> sprites) {
        Intrinsics.checkNotNullParameter(sprites, "sprites");
        return SequencesKt.map(sprites, spriteDrawInstructions.1.INSTANCE);
    }

    @NotNull
    public static final Sequence<DrawInstruction> textureShadowDrawInstructions(@NotNull Sequence<? extends Entity> animationShadows) {
        Intrinsics.checkNotNullParameter(animationShadows, "animationShadows");
        return SequencesKt.mapNotNull(animationShadows, textureShadowDrawInstructions.1.INSTANCE);
    }

    public static final void drawShapes(@NotNull Sequence<? extends Entity> shapes) {
        Intrinsics.checkNotNullParameter(shapes, "shapes");
        Sequence<? extends Entity> $this$forEach$iv = shapes;
        boolean $i$f$forEach = false;
        Iterator<? extends Entity> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Entity element$iv;
            Entity entity = element$iv = iterator2.next();
            boolean bl = false;
            ShapeGfxComponent shape = Mapper.INSTANCE.getShapeGfx().get(entity);
            PositionComponent position = Mapper.INSTANCE.getPosition().get(entity);
            shapeRenderer.setColor(shape.getColor());
            Vector2 vector2 = Vector2Kt.dw(position.getPos());
            Vector2 vector22 = Vector2Kt.dw(shape.getSize()).scl(0.5f);
            Intrinsics.checkNotNullExpressionValue(vector22, "shape.size.dw().scl(0.5f)");
            ShapeRendererKt.rect(shapeRenderer, Vector2Kt.minus(vector2, vector22), Vector2Kt.dw(shape.getSize()));
        }
    }

    public static final void drawCircleShape(@NotNull Sequence<? extends Entity> shapes) {
        Intrinsics.checkNotNullParameter(shapes, "shapes");
        Sequence<? extends Entity> $this$forEach$iv = shapes;
        boolean $i$f$forEach = false;
        Iterator<? extends Entity> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Entity element$iv;
            Entity entity = element$iv = iterator2.next();
            boolean bl = false;
            ShapeCircleGfxComponent shape = Mapper.INSTANCE.getCircleShapeGfx().get(entity);
            PositionComponent position = Mapper.INSTANCE.getPosition().get(entity);
            shapeRenderer.setColor(shape.getColor());
            Vector2 vector2 = Vector2Kt.dw(position.getPos());
            float x = Vector2Kt.component1(vector2);
            float y = Vector2Kt.component2(vector2);
            shapeRenderer.circle(x, y, shape.getSize() * 120.0f);
        }
    }

    @NotNull
    public static final Sequence<DrawInstruction> textLabelsDrawInstructions(@NotNull Sequence<? extends Entity> textLabels) {
        Intrinsics.checkNotNullParameter(textLabels, "textLabels");
        return SequencesKt.map(textLabels, textLabelsDrawInstructions.1.INSTANCE);
    }

    @NotNull
    public static final Sequence<DrawInstruction> statsLabelsDrawInstructions(@NotNull Sequence<? extends Entity> textLabels) {
        Intrinsics.checkNotNullParameter(textLabels, "textLabels");
        return SequencesKt.map(textLabels, statsLabelsDrawInstructions.1.INSTANCE);
    }

    public static final void drawHealthBars(@NotNull Sequence<? extends Entity> healthBars) {
        Intrinsics.checkNotNullParameter(healthBars, "healthBars");
        Sequence<? extends Entity> $this$forEach$iv = healthBars;
        boolean $i$f$forEach = false;
        Iterator<? extends Entity> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Entity element$iv;
            Entity entity = element$iv = iterator2.next();
            boolean bl = false;
            Vector2 pos = Mapper.INSTANCE.getPosition().get(entity).getPos();
            HealthBarComponent healthBar = Mapper.INSTANCE.getHealthBar().get(entity);
            Vector2 vector2 = healthBar.getSize();
            float xh = Vector2Kt.component1(vector2);
            float yh = Vector2Kt.component2(vector2);
            Vector2 offset = healthBar.getOffset();
            Vector2 healthbarPos = Vector2Kt.plus(pos, offset);
            Vector2 healthbarSize = new Vector2(xh, yh);
            HealthComponent health = Mapper.INSTANCE.getHealth().get(entity);
            if (!GameFilesKt.getGameConfig().getGameDisplayHealthOnFull() && health.isFullHealth()) continue;
            float remindingHealthP = health.getCurrentHealth() / health.getMaxHealth();
            Vector2 healthbarReminding = Vector2Kt.dw(new Vector2(Math.max(0.0f, xh * remindingHealthP), yh));
            shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
            shapeRenderer.setColor(Color.RED);
            ShapeRendererKt.rect(shapeRenderer, Vector2Kt.dw(healthbarPos), healthbarReminding);
            shapeRenderer.end();
            shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
            shapeRenderer.setColor(Color.BLACK);
            ShapeRendererKt.rect(shapeRenderer, Vector2Kt.dw(healthbarPos), Vector2Kt.dw(healthbarSize));
            shapeRenderer.end();
        }
    }

    public static final boolean shouldRender(@NotNull Camera $this$shouldRender, @NotNull Vector2 position, @NotNull Vector2 size) {
        Intrinsics.checkNotNullParameter($this$shouldRender, "<this>");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(size, "size");
        if (GameFilesKt.getGameConfig().getPerformanceDrawOutsideViewport()) {
            return true;
        }
        float gameWidth = 16.2f;
        float gameHeight = 9.2f;
        float cameraX = $this$shouldRender.position.x / 120.0f - gameWidth / 2.0f;
        float cameraY = $this$shouldRender.position.y / 120.0f - gameHeight / 2.0f;
        float x = Vector2Kt.component1(position);
        float y = Vector2Kt.component2(position);
        float xs = Vector2Kt.component1(size);
        float ys = Vector2Kt.component2(size);
        boolean shouldNotRender = x + xs < cameraX || x - xs > cameraX + gameWidth || y + ys < cameraY || y - ys > cameraY + gameHeight;
        return !shouldNotRender;
    }

    public static final /* synthetic */ SpriteBatch access$getSpriteBatch$p() {
        return spriteBatch;
    }

    public static final /* synthetic */ ShapeRenderer access$getShapeRenderer$p() {
        return shapeRenderer;
    }

    public static final /* synthetic */ OrthographicCamera access$getCamera$p() {
        return camera;
    }
}

