/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.loot;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentMapper;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.core.component.PositionComponent;
import org.veiset.kgame.engine.ecs.core.component.ai.LinearMoveAIComponent;
import org.veiset.kgame.engine.ecs.core.component.draw.LightStaticComponent;
import org.veiset.kgame.engine.ecs.core.component.draw.SpriteGfxComponent;
import org.veiset.kgame.engine.ecs.core.component.loot.EquipmentComponent;
import org.veiset.kgame.engine.ecs.core.component.loot.PickableLootComponent;
import org.veiset.kgame.engine.ecs.core.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.core.component.player.InventoryComponent;
import org.veiset.kgame.engine.ecs.core.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.core.entity.ItemDropEntity;
import org.veiset.kgame.engine.ecs.core.system.Mapper;
import org.veiset.kgame.engine.ecs.core.system.loot.PickupLootSystem$hoverOverItem$;
import org.veiset.kgame.engine.ecs.core.system.loot.PickupLootSystem$update$lambda-0$;
import org.veiset.kgame.engine.ecs.core.system.loot.PickupLootSystemKt;
import org.veiset.kgame.engine.ecs.core.system.player.ColoredMods;
import org.veiset.kgame.engine.ecs.core.system.player.InventorySystemKt;
import org.veiset.kgame.engine.item.CompareResult;
import org.veiset.kgame.engine.item.Equipment;
import org.veiset.kgame.engine.item.ItemKt;
import org.veiset.kgame.engine.item.Weapon;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.util.EntityUtilsKt;
import org.veiset.kgame.engine.util.TargetType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/loot/PickupLootSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "inventories", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "itemDrops", "players", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "charOverItem", "", "playerPos", "Lcom/badlogic/gdx/math/Vector2;", "box", "boxSize", "hoverOverItem", "entity", "equipped", "Lorg/veiset/kgame/engine/item/Equipment;", "update", "deltaTime", "", "kgame2"})
public final class PickupLootSystem
extends EntitySystem {
    private ImmutableArray<Entity> inventories;
    private ImmutableArray<Entity> itemDrops;
    private ImmutableArray<Entity> players;

    @Override
    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Class[] classArray = new Class[]{InventoryComponent.class};
        ImmutableArray<Entity> immutableArray = engine.getEntitiesFor(Family.one(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.inventories = immutableArray;
        classArray = new Class[]{EquipmentComponent.class, PickableLootComponent.class, PositionComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.itemDrops = immutableArray;
        classArray = new Class[]{PlayerCharacterComponent.class, PositionComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.players = immutableArray;
    }

    @Override
    public void update(float deltaTime) {
        ImmutableArray<Entity> immutableArray = this.inventories;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException("inventories");
            immutableArray = null;
        }
        Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)immutableArray);
        if (entity == null) {
            return;
        }
        Entity inventoryEntity = entity;
        InventoryComponent inventoryComponent = Mapper.INSTANCE.getInventory().get(inventoryEntity);
        if (inventoryComponent == null) {
            return;
        }
        InventoryComponent inventory = inventoryComponent;
        ImmutableArray<Entity> immutableArray2 = this.players;
        if (immutableArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("players");
            immutableArray2 = null;
        }
        Entity entity2 = (Entity)CollectionsKt.firstOrNull((Iterable)immutableArray2);
        if (entity2 == null) {
            return;
        }
        Entity player = entity2;
        PositionComponent playerPos = Mapper.INSTANCE.getPosition().get(player);
        ImmutableArray<Entity> immutableArray3 = this.itemDrops;
        if (immutableArray3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("itemDrops");
            immutableArray3 = null;
        }
        Iterable $this$forEach$iv = immutableArray3;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity itemEntity = (Entity)element$iv;
            boolean bl = false;
            Vector2 position = Mapper.INSTANCE.getPosition().get(itemEntity).getPos();
            SpriteGfxComponent gfx = Mapper.INSTANCE.getSpriteGfx().get(itemEntity);
            Intrinsics.checkNotNullExpressionValue(itemEntity, "itemEntity");
            Entity $this$get$iv = itemEntity;
            boolean $i$f$get = false;
            boolean $i$f$addMapperIfNone = false;
            if (!EntityUtilsKt.getMappers().containsKey(EquipmentComponent.class)) {
                LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", EquipmentComponent.class), null, null, 0, update$lambda-0$$inlined$get$1.INSTANCE, 14, null);
            }
            ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(EquipmentComponent.class);
            Intrinsics.checkNotNull(componentMapper);
            Object obj = componentMapper.get($this$get$iv);
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.loot.EquipmentComponent");
            }
            EquipmentComponent equipment = (EquipmentComponent)((Component)((EquipmentComponent)obj));
            PickableLootComponent pickableLoot = Mapper.INSTANCE.getPickableLoot().get(itemEntity);
            if (PickupLootSystemKt.access$getKeyMapper$p().getUsingController() && this.charOverItem(playerPos.getPos(), Vector2Kt.minus(position, Vector2Kt.times(gfx.getSize(), 0.5f)), Vector2Kt.times(gfx.getSize(), 1.4f))) {
                this.hoverOverItem(itemEntity, equipment.getItem());
            }
            boolean playerHover = PickupLootSystemKt.access$getKeyMapper$p().getUsingController() && this.charOverItem(playerPos.getPos(), Vector2Kt.minus(position, Vector2Kt.times(gfx.getSize(), 0.5f)), Vector2Kt.times(gfx.getSize(), 1.4f));
            boolean mousehover = Vector2Kt.pointerWithinSquare(Vector2Kt.minus(position, Vector2Kt.times(gfx.getSize(), 0.5f)), gfx.getSize());
            if (playerHover || mousehover) {
                this.hoverOverItem(itemEntity, equipment.getItem());
                if (TBEngineKt.getGlobals().getKeyMapper().equipItem()) {
                    pickableLoot.setClicked(true);
                    itemEntity.remove(LightStaticComponent.class);
                    itemEntity.add(new LinearMoveAIComponent(TargetType.OnScreen.INSTANCE, 0.1f, true));
                    itemEntity.add(new VelocityComponent(Vector2Kt.x(0.0f, 0.0f)));
                }
            }
            if (!pickableLoot.getClicked() || !(Mapper.INSTANCE.getPosition().get(player).getPos().dst(position) < 0.3f)) continue;
            this.getEngine().removeEntity(itemEntity);
            Equipment pickedUpItem = equipment.getItem();
            this.getEngine().addEntity(new ItemDropEntity(inventory.swap(pickedUpItem), position));
        }
    }

    public final boolean charOverItem(@NotNull Vector2 playerPos, @NotNull Vector2 box2, @NotNull Vector2 boxSize) {
        Intrinsics.checkNotNullParameter(playerPos, "playerPos");
        Intrinsics.checkNotNullParameter(box2, "box");
        Intrinsics.checkNotNullParameter(boxSize, "boxSize");
        float px = Vector2Kt.component1(playerPos);
        float py = Vector2Kt.component2(playerPos);
        float x = Vector2Kt.component1(box2);
        float y = Vector2Kt.component2(box2);
        float sx = Vector2Kt.component1(boxSize);
        float sy = Vector2Kt.component2(boxSize);
        return x <= px && x + sx >= px && y <= py && y + sy >= py;
    }

    /*
     * WARNING - void declaration
     */
    private final void hoverOverItem(Entity entity, Equipment equipped) {
        Entity $this$mapTo$iv$iv;
        Vector2 position = Mapper.INSTANCE.getPosition().get(entity).getPos();
        SpriteGfxComponent gfx = Mapper.INSTANCE.getSpriteGfx().get(entity);
        Object $this$getOrNull$iv = entity;
        boolean $i$f$getOrNull = false;
        boolean $i$f$addMapperIfNone = false;
        if (!EntityUtilsKt.getMappers().containsKey(EquipmentComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", EquipmentComponent.class), null, null, 0, hoverOverItem$$inlined$getOrNull$1.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(EquipmentComponent.class);
        EquipmentComponent equipmentComponent = (EquipmentComponent)((Component)(componentMapper == null ? null : componentMapper.get((Entity)$this$getOrNull$iv)));
        if (equipmentComponent == null) {
            return;
        }
        EquipmentComponent item = equipmentComponent;
        List<CompareResult> stats = ItemKt.compare(item.getItem(), equipped);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        PickupLootSystemKt.access$getShapeRenderer$p().begin(ShapeRenderer.ShapeType.Line);
        PickupLootSystemKt.access$getShapeRenderer$p().setColor(Color.BLACK);
        ShapeRenderer shapeRenderer = PickupLootSystemKt.access$getShapeRenderer$p();
        $this$getOrNull$iv = Vector2Kt.copy(gfx.getSize()).scl(0.5f);
        Intrinsics.checkNotNullExpressionValue($this$getOrNull$iv, "gfx.size.copy().scl(0.5f)");
        ShapeRendererKt.rect(shapeRenderer, Vector2Kt.dw(Vector2Kt.minus(position, (Vector2)$this$getOrNull$iv)), Vector2Kt.dw(gfx.getSize()));
        PickupLootSystemKt.access$getShapeRenderer$p().end();
        Gdx.gl.glDisable(3042);
        Iterable $this$map$iv = stats;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void stat;
            Object item$iv$iv = iterator2.next();
            CompareResult compareResult = (CompareResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Color color = stat.getDiff() == null || Intrinsics.areEqual(stat.getDiff(), 0.0f) ? Color.WHITE : (stat.getDiff().floatValue() > 0.0f ? Color.GREEN : Color.RED);
            String string2 = stat.text();
            Intrinsics.checkNotNullExpressionValue(color, "color");
            collection.add(new ColoredMods(string2, color, stat.getDiff()));
        }
        List coloredMods = (List)destination$iv$iv;
        Vector2 drawPos = Vector2Kt.plus(Vector2Kt.minus(position, Vector2Kt.times(gfx.getSize(), 0.5f)), new Vector2(0.0f, 0.5f));
        if (item.getItem() instanceof Weapon) {
            ImmutableArray<Entity> immutableArray = this.inventories;
            if (immutableArray == null) {
                Intrinsics.throwUninitializedPropertyAccessException("inventories");
                immutableArray = null;
            }
            $this$mapTo$iv$iv = immutableArray.first();
            Intrinsics.checkNotNullExpressionValue($this$mapTo$iv$iv, "inventories.first()");
            Entity $this$get$iv = $this$mapTo$iv$iv;
            boolean $i$f$get = false;
            boolean $i$f$addMapperIfNone2 = false;
            if (!EntityUtilsKt.getMappers().containsKey(InventoryComponent.class)) {
                LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", InventoryComponent.class), null, null, 0, hoverOverItem$$inlined$get$1.INSTANCE, 14, null);
            }
            ComponentMapper<?> componentMapper2 = EntityUtilsKt.getMappers().get(InventoryComponent.class);
            Intrinsics.checkNotNull(componentMapper2);
            Object obj = componentMapper2.get($this$get$iv);
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.player.InventoryComponent");
            }
            int dps = ((InventoryComponent)((Component)((InventoryComponent)obj))).getWeapon().getBaseAttack().getDps();
            InventorySystemKt.drawWeapon(drawPos, (Weapon)item.getItem(), TBEngineKt.getGlobals().getDrawGfx(), dps);
        } else {
            Iterable $this$sortedByDescending$iv = coloredMods;
            boolean $i$f$sortedByDescending = false;
            InventorySystemKt.drawEquipment(item.getItem(), CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                public final int compare(T a, T b) {
                    ColoredMods it = (ColoredMods)b;
                    boolean bl = false;
                    Comparable comparable = it.getDiff();
                    it = (ColoredMods)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)it.getDiff());
                }
            }), drawPos);
        }
    }
}

