/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.player;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.core.component.player.InventoryComponent;
import org.veiset.kgame.engine.ecs.core.system.Mapper;
import org.veiset.kgame.engine.ecs.core.system.player.InventorySystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/player/InventorySystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "inventories", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "kgame2"})
public final class InventorySystem
extends EntitySystem {
    @NotNull
    private final AssetManager am = TBEngineKt.getGlobals().getAssetManager();
    private ImmutableArray<Entity> inventories;

    @Override
    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Class[] classArray = new Class[]{InventoryComponent.class};
        ImmutableArray<Entity> immutableArray = engine.getEntitiesFor(Family.one(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.inventories = immutableArray;
    }

    @Override
    public void update(float deltaTime) {
        TextureRegion textureRegion;
        TextureRegion textureRegion2;
        TextureRegion textureRegion3;
        AssetRef assetRef$iv;
        AssetManager this_$iv;
        ImmutableArray<Entity> immutableArray = this.inventories;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException("inventories");
            immutableArray = null;
        }
        Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)immutableArray);
        if (entity == null) {
            return;
        }
        Entity inventoryEntity = entity;
        InventoryComponent inventoryComponent = Mapper.INSTANCE.getInventory().get(inventoryEntity);
        if (inventoryComponent == null) {
            return;
        }
        InventoryComponent inventory = inventoryComponent;
        float scale = 0.65f;
        float spacing2 = 0.05f;
        float gameWidth = 16.0f;
        Vector2 size = Vector2Kt.x(scale, scale);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        InventorySystemKt.access$getShapeRenderer$p().begin(ShapeRenderer.ShapeType.Filled);
        InventorySystemKt.access$getShapeRenderer$p().setColor(ColorKt.color(0.0f, 0.0f, 0.0f, 0.5f));
        ShapeRendererKt.rect(InventorySystemKt.access$getShapeRenderer$p(), Vector2Kt.dw(InventorySystem.update$pos(gameWidth, scale, spacing2, 1)), Vector2Kt.dw(size));
        ShapeRendererKt.rect(InventorySystemKt.access$getShapeRenderer$p(), Vector2Kt.dw(InventorySystem.update$pos(gameWidth, scale, spacing2, 2)), Vector2Kt.dw(size));
        ShapeRendererKt.rect(InventorySystemKt.access$getShapeRenderer$p(), Vector2Kt.dw(InventorySystem.update$pos(gameWidth, scale, spacing2, 3)), Vector2Kt.dw(size));
        InventorySystemKt.access$getShapeRenderer$p().end();
        Gdx.gl.glDisable(3042);
        InventorySystemKt.access$getShapeRenderer$p().begin(ShapeRenderer.ShapeType.Line);
        InventorySystemKt.access$getShapeRenderer$p().setColor(Color.BLACK);
        ShapeRendererKt.rect(InventorySystemKt.access$getShapeRenderer$p(), Vector2Kt.dw(InventorySystem.update$pos(gameWidth, scale, spacing2, 1)), Vector2Kt.dw(size));
        ShapeRendererKt.rect(InventorySystemKt.access$getShapeRenderer$p(), Vector2Kt.dw(InventorySystem.update$pos(gameWidth, scale, spacing2, 2)), Vector2Kt.dw(size));
        ShapeRendererKt.rect(InventorySystemKt.access$getShapeRenderer$p(), Vector2Kt.dw(InventorySystem.update$pos(gameWidth, scale, spacing2, 3)), Vector2Kt.dw(size));
        InventorySystemKt.access$getShapeRenderer$p().end();
        InventorySystemKt.access$getSpriteBatch$p().begin();
        Vector2 vector2 = InventorySystem.update$pos(gameWidth, scale, spacing2, 1);
        float x1 = Vector2Kt.component1(vector2);
        float y1 = Vector2Kt.component2(vector2);
        Vector2 vector22 = InventorySystem.update$pos(gameWidth, scale, spacing2, 2);
        float x2 = Vector2Kt.component1(vector22);
        float y2 = Vector2Kt.component2(vector22);
        Vector2 vector23 = InventorySystem.update$pos(gameWidth, scale, spacing2, 3);
        float x3 = Vector2Kt.component1(vector23);
        float y3 = Vector2Kt.component2(vector23);
        AssetManager assetManager = this.am;
        AssetRef assetRef = inventory.getBoots().getIcon();
        SpriteBatch spriteBatch = InventorySystemKt.access$getSpriteBatch$p();
        boolean $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion3 = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        spriteBatch.draw(textureRegion3, x1 * 120.0f, y1 * 120.0f, scale * 120.0f, scale * 120.0f);
        this_$iv = this.am;
        assetRef$iv = inventory.getRing().getIcon();
        spriteBatch = InventorySystemKt.access$getSpriteBatch$p();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion2 = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        spriteBatch.draw(textureRegion2, x2 * 120.0f, y2 * 120.0f, size.x * 120.0f, size.y * 120.0f);
        this_$iv = this.am;
        assetRef$iv = inventory.getWeapon().getIcon();
        spriteBatch = InventorySystemKt.access$getSpriteBatch$p();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        spriteBatch.draw(textureRegion, x3 * 120.0f, y3 * 120.0f, size.x * 120.0f, size.y * 120.0f);
        InventorySystemKt.access$getSpriteBatch$p().end();
        if (Vector2Kt.uiPointerWithinSquare(InventorySystem.update$pos(gameWidth, scale, spacing2, 1), size)) {
            InventorySystemKt.access$drawInventoryItem(inventory.getBoots());
            InventorySystemKt.drawTriangle(scale, spacing2, 0.15f, 1);
        }
        if (Vector2Kt.uiPointerWithinSquare(InventorySystem.update$pos(gameWidth, scale, spacing2, 2), size)) {
            InventorySystemKt.access$drawInventoryItem(inventory.getRing());
            InventorySystemKt.drawTriangle(scale, spacing2, 0.15f, 2);
        }
        if (Vector2Kt.uiPointerWithinSquare(InventorySystem.update$pos(gameWidth, scale, spacing2, 3), size)) {
            InventorySystemKt.drawWeapon$default(Vector2Kt.x(12.0f, 0.9f), inventory.getWeapon(), TBEngineKt.getGlobals().getDrawUi(), null, 8, null);
            InventorySystemKt.drawTriangle(scale, spacing2, 0.15f, 3);
        }
    }

    private static final Vector2 update$pos(float gameWidth, float scale, float spacing2, int index) {
        float x = gameWidth - scale * (float)index - spacing2 * (float)index;
        return new Vector2(x, spacing2);
    }
}

