/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.player;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentMapper;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.behaviour.AnimationSpeedModifier;
import org.veiset.kgame.engine.behaviour.DynamicAnimation;
import org.veiset.kgame.engine.ecs.core.component.draw.Direction;
import org.veiset.kgame.engine.ecs.core.component.draw.DynamicAnimationComponent;
import org.veiset.kgame.engine.ecs.core.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.core.component.player.InventoryComponent;
import org.veiset.kgame.engine.ecs.core.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.core.system.Mapper;
import org.veiset.kgame.engine.ecs.core.system.player.PlayerInputSystem$update$;
import org.veiset.kgame.engine.ecs.modifier.ModifiersComponent;
import org.veiset.kgame.engine.input.MouseKt;
import org.veiset.kgame.engine.modifier.ModifierEngine;
import org.veiset.kgame.engine.modifier.ModifierEngineKt;
import org.veiset.kgame.engine.ui.Buff;
import org.veiset.kgame.engine.util.EntityUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0006H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/player/PlayerInputSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "(Lcom/badlogic/gdx/physics/box2d/World;)V", "initDelay", "", "getInitDelay", "()F", "setInitDelay", "(F)V", "inventories", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "players", "target", "Lcom/badlogic/gdx/math/Vector2;", "getTarget", "()Lcom/badlogic/gdx/math/Vector2;", "setTarget", "(Lcom/badlogic/gdx/math/Vector2;)V", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "delta", "kgame2"})
public final class PlayerInputSystem
extends EntitySystem {
    @NotNull
    private final World world;
    @Nullable
    private Vector2 target;
    private float initDelay;
    private ImmutableArray<Entity> players;
    private ImmutableArray<Entity> inventories;

    public PlayerInputSystem(@NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        this.world = world;
        this.initDelay = 0.1f;
    }

    @Nullable
    public final Vector2 getTarget() {
        return this.target;
    }

    public final void setTarget(@Nullable Vector2 vector2) {
        this.target = vector2;
    }

    public final float getInitDelay() {
        return this.initDelay;
    }

    public final void setInitDelay(float f) {
        this.initDelay = f;
    }

    @Override
    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Class[] classArray = new Class[]{PlayerCharacterComponent.class};
        ImmutableArray<Entity> immutableArray = engine.getEntitiesFor(Family.one(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.players = immutableArray;
        classArray = new Class[]{InventoryComponent.class};
        immutableArray = engine.getEntitiesFor(Family.one(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.inventories = immutableArray;
    }

    @Override
    public void update(float delta) {
        Iterable list$iv$iv;
        Buff it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        if (this.initDelay >= 0.0f) {
            this.initDelay -= delta;
            return;
        }
        ImmutableArray<Entity> immutableArray = this.players;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException("players");
            immutableArray = null;
        }
        Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)immutableArray);
        if (entity == null) {
            return;
        }
        Entity player = entity;
        ImmutableArray<Entity> immutableArray2 = this.inventories;
        if (immutableArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("inventories");
            immutableArray2 = null;
        }
        Entity entity2 = (Entity)CollectionsKt.firstOrNull((Iterable)immutableArray2);
        if (entity2 == null) {
            return;
        }
        Entity inventoryEntity = entity2;
        InventoryComponent inventoryComponent = Mapper.INSTANCE.getInventory().get(inventoryEntity);
        if (inventoryComponent == null) {
            return;
        }
        InventoryComponent inventory = inventoryComponent;
        Entity $this$get$iv = player;
        boolean $i$f$get = false;
        boolean $i$f$addMapperIfNone = false;
        if (!EntityUtilsKt.getMappers().containsKey(ModifiersComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", ModifiersComponent.class), null, null, 0, update$$inlined$get$1.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(ModifiersComponent.class);
        Intrinsics.checkNotNull(componentMapper);
        Object obj = componentMapper.get($this$get$iv);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.modifier.ModifiersComponent");
        }
        ModifiersComponent powerups = (ModifiersComponent)((Component)((ModifiersComponent)obj));
        DynamicAnimationComponent animation = Mapper.INSTANCE.getDynamicAnimation().get(player);
        DynamicAnimation playerState = animation.getDynamicAnimation();
        Vector2 position = Mapper.INSTANCE.getPosition().get(player).getPos();
        VelocityComponent velocity = Mapper.INSTANCE.getVelocity().get(player);
        Iterable iterable = powerups.getBuffs();
        Object object = inventory.getWeapon().getBaseAttack().getModifiers();
        boolean $i$f$flatMap = false;
        void var13_15 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Buff)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getModifiers();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List modifiers = CollectionsKt.plus(object, (Iterable)((List)destination$iv$iv));
        $this$flatMap$iv = powerups.getBuffs();
        Collection collection = inventory.getBoots().getModifiers();
        ModifierEngine modifierEngine = ModifierEngine.INSTANCE;
        float f = inventory.getWeapon().getBaseAttack().getBaseAttackSpeed() * ModifierEngineKt.attackSpeedCoeff(modifiers);
        float f2 = 0.0f;
        float f3 = delta;
        object = playerState;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Buff)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getModifiers();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 57;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = modifierEngine.speed(CollectionsKt.plus(collection, (Iterable)list), 2.0f);
        float f8 = f;
        float f9 = f2;
        ((DynamicAnimation)object).update(f3, new AnimationSpeedModifier(f9, f8, f7, f6, f5, f4, n, defaultConstructorMarker));
        if (Gdx.input.isButtonPressed(1)) {
            Vector2 sp = MouseKt.scaledPointer();
            animation.setDirection(sp.x > position.x ? Direction.RIGHT : Direction.LEFT);
        }
        if (!(velocity.getSpeed().x == 0.0f)) {
            animation.setDirection(velocity.getSpeed().x > 0.0f ? Direction.RIGHT : Direction.LEFT);
        }
    }
}

