/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.modifier;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentMapper;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.core.component.PositionComponent;
import org.veiset.kgame.engine.ecs.core.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.core.component.ui.MoveGfxToTargetComponent;
import org.veiset.kgame.engine.ecs.core.component.ui.UiGfxComponent;
import org.veiset.kgame.engine.ecs.modifier.AddModifierSystem$update$;
import org.veiset.kgame.engine.ecs.modifier.DisplayPlayerModifiersSystemKt;
import org.veiset.kgame.engine.ecs.modifier.ModifiersComponent;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.modifier.Modifier;
import org.veiset.kgame.engine.ui.Buff;
import org.veiset.kgame.engine.ui.SelectPowerUpUI;
import org.veiset.kgame.engine.util.EntityUtilsKt;
import org.veiset.kgame.engine.util.GdxUtilsKt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lorg/veiset/kgame/engine/ecs/modifier/AddModifierSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "onSelect", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "getAm", "()Lorg/veiset/kgame/engine/asset/AssetManager;", "getOnSelect", "()Lkotlin/jvm/functions/Function0;", "playerEntities", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "sb", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "getSb", "()Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "ui", "Lorg/veiset/kgame/engine/ui/SelectPowerUpUI;", "getUi", "()Lorg/veiset/kgame/engine/ui/SelectPowerUpUI;", "addedToEngine", "engine", "Lcom/badlogic/ashley/core/Engine;", "removedFromEngine", "update", "delta", "", "kgame2"})
public final class AddModifierSystem
extends EntitySystem {
    @NotNull
    private final Function0<Unit> onSelect;
    @NotNull
    private final SpriteBatch sb;
    @NotNull
    private final AssetManager am;
    private ImmutableArray<Entity> playerEntities;
    @NotNull
    private final SelectPowerUpUI ui;

    public AddModifierSystem(@NotNull Function0<Unit> onSelect) {
        Intrinsics.checkNotNullParameter(onSelect, "onSelect");
        this.onSelect = onSelect;
        this.sb = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
        this.am = TBEngineKt.getGlobals().getAssetManager();
        Buff[] buffArray = new Buff[]{new Buff("The Beef of Beefs", "Increases your total health pool by [GOOD](+20%)", Asset.Icon.Modifier.INSTANCE.getBeef(), CollectionsKt.listOf(new Modifier.Health.Increase(0.2f)), false, 16, null), new Buff("Speedy Boi", "Increases your movement speed by [GOOD](+30%), but makes you take [BAD](+10%) more damage", Asset.Icon.Modifier.INSTANCE.getSpeedy(), CollectionsKt.listOf(new Modifier.Speed.Increase(0.3f)), false, 16, null), new Buff("Make It Rain", "[GOOD](+50%) damage", Asset.Icon.Modifier.INSTANCE.getMakeItRain(), CollectionsKt.listOf(new Modifier.Damage.Increase(0.5f)), false, 16, null)};
        this.ui = new SelectPowerUpUI(true, CollectionsKt.listOf(buffArray));
    }

    public /* synthetic */ AddModifierSystem(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        this(function0);
    }

    @NotNull
    public final Function0<Unit> getOnSelect() {
        return this.onSelect;
    }

    @NotNull
    public final SpriteBatch getSb() {
        return this.sb;
    }

    @NotNull
    public final AssetManager getAm() {
        return this.am;
    }

    @NotNull
    public final SelectPowerUpUI getUi() {
        return this.ui;
    }

    @Override
    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Class[] classArray = new Class[]{PositionComponent.class, PlayerCharacterComponent.class};
        ImmutableArray<Entity> immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.playerEntities = immutableArray;
        EngineConfig.Engine.INSTANCE.setSpeed(0.03f);
    }

    @Override
    public void removedFromEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        EngineConfig.Engine.INSTANCE.setSpeed(1.0f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(float delta) {
        TextureRegion textureRegion;
        Buff assetRef$iv;
        this.sb.begin();
        AssetManager assetManager = this.am;
        AssetRef assetRef = Asset.Icon.Weapon.INSTANCE.getWeapon01();
        Object object = this.sb;
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object2 = this_$iv.getAssets().get(assetRef$iv);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion = (TextureRegion)object2;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        GdxUtilsKt.draw((SpriteBatch)object, textureRegion, Vector2Kt.x(3.0f, 3.0f));
        this.sb.end();
        this.ui.draw(delta);
        if (this.ui.getSelected() != null && this.ui.getIconPosition() != null) {
            TextureRegion textureRegion2;
            void assetRef$iv2;
            Buff buff = this.ui.getSelected();
            Intrinsics.checkNotNull(buff);
            Buff it = assetRef$iv = buff;
            boolean $i$a$-also-AddModifierSystem$update$buff$22 = false;
            it.setDisplay(false);
            Buff buff2 = assetRef$iv;
            Vector2 vector2 = this.ui.getIconPosition();
            Intrinsics.checkNotNull(vector2);
            Vector2 iconPos = vector2;
            ImmutableArray<Entity> immutableArray = this.playerEntities;
            if (immutableArray == null) {
                Intrinsics.throwUninitializedPropertyAccessException("playerEntities");
                immutableArray = null;
            }
            Entity $i$a$-also-AddModifierSystem$update$buff$22 = immutableArray.first();
            Intrinsics.checkNotNullExpressionValue($i$a$-also-AddModifierSystem$update$buff$22, "playerEntities.first()");
            Object $this$get$iv = $i$a$-also-AddModifierSystem$update$buff$22;
            boolean $i$f$get22 = false;
            boolean $i$f$addMapperIfNone = false;
            if (!EntityUtilsKt.getMappers().containsKey(ModifiersComponent.class)) {
                LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", ModifiersComponent.class), null, null, 0, update$$inlined$get$1.INSTANCE, 14, null);
            }
            ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(ModifiersComponent.class);
            Intrinsics.checkNotNull(componentMapper);
            Object obj = componentMapper.get((Entity)$this$get$iv);
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.modifier.ModifiersComponent");
            }
            ModifiersComponent modifiers = (ModifiersComponent)((Component)((ModifiersComponent)obj));
            modifiers.setBuffs(CollectionsKt.plus((Collection)modifiers.getBuffs(), (Iterable)CollectionsKt.listOf(buff2)));
            System.out.println(this.ui.getSelected());
            $this$get$iv = this.am;
            AssetRef $i$f$get22 = buff2.getIcon();
            Entity entity = new Entity();
            object = this.getEngine();
            boolean $i$f$get3 = false;
            try {
                void this_$iv;
                Object object3 = this_$iv.getAssets().get(assetRef$iv2);
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
                }
                textureRegion2 = (TextureRegion)object3;
            }
            catch (Exception ex$iv) {
                Log.INSTANCE.critical("AssetRef " + assetRef$iv2 + " not loaded");
                throw ex$iv;
            }
            TextureRegion textureRegion3 = textureRegion2;
            Vector2 vector22 = this.ui.getIconSize();
            TextureRegion textureRegion4 = textureRegion3;
            Entity entity2 = entity.add(new UiGfxComponent(textureRegion4, vector22)).add(new PositionComponent(iconPos));
            Vector2 vector23 = Vector2Kt.minus(DisplayPlayerModifiersSystemKt.getDisplayIconPos(), Vector2Kt.x(0.0f, 0.4f * (float)(modifiers.getBuffs().size() - 1)));
            Vector2 vector24 = this.ui.getIconSize();
            Vector2 vector25 = Vector2Kt.x(0.4f, 0.4f);
            Interpolation interpolation = Interpolation.linear;
            Intrinsics.checkNotNullExpressionValue(interpolation, "linear");
            ((Engine)object).addEntity(entity2.add(new MoveGfxToTargetComponent(iconPos, vector23, vector24, vector25, 1.0f, interpolation, new Function0<Unit>(buff2, this){
                final /* synthetic */ Buff $buff;
                final /* synthetic */ AddModifierSystem this$0;
                {
                    this.$buff = $buff;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.$buff.setDisplay(true);
                    this.this$0.getOnSelect().invoke();
                }
            }, false, 0.0f, 384, null)));
            this.getEngine().removeSystem(this);
        }
    }

    public AddModifierSystem() {
        this(null, 1, null);
    }
}

