/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.modifier;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentMapper;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IteratingSystem;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.core.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.modifier.DisplayPlayerModifiersSystem$processEntity$;
import org.veiset.kgame.engine.ecs.modifier.DisplayPlayerModifiersSystemKt;
import org.veiset.kgame.engine.ecs.modifier.ModifiersComponent;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.ui.Buff;
import org.veiset.kgame.engine.ui.ModifierText;
import org.veiset.kgame.engine.util.EntityUtilsKt;
import org.veiset.kgame.engine.util.FontUtilsKt;
import org.veiset.kgame.engine.util.GdxUtilsKt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/veiset/kgame/engine/ecs/modifier/DisplayPlayerModifiersSystem;", "Lcom/badlogic/ashley/systems/IteratingSystem;", "()V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "descriptionFont", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "sb", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "sr", "Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "titleFont", "drawHoverInfo", "", "position", "Lcom/badlogic/gdx/math/Vector2;", "buff", "Lorg/veiset/kgame/engine/ui/Buff;", "processEntity", "entity", "Lcom/badlogic/ashley/core/Entity;", "deltaTime", "", "kgame2"})
public final class DisplayPlayerModifiersSystem
extends IteratingSystem {
    @NotNull
    private final AssetManager am;
    @NotNull
    private final SpriteBatch sb;
    @NotNull
    private final ShapeRenderer sr;
    @NotNull
    private final BitmapFont titleFont;
    @NotNull
    private final BitmapFont descriptionFont;

    public DisplayPlayerModifiersSystem() {
        BitmapFont bitmapFont;
        BitmapFont bitmapFont2;
        AssetRef assetRef$iv;
        AssetManager this_$iv;
        Object object = new Class[]{PlayerCharacterComponent.class, ModifiersComponent.class};
        super(Family.all(object).get());
        this.am = TBEngineKt.getGlobals().getAssetManager();
        this.sb = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
        this.sr = TBEngineKt.getGlobals().getDrawUi().getShapeRenderer();
        object = this.am;
        AssetRef assetRef = Asset.Font.INSTANCE.getJbb18();
        DisplayPlayerModifiersSystem displayPlayerModifiersSystem = this;
        boolean $i$f$get = false;
        try {
            Object object2 = this_$iv.getAssets().get(assetRef$iv);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont2 = (BitmapFont)object2;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        displayPlayerModifiersSystem.titleFont = bitmapFont2;
        this_$iv = this.am;
        assetRef$iv = Asset.Font.INSTANCE.getJbt12();
        displayPlayerModifiersSystem = this;
        $i$f$get = false;
        try {
            Object object3 = this_$iv.getAssets().get(assetRef$iv);
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object3;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        displayPlayerModifiersSystem.descriptionFont = bitmapFont;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processEntity(@NotNull Entity entity, float deltaTime) {
        Buff buff;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(entity, "entity");
        Entity $this$get$iv = entity;
        boolean $i$f$get = false;
        boolean $i$f$addMapperIfNone = false;
        if (!EntityUtilsKt.getMappers().containsKey(ModifiersComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", ModifiersComponent.class), null, null, 0, processEntity$$inlined$get$1.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(ModifiersComponent.class);
        Intrinsics.checkNotNull(componentMapper);
        Object obj = componentMapper.get($this$get$iv);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.modifier.ModifiersComponent");
        }
        ModifiersComponent modifiers = (ModifiersComponent)((Component)((ModifiersComponent)obj));
        Iterable $this$filter$iv = modifiers.getBuffs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Buff it = (Buff)element$iv$iv;
            boolean bl = false;
            if (!it.getDisplay()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List buffs = (List)destination$iv$iv;
        GdxUtilsKt.opacity(this.sr, ShapeRenderer.ShapeType.Filled, (Function1<? super ShapeRenderer, Unit>)new Function1<ShapeRenderer, Unit>((List<Buff>)buffs){
            final /* synthetic */ List<Buff> $buffs;
            {
                this.$buffs = $buffs;
                super(1);
            }

            public final void invoke(@NotNull ShapeRenderer $this$opacity) {
                Intrinsics.checkNotNullParameter($this$opacity, "$this$opacity");
                $this$opacity.setColor(ColorKt.color(0.0f, 0.0f, 0.0f, 0.5f));
                ShapeRendererKt.rect($this$opacity, Vector2Kt.dw(Vector2Kt.minus(DisplayPlayerModifiersSystemKt.getDisplayIconPos(), Vector2Kt.x(0.0f, 0.4f * (float)this.$buffs.size() - 0.4f))), Vector2Kt.dw(Vector2Kt.x(0.4f, 0.4f * (float)this.$buffs.size())));
            }
        });
        this.sb.begin();
        Iterable $this$forEachIndexed$iv = buffs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            TextureRegion textureRegion;
            void assetRef$iv;
            Object element$iv$iv;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (Buff)item$iv;
            int index = n;
            boolean bl = false;
            AssetManager assetManager = this.am;
            AssetRef assetRef = buff.getIcon();
            SpriteBatch spriteBatch = this.sb;
            boolean $i$f$get2 = false;
            try {
                void this_$iv;
                Object object = this_$iv.getAssets().get(assetRef$iv);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
                }
                textureRegion = (TextureRegion)object;
            }
            catch (Exception ex$iv) {
                Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                throw ex$iv;
            }
            GdxUtilsKt.draw(spriteBatch, textureRegion, Vector2Kt.dw(Vector2Kt.minus(DisplayPlayerModifiersSystemKt.getDisplayIconPos(), Vector2Kt.x(0.0f, 0.4f * (float)index))), Vector2Kt.dw(Vector2Kt.x(0.4f, 0.4f)));
        }
        this.sb.end();
        $this$forEachIndexed$iv = buffs;
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            buff = (Buff)item$iv;
            int index = n;
            boolean bl = false;
            Vector2 pos = Vector2Kt.minus(DisplayPlayerModifiersSystemKt.getDisplayIconPos(), Vector2Kt.x(0.0f, (float)index * 0.4f));
            if (!Vector2Kt.uiPointerWithinSquare(pos, Vector2Kt.x(0.4f, 0.4f))) continue;
            this.drawHoverInfo(Vector2Kt.x(13.18f, 8.8f), buff);
        }
    }

    public final void drawHoverInfo(@NotNull Vector2 position, @NotNull Buff buff) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(buff, "buff");
        float width = 2.2f;
        ModifierText modifier = new ModifierText(this.descriptionFont, buff.getDescription(), 28, 0.13f);
        float titleX = FontUtilsKt.middleX(this.titleFont, buff.getTitle(), position.x, position.x + width);
        float descriptionHeight = 0.14f;
        GdxUtilsKt.opacity(this.sr, ShapeRenderer.ShapeType.Filled, (Function1<? super ShapeRenderer, Unit>)new Function1<ShapeRenderer, Unit>(position, width, modifier, descriptionHeight){
            final /* synthetic */ Vector2 $position;
            final /* synthetic */ float $width;
            final /* synthetic */ ModifierText $modifier;
            final /* synthetic */ float $descriptionHeight;
            {
                this.$position = $position;
                this.$width = $width;
                this.$modifier = $modifier;
                this.$descriptionHeight = $descriptionHeight;
                super(1);
            }

            public final void invoke(@NotNull ShapeRenderer $this$opacity) {
                Intrinsics.checkNotNullParameter($this$opacity, "$this$opacity");
                ShapeRendererKt.rect($this$opacity, Vector2Kt.dw(this.$position), Vector2Kt.dw(Vector2Kt.x(this.$width, -0.35f - (float)this.$modifier.getLines() * this.$descriptionHeight)));
            }
        });
        this.sb.begin();
        GdxUtilsKt.draw(this.titleFont, this.sb, buff.getTitle(), Vector2Kt.dw(Vector2Kt.x(position.x + titleX, position.y - 0.1f)));
        this.sb.end();
        modifier.draw(this.sb, Vector2Kt.plus(position, Vector2Kt.x(0.0f, -0.3f)), width);
    }
}

