/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.modifier;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentMapper;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntityListener;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.core.component.draw.MonsterStatsLabelComponent;
import org.veiset.kgame.engine.ecs.core.component.enemy.MonsterComponent;
import org.veiset.kgame.engine.ecs.core.component.physics.DynamicBodyComponent;
import org.veiset.kgame.engine.ecs.core.component.stats.HealthComponent;
import org.veiset.kgame.engine.ecs.modifier.ModifiersComponent;
import org.veiset.kgame.engine.ecs.modifier.ModifiersComponentMonsterEvent;
import org.veiset.kgame.engine.ecs.modifier.ModifiersComponentMonsterEvent$entityAdded$;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.modifier.Modifier;
import org.veiset.kgame.engine.modifier.ModifierEngineKt;
import org.veiset.kgame.engine.util.EntityUtilsKt;
import org.veiset.kgame.engine.util.FontUtilsKt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/veiset/kgame/engine/ecs/modifier/ModifiersComponentMonsterEvent;", "Lcom/badlogic/ashley/core/EntityListener;", "()V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "entityAdded", "", "entity", "Lcom/badlogic/ashley/core/Entity;", "entityRemoved", "kgame2"})
public final class ModifiersComponentMonsterEvent
implements EntityListener {
    @NotNull
    private final AssetManager am;
    @NotNull
    private final BitmapFont font;

    /*
     * WARNING - void declaration
     */
    public ModifiersComponentMonsterEvent() {
        BitmapFont bitmapFont;
        void assetRef$iv;
        AssetManager assetManager = this.am = TBEngineKt.getGlobals().getAssetManager();
        AssetRef assetRef = Asset.Font.INSTANCE.getRetron14();
        ModifiersComponentMonsterEvent modifiersComponentMonsterEvent = this;
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        modifiersComponentMonsterEvent.font = bitmapFont;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void entityAdded(@NotNull Entity entity) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(entity, "entity");
        Entity $this$getOrNull$iv = entity;
        boolean $i$f$getOrNull = false;
        boolean $i$f$addMapperIfNone = false;
        if (!EntityUtilsKt.getMappers().containsKey(ModifiersComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", ModifiersComponent.class), null, null, 0, entityAdded$$inlined$getOrNull$1.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(ModifiersComponent.class);
        ModifiersComponent modifiersComponent = (ModifiersComponent)((Component)(componentMapper == null ? null : componentMapper.get($this$getOrNull$iv)));
        if (modifiersComponent == null) {
            return;
        }
        ModifiersComponent modifiers = modifiersComponent;
        Entity $this$getOrNull$iv2 = entity;
        boolean $i$f$getOrNull2 = false;
        boolean $i$f$addMapperIfNone2 = false;
        if (!EntityUtilsKt.getMappers().containsKey(MonsterComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", MonsterComponent.class), null, null, 0, entityAdded$$inlined$getOrNull$2.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper2 = EntityUtilsKt.getMappers().get(MonsterComponent.class);
        MonsterComponent monsterComponent = (MonsterComponent)((Component)(componentMapper2 == null ? null : componentMapper2.get($this$getOrNull$iv2)));
        if (monsterComponent == null) {
            return;
        }
        MonsterComponent monster = monsterComponent;
        Entity $this$getOrNull$iv3 = entity;
        boolean $i$f$getOrNull3 = false;
        boolean $i$f$addMapperIfNone3 = false;
        if (!EntityUtilsKt.getMappers().containsKey(DynamicBodyComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", DynamicBodyComponent.class), null, null, 0, entityAdded$$inlined$getOrNull$3.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper3 = EntityUtilsKt.getMappers().get(DynamicBodyComponent.class);
        DynamicBodyComponent dynamicBodyComponent = (DynamicBodyComponent)((Component)(componentMapper3 == null ? null : componentMapper3.get($this$getOrNull$iv3)));
        if (dynamicBodyComponent == null) {
            return;
        }
        DynamicBodyComponent monsterSize = dynamicBodyComponent;
        $this$getOrNull$iv3 = entity;
        $i$f$getOrNull3 = false;
        $i$f$addMapperIfNone3 = false;
        if (!EntityUtilsKt.getMappers().containsKey(HealthComponent.class)) {
            LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", HealthComponent.class), null, null, 0, entityAdded$$inlined$getOrNull$4.INSTANCE, 14, null);
        }
        ComponentMapper<?> componentMapper4 = EntityUtilsKt.getMappers().get(HealthComponent.class);
        HealthComponent hp = (HealthComponent)((Component)(componentMapper4 == null ? null : componentMapper4.get($this$getOrNull$iv3)));
        if (modifiers.getModifiers().isEmpty()) {
            return;
        }
        if (hp != null) {
            hp.setMaxHealth(ModifierEngineKt.hp(modifiers.all(), hp.getMaxHealth()));
            hp.setCurrentHealth(hp.getMaxHealth());
        }
        Vector2 monsterOffset = Vector2Kt.copy(monsterSize.getSize()).scl(0.5f);
        Iterable $this$map$iv = modifiers.getModifiers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Modifier modifier = (Modifier)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getShortName());
        }
        String modifierNames2 = CollectionsKt.joinToString$default(CollectionsKt.toSet((List)destination$iv$iv), null, null, null, 0, null, entityAdded.modifierNames.2.INSTANCE, 31, null);
        float x = FontUtilsKt.sizeX(this.font, modifierNames2) / 2.0f;
        Vector2 vector2 = Vector2Kt.minus(Vector2Kt.x(monsterOffset.x, 0.0f), Vector2Kt.x(x + 0.05f, -0.32f));
        Color color = Color.ORANGE;
        Intrinsics.checkNotNullExpressionValue(color, "ORANGE");
        entity.add(new MonsterStatsLabelComponent(modifierNames2, vector2, color, null, 0, 24, null));
    }

    @Override
    public void entityRemoved(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
    }
}

