/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.sound.system;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentMapper;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.sound.component.SoundEffectComponent;
import org.veiset.kgame.engine.ecs.sound.system.SoundSystem$update$lambda-0$;
import org.veiset.kgame.engine.util.EntityUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/veiset/kgame/engine/ecs/sound/system/SoundSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "effects", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "soundCooldown", "", "timing", "", "", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "kgame2"})
public final class SoundSystem
extends EntitySystem {
    private ImmutableArray<Entity> effects;
    private final float soundCooldown;
    @NotNull
    private final Map<Integer, Float> timing = new LinkedHashMap();

    public SoundSystem() {
        this.soundCooldown = 0.05f;
    }

    @Override
    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Class[] classArray = new Class[]{SoundEffectComponent.class};
        ImmutableArray<Entity> immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.effects = immutableArray;
    }

    @Override
    public void update(float deltaTime) {
        ImmutableArray<Entity> immutableArray = this.effects;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException("effects");
            immutableArray = null;
        }
        Iterable $this$forEach$iv = immutableArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity effect = (Entity)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(effect, "effect");
            Entity $this$get$iv = effect;
            boolean $i$f$get = false;
            boolean $i$f$addMapperIfNone = false;
            if (!EntityUtilsKt.getMappers().containsKey(SoundEffectComponent.class)) {
                LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", SoundEffectComponent.class), null, null, 0, update$lambda-0$$inlined$get$1.INSTANCE, 14, null);
            }
            ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(SoundEffectComponent.class);
            Intrinsics.checkNotNull(componentMapper);
            Object obj = componentMapper.get($this$get$iv);
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.sound.component.SoundEffectComponent");
            }
            SoundEffectComponent soundEffect = (SoundEffectComponent)((Component)((SoundEffectComponent)obj));
            int soundHash = soundEffect.getSound().hashCode();
            if (!this.timing.containsKey(soundHash)) {
                TBEngineKt.getGlobals().getSoundPlayer().playEffect(soundEffect.getSound(), soundEffect.getVolume(), soundEffect.getPitch(), soundEffect.getPan());
                Map<Integer, Float> map2 = this.timing;
                Integer n = soundHash;
                Float f = Float.valueOf(this.soundCooldown);
                map2.put(n, f);
            }
            this.getEngine().removeEntity(effect);
        }
        $this$forEach$iv = this.timing.keySet();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            Float f = this.timing.get(it);
            Intrinsics.checkNotNull(f);
            float cd = ((Number)f).floatValue();
            Map<Integer, Float> map3 = this.timing;
            Integer n = it;
            Float f2 = Float.valueOf(cd - deltaTime);
            map3.put(n, f2);
            if (!(cd <= 0.0f)) continue;
            this.timing.remove(it);
        }
    }
}

