/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.math;

import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/veiset/kgame/engine/math/Bezier;", "", "p0", "Lcom/badlogic/gdx/math/Vector2;", "p1", "p2", "p3", "(Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;)V", "getP0", "()Lcom/badlogic/gdx/math/Vector2;", "getP1", "getP2", "getP3", "debugPoints", "", "debugline", "sampleSize", "", "getPt", "", "t", "point", "p", "kgame2"})
public final class Bezier {
    @NotNull
    private final Vector2 p0;
    @NotNull
    private final Vector2 p1;
    @NotNull
    private final Vector2 p2;
    @NotNull
    private final Vector2 p3;

    public Bezier(@NotNull Vector2 p0, @NotNull Vector2 p1, @NotNull Vector2 p2, @NotNull Vector2 p3) {
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        Intrinsics.checkNotNullParameter(p2, "p2");
        Intrinsics.checkNotNullParameter(p3, "p3");
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
    }

    @NotNull
    public final Vector2 getP0() {
        return this.p0;
    }

    @NotNull
    public final Vector2 getP1() {
        return this.p1;
    }

    @NotNull
    public final Vector2 getP2() {
        return this.p2;
    }

    @NotNull
    public final Vector2 getP3() {
        return this.p3;
    }

    private final float getPt(float p1, float p2, float t) {
        float diff = p2 - p1;
        return p1 + diff * t;
    }

    @NotNull
    public final Vector2 point(float p) {
        float f = 1.0f;
        float f2 = 0.0f;
        f2 = Math.max(p, f2);
        float t = Math.min(f, f2);
        Vector2 vector2 = this.p0;
        float x1 = Vector2Kt.component1(vector2);
        float y1 = Vector2Kt.component2(vector2);
        Vector2 vector22 = this.p1;
        float x2 = Vector2Kt.component1(vector22);
        float y2 = Vector2Kt.component2(vector22);
        Vector2 vector23 = this.p2;
        float x3 = Vector2Kt.component1(vector23);
        float y3 = Vector2Kt.component2(vector23);
        Vector2 vector24 = this.p3;
        float x4 = Vector2Kt.component1(vector24);
        float y4 = Vector2Kt.component2(vector24);
        float xa = this.getPt(x1, x2, t);
        float ya = this.getPt(y1, y2, t);
        float xb = this.getPt(x2, x3, t);
        float yb = this.getPt(y2, y3, t);
        float xc = this.getPt(x3, x4, t);
        float yc = this.getPt(y3, y4, t);
        float xm = this.getPt(xa, xb, t);
        float ym = this.getPt(ya, yb, t);
        float xn = this.getPt(xb, xc, t);
        float yn = this.getPt(yb, yc, t);
        float x = this.getPt(xm, xn, t);
        float y = this.getPt(ym, yn, t);
        return new Vector2(x, y);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector2> debugline(int sampleSize) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = new IntRange(0, sampleSize);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.point((float)it * (1.0f / (float)sampleSize)));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List debugline$default(Bezier bezier, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 50;
        }
        return bezier.debugline(n);
    }

    @NotNull
    public final List<Vector2> debugPoints() {
        Vector2[] vector2Array = new Vector2[]{this.p0, this.p1, this.p2, this.p3};
        return CollectionsKt.listOf(vector2Array);
    }
}

