/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.math;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J(\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u001e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007J\u001e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/veiset/kgame/engine/math/Perlin;", "", "()V", "p", "", "permutation", "fade", "", "t", "grad", "hash", "", "x", "y", "z", "lerp", "a", "b", "noise", "noiseScaled", "kgame2"})
public final class Perlin {
    @NotNull
    public static final Perlin INSTANCE = new Perlin();
    @NotNull
    private static final int[] permutation;
    @NotNull
    private static final int[] p;

    private Perlin() {
    }

    public final double noise(double x, double y, double z) {
        int xi = (int)Math.floor(x) & 0xFF;
        int yi = (int)Math.floor(y) & 0xFF;
        int zi = (int)Math.floor(z) & 0xFF;
        double xx = x - Math.floor(x);
        double yy = y - Math.floor(y);
        double zz = z - Math.floor(z);
        double u = this.fade(xx);
        double v = this.fade(yy);
        double w = this.fade(zz);
        int a = p[xi] + yi;
        int aa = p[a] + zi;
        int ab = p[a + 1] + zi;
        int b = p[xi + 1] + yi;
        int ba = p[b] + zi;
        int bb = p[b + 1] + zi;
        return this.lerp(w, this.lerp(v, this.lerp(u, this.grad(p[aa], xx, yy, zz), this.grad(p[ba], xx - 1.0, yy, zz)), this.lerp(u, this.grad(p[ab], xx, yy - 1.0, zz), this.grad(p[bb], xx - 1.0, yy - 1.0, zz))), this.lerp(v, this.lerp(u, this.grad(p[aa + 1], xx, yy, zz - 1.0), this.grad(p[ba + 1], xx - 1.0, yy, zz - 1.0)), this.lerp(u, this.grad(p[ab + 1], xx, yy - 1.0, zz - 1.0), this.grad(p[bb + 1], xx - 1.0, yy - 1.0, zz - 1.0))));
    }

    public final double noiseScaled(double x, double y, double z) {
        double d = Math.sqrt(0.75);
        return (this.noise(x, y, z) + d) / (d * (double)2);
    }

    private final double fade(double t) {
        return t * t * t * (t * (t * (double)6 - (double)15) + (double)10);
    }

    private final double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    private final double grad(int hash, double x, double y, double z) {
        double u;
        int h = hash & 0xF;
        double d = u = h < 8 ? x : y;
        double v = h < 4 ? y : (h == 12 || h == 14 ? x : z);
        return ((h & 1) == 0 ? u : -u) + ((h & 2) == 0 ? v : -v);
    }

    static {
        int[] nArray = new int[]{151, 160, 137, 91, 90, 15, 131, 13, 201, 95, 96, 53, 194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99, 37, 240, 21, 10, 23, 190, 6, 148, 247, 120, 234, 75, 0, 26, 197, 62, 94, 252, 219, 203, 117, 35, 11, 32, 57, 177, 33, 88, 237, 149, 56, 87, 174, 20, 125, 136, 171, 168, 68, 175, 74, 165, 71, 134, 139, 48, 27, 166, 77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133, 230, 220, 105, 92, 41, 55, 46, 245, 40, 244, 102, 143, 54, 65, 25, 63, 161, 1, 216, 80, 73, 209, 76, 132, 187, 208, 89, 18, 169, 200, 196, 135, 130, 116, 188, 159, 86, 164, 100, 109, 198, 173, 186, 3, 64, 52, 217, 226, 250, 124, 123, 5, 202, 38, 147, 118, 126, 255, 82, 85, 212, 207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42, 223, 183, 170, 213, 119, 248, 152, 2, 44, 154, 163, 70, 221, 153, 101, 155, 167, 43, 172, 9, 129, 22, 39, 253, 19, 98, 108, 110, 79, 113, 224, 232, 178, 185, 112, 104, 218, 246, 97, 228, 251, 34, 242, 193, 238, 210, 144, 12, 191, 179, 162, 241, 81, 51, 145, 235, 249, 14, 239, 107, 49, 192, 214, 31, 181, 199, 106, 157, 184, 84, 204, 176, 115, 121, 50, 45, 127, 4, 150, 254, 138, 236, 205, 93, 222, 114, 67, 29, 24, 72, 243, 141, 128, 195, 78, 66, 215, 61, 156, 180};
        permutation = nArray;
        int[] nArray2 = new int[512];
        for (int i = 0; i < 512; ++i) {
            int n = i;
            nArray2[n] = n < 256 ? permutation[n] : permutation[n - 256];
        }
        p = nArray2;
    }
}

