/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.modifier;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.ecs.attack.component.AttackType;
import org.veiset.kgame.engine.modifier.Modifier;
import org.veiset.kgame.engine.modifier.ModifierEngine;
import org.veiset.kgame.engine.modifier.ModifierEngineKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0005H\u00c6\u0003J\t\u0010.\u001a\u00020\u0005H\u00c6\u0003J\t\u0010/\u001a\u00020\u0005H\u00c6\u0003J\t\u00100\u001a\u00020\u0005H\u00c6\u0003J\u000f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003JK\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0001J\u0013\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00106\u001a\u00020\u001fH\u00d6\u0001J\t\u00107\u001a\u000208H\u00d6\u0001R\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR\u0011\u0010\u0019\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000fR\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000fR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000fR\u0011\u0010$\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000fR\u0011\u0010&\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u000fR\u0011\u0010(\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u000fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u00069"}, d2={"Lorg/veiset/kgame/engine/modifier/BaseAttack;", "", "attackType", "Lorg/veiset/kgame/engine/ecs/attack/component/AttackType;", "baseDamage", "", "baseCritical", "baseAttackSpeed", "damageVariance", "modifiers", "", "Lorg/veiset/kgame/engine/modifier/Modifier;", "(Lorg/veiset/kgame/engine/ecs/attack/component/AttackType;FFFFLjava/util/List;)V", "attackSpeed", "getAttackSpeed", "()F", "getAttackType", "()Lorg/veiset/kgame/engine/ecs/attack/component/AttackType;", "avgMaxDamage", "getAvgMaxDamage", "avgMinDamage", "getAvgMinDamage", "getBaseAttackSpeed", "getBaseCritical", "getBaseDamage", "criticalChance", "getCriticalChance", "criticalCoeff", "damage", "getDamageVariance", "dps", "", "getDps", "()I", "maxCriticalDamage", "getMaxCriticalDamage", "maxDamage", "getMaxDamage", "minCriticalDamage", "getMinCriticalDamage", "minDamage", "getMinDamage", "getModifiers", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "kgame2"})
public final class BaseAttack {
    @NotNull
    private final AttackType attackType;
    private final float baseDamage;
    private final float baseCritical;
    private final float baseAttackSpeed;
    private final float damageVariance;
    @NotNull
    private final List<Modifier> modifiers;
    private final float damage;
    private final float criticalCoeff;
    private final float minDamage;
    private final float maxDamage;
    private final float minCriticalDamage;
    private final float maxCriticalDamage;
    private final float criticalChance;
    private final float attackSpeed;
    private final float avgMinDamage;
    private final float avgMaxDamage;
    private final int dps;

    public BaseAttack(@NotNull AttackType attackType, float baseDamage, float baseCritical, float baseAttackSpeed, float damageVariance, @NotNull List<? extends Modifier> modifiers) {
        Intrinsics.checkNotNullParameter(attackType, "attackType");
        Intrinsics.checkNotNullParameter(modifiers, "modifiers");
        this.attackType = attackType;
        this.baseDamage = baseDamage;
        this.baseCritical = baseCritical;
        this.baseAttackSpeed = baseAttackSpeed;
        this.damageVariance = damageVariance;
        this.modifiers = modifiers;
        this.damage = ModifierEngine.INSTANCE.damage(this.modifiers, this.baseDamage);
        this.criticalCoeff = ModifierEngineKt.criticalDamage(this.modifiers);
        this.minDamage = this.damage * (1.0f - this.damageVariance);
        this.maxDamage = this.damage * (1.0f + this.damageVariance);
        this.minCriticalDamage = this.minDamage * this.criticalCoeff;
        this.maxCriticalDamage = this.maxDamage * this.criticalCoeff;
        this.criticalChance = this.baseCritical + ModifierEngineKt.criticalChance(this.modifiers);
        this.attackSpeed = this.baseAttackSpeed * ModifierEngineKt.attackSpeedCoeff(this.modifiers);
        this.avgMinDamage = this.minDamage * (1.0f - this.criticalChance) + this.minCriticalDamage * this.criticalChance;
        this.avgMaxDamage = this.maxDamage * (1.0f - this.criticalChance) + this.maxCriticalDamage * this.criticalChance;
        this.dps = (int)((this.avgMinDamage + this.avgMaxDamage) / 2.0f * this.attackSpeed);
    }

    public /* synthetic */ BaseAttack(AttackType attackType, float f, float f2, float f3, float f4, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            f4 = 0.05f;
        }
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(attackType, f, f2, f3, f4, list);
    }

    @NotNull
    public final AttackType getAttackType() {
        return this.attackType;
    }

    public final float getBaseDamage() {
        return this.baseDamage;
    }

    public final float getBaseCritical() {
        return this.baseCritical;
    }

    public final float getBaseAttackSpeed() {
        return this.baseAttackSpeed;
    }

    public final float getDamageVariance() {
        return this.damageVariance;
    }

    @NotNull
    public final List<Modifier> getModifiers() {
        return this.modifiers;
    }

    public final float getMinDamage() {
        return this.minDamage;
    }

    public final float getMaxDamage() {
        return this.maxDamage;
    }

    public final float getMinCriticalDamage() {
        return this.minCriticalDamage;
    }

    public final float getMaxCriticalDamage() {
        return this.maxCriticalDamage;
    }

    public final float getCriticalChance() {
        return this.criticalChance;
    }

    public final float getAttackSpeed() {
        return this.attackSpeed;
    }

    public final float getAvgMinDamage() {
        return this.avgMinDamage;
    }

    public final float getAvgMaxDamage() {
        return this.avgMaxDamage;
    }

    public final int getDps() {
        return this.dps;
    }

    @NotNull
    public final AttackType component1() {
        return this.attackType;
    }

    public final float component2() {
        return this.baseDamage;
    }

    public final float component3() {
        return this.baseCritical;
    }

    public final float component4() {
        return this.baseAttackSpeed;
    }

    public final float component5() {
        return this.damageVariance;
    }

    @NotNull
    public final List<Modifier> component6() {
        return this.modifiers;
    }

    @NotNull
    public final BaseAttack copy(@NotNull AttackType attackType, float baseDamage, float baseCritical, float baseAttackSpeed, float damageVariance, @NotNull List<? extends Modifier> modifiers) {
        Intrinsics.checkNotNullParameter(attackType, "attackType");
        Intrinsics.checkNotNullParameter(modifiers, "modifiers");
        return new BaseAttack(attackType, baseDamage, baseCritical, baseAttackSpeed, damageVariance, modifiers);
    }

    public static /* synthetic */ BaseAttack copy$default(BaseAttack baseAttack, AttackType attackType, float f, float f2, float f3, float f4, List list, int n, Object object) {
        if ((n & 1) != 0) {
            attackType = baseAttack.attackType;
        }
        if ((n & 2) != 0) {
            f = baseAttack.baseDamage;
        }
        if ((n & 4) != 0) {
            f2 = baseAttack.baseCritical;
        }
        if ((n & 8) != 0) {
            f3 = baseAttack.baseAttackSpeed;
        }
        if ((n & 0x10) != 0) {
            f4 = baseAttack.damageVariance;
        }
        if ((n & 0x20) != 0) {
            list = baseAttack.modifiers;
        }
        return baseAttack.copy(attackType, f, f2, f3, f4, list);
    }

    @NotNull
    public String toString() {
        return "BaseAttack(attackType=" + this.attackType + ", baseDamage=" + this.baseDamage + ", baseCritical=" + this.baseCritical + ", baseAttackSpeed=" + this.baseAttackSpeed + ", damageVariance=" + this.damageVariance + ", modifiers=" + this.modifiers + ')';
    }

    public int hashCode() {
        int result2 = this.attackType.hashCode();
        result2 = result2 * 31 + Float.hashCode(this.baseDamage);
        result2 = result2 * 31 + Float.hashCode(this.baseCritical);
        result2 = result2 * 31 + Float.hashCode(this.baseAttackSpeed);
        result2 = result2 * 31 + Float.hashCode(this.damageVariance);
        result2 = result2 * 31 + ((Object)this.modifiers).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BaseAttack)) {
            return false;
        }
        BaseAttack baseAttack = (BaseAttack)other;
        if (!Intrinsics.areEqual(this.attackType, baseAttack.attackType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.baseDamage), (Object)Float.valueOf(baseAttack.baseDamage))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.baseCritical), (Object)Float.valueOf(baseAttack.baseCritical))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.baseAttackSpeed), (Object)Float.valueOf(baseAttack.baseAttackSpeed))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.damageVariance), (Object)Float.valueOf(baseAttack.damageVariance))) {
            return false;
        }
        return Intrinsics.areEqual(this.modifiers, baseAttack.modifiers);
    }
}

