/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.storage.TextureMetaStore;
import org.veiset.kgame.engine.values.Asset;
import org.veiset.kgame.engine.values.Tag;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\b\u0010\u0014\u001a\u00020\u000fH\u0002\u001a\b\u0010\u0015\u001a\u00020\u000fH\u0002\u001a\u0006\u0010\u0016\u001a\u00020\u000f\u001a\b\u0010\u0017\u001a\u00020\u0018H\u0000\u001a$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a*\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001b0\u001c2\u0006\u0010\u001d\u001a\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"cols", "", "gameHeight", "gameWidth", "resolution", "rows", "shapeRenderer", "Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "spriteBatch", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "unitSize", "viewBoxPos", "Lcom/badlogic/gdx/math/Vector2;", "viewBoxSize", "drawBackgroundTiles", "", "type", "", "texturesStore", "Lorg/veiset/kgame/engine/storage/TextureMetaStore;", "drawGrid", "drawUiAreas", "drawViewBox", "isInsideScene", "", "query", "", "Lorg/veiset/kgame/engine/storage/TextureMetaStore$TextureMeta;", "", "searchString", "kgame2"})
public final class AreaEditorKt {
    private static final float resolution = 0.25f;
    @NotNull
    private static final ShapeRenderer shapeRenderer = TBEngineKt.getGlobals().getDrawUi().getShapeRenderer();
    @NotNull
    private static final SpriteBatch spriteBatch = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
    private static final float gameHeight = 9.0f;
    private static final float gameWidth = 16.0f;
    private static final float cols = 64.0f;
    private static final float rows = 36.0f;
    private static final float unitSize = 0.25f;
    @NotNull
    private static final Vector2 viewBoxPos = Vector2Kt.x(3.0f, 0.005f);
    @NotNull
    private static final Vector2 viewBoxSize = Vector2Kt.x(10.0f, 8.5f);

    public static final boolean isInsideScene() {
        return Vector2Kt.uiPointerWithinSquare(viewBoxPos, viewBoxSize);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TextureMetaStore.TextureMeta> query(@NotNull Map<String, TextureMetaStore.TextureMeta> $this$query, @NotNull String searchString) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$query, "<this>");
        Intrinsics.checkNotNullParameter(searchString, "searchString");
        if (StringsKt.isBlank(searchString)) {
            return CollectionsKt.toList((Iterable)$this$query.values());
        }
        Object object = searchString.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(object, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        String[] search = object;
        object = new String[]{" "};
        List queries = StringsKt.split$default((CharSequence)search, object, false, 0, 6, null);
        object = queries;
        List initial$iv = CollectionsKt.toList((Iterable)$this$query.values());
        boolean $i$f$fold = false;
        List accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void $this$filterTo$iv$iv;
            String string2 = (String)element$iv;
            List results = accumulator$iv;
            boolean bl = false;
            Iterable $this$filter$iv = results;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                void query;
                TextureMetaStore.TextureMeta it = (TextureMetaStore.TextureMeta)element$iv$iv;
                boolean bl2 = false;
                boolean bl3 = StringsKt.startsWith$default((String)query, "@", false, 2, null) ? AreaEditorKt.query$tagMatches(it, StringsKt.drop((String)query, 1)) : AreaEditorKt.query$nameMatches(it, (String)query) || AreaEditorKt.query$tagMatches(it, (String)query);
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            accumulator$iv = (List)destination$iv$iv;
        }
        return accumulator$iv;
    }

    public static final void drawViewBox() {
        shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        shapeRenderer.setColor(Color.WHITE);
        ShapeRendererKt.rect(shapeRenderer, Vector2Kt.dw(viewBoxPos), Vector2Kt.dw(viewBoxSize));
        shapeRenderer.end();
    }

    private static final void drawBackgroundTiles(String type2, TextureMetaStore texturesStore) {
        List list;
        AssetManager this_$iv;
        boolean $i$f$get;
        AssetRef assetRef$iv;
        Object object = type2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(object, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        String selectedType = object;
        if (Intrinsics.areEqual(selectedType, "none")) {
            return;
        }
        if (Intrinsics.areEqual(selectedType, "forest")) {
            object = TBEngineKt.getGlobals().getAssetManager();
            assetRef$iv = Asset.Tileset.INSTANCE.getGrass();
            $i$f$get = false;
            try {
                Object object2 = this_$iv.getAssets().get(assetRef$iv);
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<com.badlogic.gdx.graphics.g2d.TextureRegion>");
                }
                list = (List)object2;
            }
            catch (Exception ex$iv) {
                Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                throw ex$iv;
            }
        }
        if (Intrinsics.areEqual(selectedType, "bleak")) {
            this_$iv = TBEngineKt.getGlobals().getAssetManager();
            assetRef$iv = Asset.Tileset.INSTANCE.getBleakGrass();
            $i$f$get = false;
            try {
                Object object3 = this_$iv.getAssets().get(assetRef$iv);
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<com.badlogic.gdx.graphics.g2d.TextureRegion>");
                }
                list = (List)object3;
            }
            catch (Exception ex$iv) {
                Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                throw ex$iv;
            }
        }
        this_$iv = TBEngineKt.getGlobals().getAssetManager();
        assetRef$iv = Asset.Tileset.INSTANCE.getRedBossTiles();
        $i$f$get = false;
        try {
            Object object4 = this_$iv.getAssets().get(assetRef$iv);
            if (object4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<com.badlogic.gdx.graphics.g2d.TextureRegion>");
            }
            list = (List)object4;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        List bgTiles = list;
        int scale = 2;
        float startX = 3.0f;
        float size = 0.25f * (float)scale;
        int xTiles = 40;
        int yTiles = 34;
        spriteBatch.begin();
        Iterable $this$forEach$iv = RangesKt.step(RangesKt.until(0, xTiles), scale);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int x = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Iterable $this$forEach$iv2 = RangesKt.step(RangesKt.until(0, yTiles), scale);
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv2.iterator();
            while (iterator3.hasNext()) {
                int element$iv2;
                int y = element$iv2 = ((IntIterator)iterator3).nextInt();
                boolean bl2 = false;
                spriteBatch.draw((TextureRegion)bgTiles.get((x / scale + y / scale) % bgTiles.size()), ((float)x * 0.25f + startX) * 120.0f, (float)y * 0.25f * 120.0f, size * 120.0f, size * 120.0f);
            }
        }
        spriteBatch.end();
    }

    private static final void drawUiAreas() {
        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        shapeRenderer.setColor(new Color(0.12f, 0.1f, 0.1f, 1.0f));
        ShapeRendererKt.rect(shapeRenderer, Vector2Kt.x(0.0f, 0.0f), Vector2Kt.x(360.0f, 1080.0f));
        shapeRenderer.setColor(new Color(0.1f, 0.1f, 0.1f, 1.0f));
        ShapeRendererKt.rect(shapeRenderer, Vector2Kt.x(1560.0f, 0.0f), Vector2Kt.x(360.0f, 1080.0f));
        shapeRenderer.setColor(new Color(0.1f, 0.1f, 0.1f, 1.0f));
        ShapeRendererKt.rect(shapeRenderer, Vector2Kt.dw(Vector2Kt.x(3.0f, 8.5f)), Vector2Kt.dw(Vector2Kt.x(10.0f, 10.0f)));
        shapeRenderer.end();
    }

    private static final void drawGrid() {
        int it;
        int element$iv;
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        shapeRenderer.setColor(new Color(0.05f, 0.05f, 0.05f, 0.35f));
        shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        Iterable $this$forEach$iv = new IntRange(0, 64);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            float x = (float)it * 0.26666668f;
            shapeRenderer.line(Vector2Kt.x(x * 120.0f, 0.0f), Vector2Kt.x(x * 120.0f, 1080.0f));
        }
        $this$forEach$iv = new IntRange(0, 36);
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            float y = (float)it * 0.26666668f;
            shapeRenderer.line(Vector2Kt.x(0.0f, y * 120.0f), Vector2Kt.x(1920.0f, y * 120.0f));
        }
        shapeRenderer.end();
        Gdx.gl.glDisable(3042);
    }

    private static final boolean query$nameMatches(TextureMetaStore.TextureMeta $this$query_u24nameMatches, String search) {
        String string2 = $this$query_u24nameMatches.getName().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return StringsKt.contains$default((CharSequence)string2, search, false, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean query$tagMatches(TextureMetaStore.TextureMeta $this$query_u24tagMatches, String search) {
        boolean bl;
        Iterable $this$any$iv = $this$query_u24tagMatches.getTags();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            Tag tag = (Tag)((Object)element$iv);
            boolean bl2 = false;
            String string2 = tag.getTagName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (StringsKt.startsWith$default(string2, search, false, 2, null)) return true;
            String[] $this$any$iv2 = tag.getKeywords();
            boolean $i$f$any2 = false;
            for (String element$iv2 : $this$any$iv2) {
                String keyWord = element$iv2;
                boolean bl3 = false;
                String string3 = keyWord.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (!StringsKt.startsWith$default(string3, search, false, 2, null)) continue;
                return true;
            }
            boolean bl4 = false;
            if (bl4) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static final /* synthetic */ SpriteBatch access$getSpriteBatch$p() {
        return spriteBatch;
    }

    public static final /* synthetic */ void access$drawBackgroundTiles(String type2, TextureMetaStore texturesStore) {
        AreaEditorKt.drawBackgroundTiles(type2, texturesStore);
    }

    public static final /* synthetic */ void access$drawUiAreas() {
        AreaEditorKt.drawUiAreas();
    }

    public static final /* synthetic */ void access$drawGrid() {
        AreaEditorKt.drawGrid();
    }
}

