/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.tools.editor.area.AreaEntityData;
import org.veiset.kgame.engine.tools.editor.area.AreaEntityKt;
import org.veiset.kgame.engine.tools.editor.area.AreaResourceKt;
import org.veiset.kgame.engine.tools.editor.area.BaseEntityData;
import org.veiset.kgame.engine.tools.editor.area.CollisionEntity;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0010\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005J\u0013\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006$"}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/CollisionEntityData;", "Lorg/veiset/kgame/engine/tools/editor/area/AreaEntityData;", "id", "", "position", "Lcom/badlogic/gdx/math/Vector2;", "size", "boundingBox", "", "(Ljava/lang/String;Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;Z)V", "getBoundingBox", "()Z", "setBoundingBox", "(Z)V", "getId", "()Ljava/lang/String;", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "getSize", "component1", "component2", "component3", "component4", "copy", "deepCopy", "equals", "other", "", "hashCode", "", "toCollisionEntity", "Lorg/veiset/kgame/engine/tools/editor/area/CollisionEntity;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "toString", "Companion", "kgame2"})
public final class CollisionEntityData
extends AreaEntityData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final Vector2 position;
    @NotNull
    private final Vector2 size;
    private boolean boundingBox;

    public CollisionEntityData(@NotNull String id, @NotNull Vector2 position, @NotNull Vector2 size, boolean boundingBox) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(size, "size");
        super(null);
        this.id = id;
        this.position = position;
        this.size = size;
        this.boundingBox = boundingBox;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    @NotNull
    public final Vector2 getSize() {
        return this.size;
    }

    public final boolean getBoundingBox() {
        return this.boundingBox;
    }

    public final void setBoundingBox(boolean bl) {
        this.boundingBox = bl;
    }

    @NotNull
    public final CollisionEntity toCollisionEntity(@NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        Vector2 vector2 = Vector2Kt.copy(this.position);
        Vector2 vector22 = Vector2Kt.copy(this.size);
        String string2 = this.id;
        boolean bl = this.boundingBox;
        return new CollisionEntity(world, new BaseEntityData(vector2, vector22, bl, string2));
    }

    @NotNull
    public final CollisionEntityData deepCopy(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return new CollisionEntityData(this.id, Vector2Kt.copy(position), Vector2Kt.copy(this.size), this.boundingBox);
    }

    public static /* synthetic */ CollisionEntityData deepCopy$default(CollisionEntityData collisionEntityData, Vector2 vector2, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = collisionEntityData.position;
        }
        return collisionEntityData.deepCopy(vector2);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final Vector2 component2() {
        return this.position;
    }

    @NotNull
    public final Vector2 component3() {
        return this.size;
    }

    public final boolean component4() {
        return this.boundingBox;
    }

    @NotNull
    public final CollisionEntityData copy(@NotNull String id, @NotNull Vector2 position, @NotNull Vector2 size, boolean boundingBox) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(size, "size");
        return new CollisionEntityData(id, position, size, boundingBox);
    }

    public static /* synthetic */ CollisionEntityData copy$default(CollisionEntityData collisionEntityData, String string2, Vector2 vector2, Vector2 vector22, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = collisionEntityData.id;
        }
        if ((n & 2) != 0) {
            vector2 = collisionEntityData.position;
        }
        if ((n & 4) != 0) {
            vector22 = collisionEntityData.size;
        }
        if ((n & 8) != 0) {
            bl = collisionEntityData.boundingBox;
        }
        return collisionEntityData.copy(string2, vector2, vector22, bl);
    }

    @NotNull
    public String toString() {
        return "CollisionEntityData(id=" + this.id + ", position=" + this.position + ", size=" + this.size + ", boundingBox=" + this.boundingBox + ')';
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + this.position.hashCode();
        result2 = result2 * 31 + this.size.hashCode();
        int n = this.boundingBox ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CollisionEntityData)) {
            return false;
        }
        CollisionEntityData collisionEntityData = (CollisionEntityData)other;
        if (!Intrinsics.areEqual(this.id, collisionEntityData.id)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.position, collisionEntityData.position)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.size, collisionEntityData.size)) {
            return false;
        }
        return this.boundingBox == collisionEntityData.boundingBox;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/CollisionEntityData$Companion;", "", "()V", "fromString", "Lorg/veiset/kgame/engine/tools/editor/area/CollisionEntityData;", "data", "", "kgame2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CollisionEntityData fromString(@NotNull String data2) {
            Intrinsics.checkNotNullParameter(data2, "data");
            Map<String, String> attr = AreaEntityKt.dataMapFromStr(data2);
            String string2 = attr.get("id");
            Intrinsics.checkNotNull(string2);
            String string3 = attr.get("position");
            Intrinsics.checkNotNull(string3);
            Vector2 vector2 = AreaResourceKt.toVector2(string3);
            Intrinsics.checkNotNull(vector2);
            String string4 = attr.get("size");
            Intrinsics.checkNotNull(string4);
            Vector2 vector22 = AreaResourceKt.toVector2(string4);
            Intrinsics.checkNotNull(vector22);
            return new CollisionEntityData(string2, vector2, vector22, Boolean.parseBoolean(attr.getOrDefault("boundingBox", "true")));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

