/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area.components;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.input.MouseKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.storage.TextureMetaStore;
import org.veiset.kgame.engine.tools.editor.area.AreaEditorKt;
import org.veiset.kgame.engine.util.GdxUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/components/PlacementPreviewer;", "", "defaultScale", "", "(F)V", "getDefaultScale", "()F", "setDefaultScale", "spriteBatch", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "getSpriteBatch", "()Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "draw", "", "textureMeta", "Lorg/veiset/kgame/engine/storage/TextureMetaStore$TextureMeta;", "kgame2"})
public final class PlacementPreviewer {
    private float defaultScale;
    @NotNull
    private final SpriteBatch spriteBatch;

    public PlacementPreviewer(float defaultScale) {
        this.defaultScale = defaultScale;
        this.spriteBatch = TBEngineKt.getGlobals().getDrawGfx().getSpriteBatch();
    }

    public /* synthetic */ PlacementPreviewer(float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        this(f);
    }

    public final float getDefaultScale() {
        return this.defaultScale;
    }

    public final void setDefaultScale(float f) {
        this.defaultScale = f;
    }

    @NotNull
    public final SpriteBatch getSpriteBatch() {
        return this.spriteBatch;
    }

    public final void draw(@NotNull TextureMetaStore.TextureMeta textureMeta) {
        Intrinsics.checkNotNullParameter(textureMeta, "textureMeta");
        if (AreaEditorKt.isInsideScene()) {
            Vector2 pointer = MouseKt.scaledPointer();
            TextureRegion texture = textureMeta.getTexture();
            Pair<Integer, Integer> pair = textureMeta.getTextureSize();
            int sx = ((Number)pair.component1()).intValue();
            int sy = ((Number)pair.component2()).intValue();
            Vector2 size = Vector2Kt.x((float)sx / 120.0f * this.defaultScale, (float)sy / 120.0f * this.defaultScale);
            Vector2 vector2 = Vector2Kt.copy(size).scl(0.5f);
            Intrinsics.checkNotNullExpressionValue(vector2, "size.copy().scl(0.5f)");
            Vector2 position = Vector2Kt.minus(pointer, vector2);
            Gdx.gl.glEnable(3042);
            Gdx.gl.glBlendFunc(770, 771);
            this.spriteBatch.setColor(ColorKt.color(1.0f, 1.0f, 1.0f, 0.6f));
            this.spriteBatch.begin();
            GdxUtilsKt.draw(this.spriteBatch, texture, Vector2Kt.dw(position), Vector2Kt.dw(size));
            this.spriteBatch.end();
            this.spriteBatch.setColor(ColorKt.color(1.0f, 1.0f, 1.0f, 1.0f));
            Gdx.gl.glDisable(3042);
        }
    }

    public PlacementPreviewer() {
        this(0.0f, 1, null);
    }
}

