/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.ui.components;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.input.MouseKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.tools.ui.UiComponent;
import org.veiset.kgame.engine.tools.ui.UiComponentsKt;
import org.veiset.kgame.engine.util.FontUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\t\u0010'\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0003J\t\u0010)\u001a\u00020\bH\u00c6\u0003J\t\u0010*\u001a\u00020\nH\u00c6\u0003J\u0015\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003JS\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0001J\b\u0010-\u001a\u00020.H\u0016J\u0013\u0010/\u001a\u00020\u00142\b\u00100\u001a\u0004\u0018\u000101H\u00d6\u0003J\t\u00102\u001a\u00020\bH\u00d6\u0001J\u000b\u00103\u001a\u00028\u0000\u00a2\u0006\u0002\u00104J\t\u00105\u001a\u00020\rH\u00d6\u0001J\b\u00106\u001a\u00020.H\u0016R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/veiset/kgame/engine/tools/ui/components/Dropdown;", "T", "Lorg/veiset/kgame/engine/tools/ui/UiComponent;", "position", "Lcom/badlogic/gdx/math/Vector2;", "options", "", "selected", "", "minSize", "", "text", "Lkotlin/Function1;", "", "(Lcom/badlogic/gdx/math/Vector2;Ljava/util/List;IFLkotlin/jvm/functions/Function1;)V", "maxTextSizeX", "maxTextSizeY", "getMinSize", "()F", "open", "", "getOpen", "()Z", "setOpen", "(Z)V", "openedSize", "getOptions", "()Ljava/util/List;", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "getSelected", "()I", "setSelected", "(I)V", "size", "getText", "()Lkotlin/jvm/functions/Function1;", "tp", "ySize", "component1", "component2", "component3", "component4", "component5", "copy", "draw", "", "equals", "other", "", "hashCode", "selectedOption", "()Ljava/lang/Object;", "toString", "update", "kgame2"})
public final class Dropdown<T>
implements UiComponent {
    @NotNull
    private final Vector2 position;
    @NotNull
    private final List<T> options;
    private int selected;
    private final float minSize;
    @NotNull
    private final Function1<T, String> text;
    private final float ySize;
    private final float maxTextSizeX;
    private final float maxTextSizeY;
    @NotNull
    private final Vector2 size;
    @NotNull
    private final Vector2 openedSize;
    @NotNull
    private final Vector2 tp;
    private boolean open;

    public Dropdown(@NotNull Vector2 position, @NotNull List<? extends T> options, int selected, float minSize, @NotNull Function1<? super T, String> text) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.checkNotNullParameter(text, "text");
        this.position = position;
        this.options = options;
        this.selected = selected;
        this.minSize = minSize;
        this.text = text;
        this.ySize = 0.25f;
        Iterable iterable = this.options;
        Dropdown dropdown = this;
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Object it22 = iterator2.next();
        boolean bl = false;
        float it22 = FontUtilsKt.sizeX(UiComponentsKt.getFont(), this.getText().invoke(it22));
        while (iterator2.hasNext()) {
            Object it32 = iterator2.next();
            $i$a$-maxOf-Dropdown$maxTextSizeX$1 = false;
            float it32 = FontUtilsKt.sizeX(UiComponentsKt.getFont(), this.getText().invoke(it32));
            it22 = Math.max(it22, it32);
        }
        float f = it22;
        dropdown.maxTextSizeX = Math.max(f, this.minSize);
        iterable = this.options;
        dropdown = this;
        iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Object it = iterator2.next();
        boolean bl2 = false;
        float f2 = FontUtilsKt.sizeY(UiComponentsKt.getFont(), this.getText().invoke(it));
        while (iterator2.hasNext()) {
            Object it3 = iterator2.next();
            $i$a$-maxOf-Dropdown$maxTextSizeY$1 = false;
            float f3 = FontUtilsKt.sizeY(UiComponentsKt.getFont(), this.getText().invoke(it3));
            f2 = Math.max(f2, f3);
        }
        dropdown.maxTextSizeY = f = f2;
        this.size = Vector2Kt.x(this.maxTextSizeX + 0.2f, 0.25f);
        this.openedSize = new Vector2(this.size.x, this.ySize * (float)this.options.size());
        this.tp = Vector2Kt.dw(Vector2Kt.plus(this.position, new Vector2(0.05f, 0.18f)));
    }

    public /* synthetic */ Dropdown(Vector2 vector2, List list, int n, float f, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            f = 1.2f;
        }
        if ((n2 & 0x10) != 0) {
            function1 = 1.INSTANCE;
        }
        this(vector2, list, n, f, function1);
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    @NotNull
    public final List<T> getOptions() {
        return this.options;
    }

    public final int getSelected() {
        return this.selected;
    }

    public final void setSelected(int n) {
        this.selected = n;
    }

    public final float getMinSize() {
        return this.minSize;
    }

    @NotNull
    public final Function1<T, String> getText() {
        return this.text;
    }

    public final boolean getOpen() {
        return this.open;
    }

    public final void setOpen(boolean bl) {
        this.open = bl;
    }

    public final T selectedOption() {
        return this.options.get(this.selected);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw() {
        Vector2 s = !this.open ? this.size : this.openedSize;
        UiComponentsKt.getShapeRenderer().begin(ShapeRenderer.ShapeType.Filled);
        UiComponentsKt.getShapeRenderer().setColor(Color.BLACK);
        ShapeRendererKt.rect(UiComponentsKt.getShapeRenderer(), Vector2Kt.plus(Vector2Kt.dw(this.position), Vector2Kt.dw(this.size)), Vector2Kt.unaryMinus(Vector2Kt.dw(s)));
        UiComponentsKt.getShapeRenderer().end();
        UiComponentsKt.getShapeRenderer().begin(ShapeRenderer.ShapeType.Line);
        UiComponentsKt.getShapeRenderer().setColor(Color.LIGHT_GRAY);
        ShapeRendererKt.rect(UiComponentsKt.getShapeRenderer(), Vector2Kt.plus(Vector2Kt.dw(this.position), Vector2Kt.dw(this.size)), Vector2Kt.unaryMinus(Vector2Kt.dw(s)));
        UiComponentsKt.getShapeRenderer().end();
        UiComponentsKt.getSpriteBatch().begin();
        UiComponentsKt.getFont().setColor(Color.WHITE);
        if (this.open) {
            Iterable $this$forEachIndexed$iv = this.options;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void s2;
                int n = index$iv;
                index$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv;
                int index = n;
                boolean bl = false;
                if (this.getSelected() == index) {
                    UiComponentsKt.getFont().setColor(Color.WHITE);
                } else {
                    UiComponentsKt.getFont().setColor(Color.GRAY);
                }
                UiComponentsKt.getFont().draw((Batch)UiComponentsKt.getSpriteBatch(), this.getText().invoke(s2), this.tp.x, this.tp.y - this.ySize * (float)index * 120.0f);
            }
        } else {
            UiComponentsKt.getFont().draw((Batch)UiComponentsKt.getSpriteBatch(), this.text.invoke(this.options.get(this.selected)), this.tp.x, this.tp.y);
        }
        UiComponentsKt.getSpriteBatch().end();
    }

    @Override
    public void update() {
        if (Gdx.input.isButtonJustPressed(0)) {
            if (!this.open) {
                this.open = Vector2Kt.uiPointerWithinSquare(this.position, this.size);
            } else if (this.open) {
                boolean clicked = Vector2Kt.uiPointerWithinSquare(Vector2Kt.minus(Vector2Kt.plus(this.position, this.size), this.openedSize), this.openedSize);
                if (clicked) {
                    float y = this.position.y + this.size.y - MouseKt.uiPointer().y;
                    this.selected = (int)(y / this.ySize);
                    Log.INSTANCE.info(Intrinsics.stringPlus("Dropdown selected: ", this.text.invoke(this.selectedOption())));
                }
                this.open = false;
            }
        }
    }

    @NotNull
    public final Vector2 component1() {
        return this.position;
    }

    @NotNull
    public final List<T> component2() {
        return this.options;
    }

    public final int component3() {
        return this.selected;
    }

    public final float component4() {
        return this.minSize;
    }

    @NotNull
    public final Function1<T, String> component5() {
        return this.text;
    }

    @NotNull
    public final Dropdown<T> copy(@NotNull Vector2 position, @NotNull List<? extends T> options, int selected, float minSize, @NotNull Function1<? super T, String> text) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.checkNotNullParameter(text, "text");
        return new Dropdown<T>(position, options, selected, minSize, text);
    }

    public static /* synthetic */ Dropdown copy$default(Dropdown dropdown, Vector2 vector2, List list, int n, float f, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            vector2 = dropdown.position;
        }
        if ((n2 & 2) != 0) {
            list = dropdown.options;
        }
        if ((n2 & 4) != 0) {
            n = dropdown.selected;
        }
        if ((n2 & 8) != 0) {
            f = dropdown.minSize;
        }
        if ((n2 & 0x10) != 0) {
            function1 = dropdown.text;
        }
        return dropdown.copy(vector2, list, n, f, function1);
    }

    @NotNull
    public String toString() {
        return "Dropdown(position=" + this.position + ", options=" + this.options + ", selected=" + this.selected + ", minSize=" + this.minSize + ", text=" + this.text + ')';
    }

    public int hashCode() {
        int result2 = this.position.hashCode();
        result2 = result2 * 31 + ((Object)this.options).hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.selected);
        result2 = result2 * 31 + Float.hashCode(this.minSize);
        result2 = result2 * 31 + this.text.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Dropdown)) {
            return false;
        }
        Dropdown dropdown = (Dropdown)other;
        if (!Intrinsics.areEqual(this.position, dropdown.position)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.options, dropdown.options)) {
            return false;
        }
        if (this.selected != dropdown.selected) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.minSize), (Object)Float.valueOf(dropdown.minSize))) {
            return false;
        }
        return Intrinsics.areEqual(this.text, dropdown.text);
    }
}

