/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ui;

import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.ui.Buff;
import org.veiset.kgame.engine.ui.ModifierText;
import org.veiset.kgame.engine.ui.component.UIButton;
import org.veiset.kgame.engine.ui.component.UIComponentKt;
import org.veiset.kgame.engine.ui.component.UILayout;
import org.veiset.kgame.engine.util.FontUtilsKt;
import org.veiset.kgame.engine.util.GdxUtilsKt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00010B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0013H\u0002J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010.\u001a\u00020\u000fH\u0002J\b\u0010/\u001a\u00020)H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u000e\u0010\u001a\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/veiset/kgame/engine/ui/SelectPowerUpUI;", "Lorg/veiset/kgame/engine/ui/component/UILayout;", "active", "", "choices", "", "Lorg/veiset/kgame/engine/ui/Buff;", "(ZLjava/util/List;)V", "getActive", "()Z", "setActive", "(Z)V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "components", "Lorg/veiset/kgame/engine/ui/SelectPowerUpUI$ChoiceComponent;", "descriptionFont", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "iconPosition", "Lcom/badlogic/gdx/math/Vector2;", "getIconPosition", "()Lcom/badlogic/gdx/math/Vector2;", "setIconPosition", "(Lcom/badlogic/gdx/math/Vector2;)V", "iconSize", "getIconSize", "optionSize", "sb", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "selected", "getSelected", "()Lorg/veiset/kgame/engine/ui/Buff;", "setSelected", "(Lorg/veiset/kgame/engine/ui/Buff;)V", "sr", "Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "startPosition", "titleFont", "calculateIconPos", "position", "close", "", "draw", "delta", "", "drawPowerUpElement", "choiceComponent", "open", "ChoiceComponent", "kgame2"})
public final class SelectPowerUpUI
implements UILayout {
    private boolean active;
    @NotNull
    private final AssetManager am;
    @NotNull
    private final ShapeRenderer sr;
    @NotNull
    private final SpriteBatch sb;
    @NotNull
    private final BitmapFont titleFont;
    @NotNull
    private final BitmapFont descriptionFont;
    @NotNull
    private final Vector2 iconSize;
    @Nullable
    private Buff selected;
    @Nullable
    private Vector2 iconPosition;
    @NotNull
    private final Vector2 startPosition;
    @NotNull
    private final Vector2 optionSize;
    @NotNull
    private final List<ChoiceComponent> components;

    /*
     * WARNING - void declaration
     */
    public SelectPowerUpUI(boolean active, @NotNull List<Buff> choices) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        BitmapFont bitmapFont;
        BitmapFont bitmapFont2;
        AssetRef assetRef$iv;
        Object this_$iv;
        Intrinsics.checkNotNullParameter(choices, "choices");
        this.active = active;
        this.am = TBEngineKt.getGlobals().getAssetManager();
        this.sr = TBEngineKt.getGlobals().getDrawUi().getShapeRenderer();
        this.sb = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
        AssetManager assetManager = this.am;
        AssetRef assetRef = Asset.Font.INSTANCE.getJbb20();
        SelectPowerUpUI selectPowerUpUI = this;
        boolean $i$f$get = false;
        try {
            Object object = ((AssetManager)this_$iv).getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont2 = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        selectPowerUpUI.titleFont = bitmapFont2;
        this_$iv = this.am;
        assetRef$iv = Asset.Font.INSTANCE.getJbt16();
        selectPowerUpUI = this;
        $i$f$get = false;
        try {
            Object object = ((AssetManager)this_$iv).getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        selectPowerUpUI.descriptionFont = bitmapFont;
        this.iconSize = Vector2Kt.x(0.6f, 0.6f);
        this.startPosition = Vector2Kt.x(3.2f, 4.0f);
        this.optionSize = Vector2Kt.x(3.0f, 3.0f);
        this_$iv = choices;
        selectPowerUpUI = this;
        boolean $i$f$mapIndexed = false;
        void $i$f$get2 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void buff;
            void index;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Buff buff2 = (Buff)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Vector2 position = Vector2Kt.plus(this.startPosition, new Vector2((float)index * (this.startPosition.x + 0.2f), 0.0f));
            collection.add(new ChoiceComponent(position, buff.getTitle(), new ModifierText(this.descriptionFont, buff.getDescription(), 28, 0.23f), new UIButton("Select", Vector2Kt.plus(position, Vector2Kt.x(0.53f, 0.15f)), 0.0f, null, 0.0f, new Function0<Unit>(this, (Buff)buff, position){
                final /* synthetic */ SelectPowerUpUI this$0;
                final /* synthetic */ Buff $buff;
                final /* synthetic */ Vector2 $position;
                {
                    this.this$0 = $receiver;
                    this.$buff = $buff;
                    this.$position = $position;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.setSelected(this.$buff);
                    this.this$0.setIconPosition(SelectPowerUpUI.access$calculateIconPos(this.this$0, this.$position));
                    this.this$0.close();
                }
            }, 28, null), buff.getIcon()));
        }
        selectPowerUpUI.components = (List)destination$iv$iv;
        this.open();
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @NotNull
    public final Vector2 getIconSize() {
        return this.iconSize;
    }

    @Nullable
    public final Buff getSelected() {
        return this.selected;
    }

    public final void setSelected(@Nullable Buff buff) {
        this.selected = buff;
    }

    @Nullable
    public final Vector2 getIconPosition() {
        return this.iconPosition;
    }

    public final void setIconPosition(@Nullable Vector2 vector2) {
        this.iconPosition = vector2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void open() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.components;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChoiceComponent choiceComponent = (ChoiceComponent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getButton());
        }
        UIComponentKt.bindInput((List)destination$iv$iv);
        this.setActive(true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.components;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChoiceComponent choiceComponent = (ChoiceComponent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getButton());
        }
        UIComponentKt.unbindInput((List)destination$iv$iv);
        this.setActive(false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw(float delta) {
        Iterable $this$forEachIndexed$iv = this.components;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void component;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ChoiceComponent choiceComponent = (ChoiceComponent)item$iv;
            int index = n;
            boolean bl = false;
            this.drawPowerUpElement(delta, (ChoiceComponent)component);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawPowerUpElement(float delta, ChoiceComponent choiceComponent) {
        TextureRegion textureRegion;
        void assetRef$iv;
        Vector2 position = choiceComponent.getPosition();
        UIButton button = choiceComponent.getButton();
        ModifierText description2 = choiceComponent.getDescription();
        String title = choiceComponent.getTitle();
        float titleTextX = FontUtilsKt.middleX(this.titleFont, title, position.x, position.x + this.optionSize.x);
        GdxUtilsKt.opacity(this.sr, ShapeRenderer.ShapeType.Filled, (Function1<? super ShapeRenderer, Unit>)new Function1<ShapeRenderer, Unit>(position, this){
            final /* synthetic */ Vector2 $position;
            final /* synthetic */ SelectPowerUpUI this$0;
            {
                this.$position = $position;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ShapeRenderer $this$opacity) {
                Intrinsics.checkNotNullParameter($this$opacity, "$this$opacity");
                $this$opacity.setColor(ColorKt.color(0.0f, 0.1f, 0.2f, 0.9f));
                ShapeRendererKt.rect($this$opacity, Vector2Kt.dw(this.$position), Vector2Kt.dw(SelectPowerUpUI.access$getOptionSize$p(this.this$0)));
            }
        });
        this.sr.begin(ShapeRenderer.ShapeType.Line);
        this.sr.setColor(ColorKt.color(0.0f, 0.0f, 0.0f, 1.0f));
        ShapeRendererKt.rect(this.sr, Vector2Kt.dw(position), Vector2Kt.dw(this.optionSize));
        this.sr.end();
        button.draw(delta);
        this.sb.begin();
        GdxUtilsKt.draw(this.titleFont, this.sb, title, Vector2Kt.dw(Vector2Kt.plus(position, Vector2Kt.x(titleTextX, this.optionSize.y - 0.2f))));
        AssetManager assetManager = this.am;
        AssetRef assetRef = choiceComponent.getIcon();
        SpriteBatch spriteBatch = this.sb;
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        GdxUtilsKt.draw(spriteBatch, textureRegion, Vector2Kt.dw(this.calculateIconPos(position)), Vector2Kt.dw(this.iconSize));
        this.sb.end();
        description2.draw(this.sb, Vector2Kt.plus(position, Vector2Kt.x(0.0f, 1.5f)), this.optionSize.x);
    }

    private final Vector2 calculateIconPos(Vector2 position) {
        return Vector2Kt.plus(position, Vector2Kt.x(this.optionSize.x / 2.0f - 0.3f, 1.8f));
    }

    public static final /* synthetic */ Vector2 access$getOptionSize$p(SelectPowerUpUI $this) {
        return $this.optionSize;
    }

    public static final /* synthetic */ Vector2 access$calculateIconPos(SelectPowerUpUI $this, Vector2 position) {
        return $this.calculateIconPos(position);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u000bH\u00c6\u0003J;\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lorg/veiset/kgame/engine/ui/SelectPowerUpUI$ChoiceComponent;", "", "position", "Lcom/badlogic/gdx/math/Vector2;", "title", "", "description", "Lorg/veiset/kgame/engine/ui/ModifierText;", "button", "Lorg/veiset/kgame/engine/ui/component/UIButton;", "icon", "Lorg/veiset/kgame/engine/asset/AssetRef$IconRef;", "(Lcom/badlogic/gdx/math/Vector2;Ljava/lang/String;Lorg/veiset/kgame/engine/ui/ModifierText;Lorg/veiset/kgame/engine/ui/component/UIButton;Lorg/veiset/kgame/engine/asset/AssetRef$IconRef;)V", "getButton", "()Lorg/veiset/kgame/engine/ui/component/UIButton;", "getDescription", "()Lorg/veiset/kgame/engine/ui/ModifierText;", "getIcon", "()Lorg/veiset/kgame/engine/asset/AssetRef$IconRef;", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "getTitle", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "kgame2"})
    private static final class ChoiceComponent {
        @NotNull
        private final Vector2 position;
        @NotNull
        private final String title;
        @NotNull
        private final ModifierText description;
        @NotNull
        private final UIButton button;
        @NotNull
        private final AssetRef.IconRef icon;

        public ChoiceComponent(@NotNull Vector2 position, @NotNull String title, @NotNull ModifierText description2, @NotNull UIButton button, @NotNull AssetRef.IconRef icon) {
            Intrinsics.checkNotNullParameter(position, "position");
            Intrinsics.checkNotNullParameter(title, "title");
            Intrinsics.checkNotNullParameter(description2, "description");
            Intrinsics.checkNotNullParameter(button, "button");
            Intrinsics.checkNotNullParameter(icon, "icon");
            this.position = position;
            this.title = title;
            this.description = description2;
            this.button = button;
            this.icon = icon;
        }

        @NotNull
        public final Vector2 getPosition() {
            return this.position;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final ModifierText getDescription() {
            return this.description;
        }

        @NotNull
        public final UIButton getButton() {
            return this.button;
        }

        @NotNull
        public final AssetRef.IconRef getIcon() {
            return this.icon;
        }

        @NotNull
        public final Vector2 component1() {
            return this.position;
        }

        @NotNull
        public final String component2() {
            return this.title;
        }

        @NotNull
        public final ModifierText component3() {
            return this.description;
        }

        @NotNull
        public final UIButton component4() {
            return this.button;
        }

        @NotNull
        public final AssetRef.IconRef component5() {
            return this.icon;
        }

        @NotNull
        public final ChoiceComponent copy(@NotNull Vector2 position, @NotNull String title, @NotNull ModifierText description2, @NotNull UIButton button, @NotNull AssetRef.IconRef icon) {
            Intrinsics.checkNotNullParameter(position, "position");
            Intrinsics.checkNotNullParameter(title, "title");
            Intrinsics.checkNotNullParameter(description2, "description");
            Intrinsics.checkNotNullParameter(button, "button");
            Intrinsics.checkNotNullParameter(icon, "icon");
            return new ChoiceComponent(position, title, description2, button, icon);
        }

        public static /* synthetic */ ChoiceComponent copy$default(ChoiceComponent choiceComponent, Vector2 vector2, String string2, ModifierText modifierText, UIButton uIButton, AssetRef.IconRef iconRef, int n, Object object) {
            if ((n & 1) != 0) {
                vector2 = choiceComponent.position;
            }
            if ((n & 2) != 0) {
                string2 = choiceComponent.title;
            }
            if ((n & 4) != 0) {
                modifierText = choiceComponent.description;
            }
            if ((n & 8) != 0) {
                uIButton = choiceComponent.button;
            }
            if ((n & 0x10) != 0) {
                iconRef = choiceComponent.icon;
            }
            return choiceComponent.copy(vector2, string2, modifierText, uIButton, iconRef);
        }

        @NotNull
        public String toString() {
            return "ChoiceComponent(position=" + this.position + ", title=" + this.title + ", description=" + this.description + ", button=" + this.button + ", icon=" + this.icon + ')';
        }

        public int hashCode() {
            int result2 = this.position.hashCode();
            result2 = result2 * 31 + this.title.hashCode();
            result2 = result2 * 31 + this.description.hashCode();
            result2 = result2 * 31 + this.button.hashCode();
            result2 = result2 * 31 + this.icon.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChoiceComponent)) {
                return false;
            }
            ChoiceComponent choiceComponent = (ChoiceComponent)other;
            if (!Intrinsics.areEqual(this.position, choiceComponent.position)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.title, choiceComponent.title)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.description, choiceComponent.description)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.button, choiceComponent.button)) {
                return false;
            }
            return Intrinsics.areEqual(this.icon, choiceComponent.icon);
        }
    }
}

