/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ui.component;

import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.sound.SoundPlayer;
import org.veiset.kgame.engine.ui.component.UIComponent;
import org.veiset.kgame.engine.util.FontUtilsKt;
import org.veiset.kgame.engine.values.Asset;
import org.veiset.kgame.presentation.PPresentationKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\"\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\b\u0018\u0000 A2\u00020\u00012\u00020\u0002:\u0001ABC\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\t\u0010)\u001a\u00020\u0004H\u00c6\u0003J\t\u0010*\u001a\u00020\u0006H\u00c6\u0003J\t\u0010+\u001a\u00020\bH\u00c6\u0003J\t\u0010,\u001a\u00020\nH\u00c6\u0003J\t\u0010-\u001a\u00020\bH\u00c6\u0003J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003JK\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0001J\u0010\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\bH\u0016J\u0013\u00102\u001a\u00020\u00112\b\u00103\u001a\u0004\u0018\u000104H\u00d6\u0003J\b\u00105\u001a\u00020\u000eH\u0002J\t\u00106\u001a\u000207H\u00d6\u0001J\b\u0010 \u001a\u00020\u0011H\u0002J\u0018\u00108\u001a\u00020\u00112\u0006\u00109\u001a\u0002072\u0006\u0010:\u001a\u000207H\u0016J\t\u0010;\u001a\u00020\u0004H\u00d6\u0001J(\u0010<\u001a\u00020\u00112\u0006\u00109\u001a\u0002072\u0006\u0010:\u001a\u0002072\u0006\u0010=\u001a\u0002072\u0006\u0010>\u001a\u000207H\u0016J \u0010?\u001a\u00020\u00112\u0006\u00109\u001a\u0002072\u0006\u0010:\u001a\u0002072\u0006\u0010=\u001a\u000207H\u0016J(\u0010@\u001a\u00020\u00112\u0006\u00109\u001a\u0002072\u0006\u0010:\u001a\u0002072\u0006\u0010=\u001a\u0002072\u0006\u0010>\u001a\u000207H\u0016R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\t\u001a\u00020\n\u00a2\u0006\n\n\u0002\b\u001a\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0013\"\u0004\b\"\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001cR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/veiset/kgame/engine/ui/component/UIButton;", "Lorg/veiset/kgame/engine/ui/component/UIComponent;", "Lcom/badlogic/gdx/InputAdapter;", "text", "", "position", "Lcom/badlogic/gdx/math/Vector2;", "scale", "", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "fontOffset", "f", "Lkotlin/Function0;", "", "(Ljava/lang/String;Lcom/badlogic/gdx/math/Vector2;FLcom/badlogic/gdx/graphics/g2d/BitmapFont;FLkotlin/jvm/functions/Function0;)V", "clicked", "", "getClicked", "()Z", "setClicked", "(Z)V", "getF", "()Lkotlin/jvm/functions/Function0;", "getFont", "()Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "font$1", "getFontOffset", "()F", "fontSize", "fontXOffset", "height", "hovered", "getHovered", "setHovered", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "getScale", "getText", "()Ljava/lang/String;", "width", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "draw", "delta", "equals", "other", "", "handleMove", "hashCode", "", "mouseMoved", "screenX", "screenY", "toString", "touchDown", "pointer", "button", "touchDragged", "touchUp", "Companion", "kgame2"})
public final class UIButton
extends InputAdapter
implements UIComponent {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String text;
    @NotNull
    private final Vector2 position;
    private final float scale;
    @NotNull
    private final BitmapFont font$1;
    private final float fontOffset;
    @NotNull
    private final Function0<Unit> f;
    @NotNull
    private final Vector2 fontSize;
    private final float width;
    private final float height;
    private final float fontXOffset;
    private boolean hovered;
    private boolean clicked;
    @NotNull
    private static final BitmapFont font;
    @NotNull
    private static final TextureRegion buttonDefault;
    @NotNull
    private static final TextureRegion buttonPressed;
    @NotNull
    private static final TextureRegion buttonHovered;
    @NotNull
    private static final Sound clickSound;
    @NotNull
    private static final Sound hoverSound;

    public UIButton(@NotNull String text, @NotNull Vector2 position, float scale, @NotNull BitmapFont font, float fontOffset, @NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(font, "font");
        Intrinsics.checkNotNullParameter(f, "f");
        this.text = text;
        this.position = position;
        this.scale = scale;
        this.font$1 = font;
        this.fontOffset = fontOffset;
        this.f = f;
        this.fontSize = FontUtilsKt.gameWorldSize(this.font$1, this.text);
        this.width = (float)buttonPressed.getRegionWidth() * this.scale;
        this.height = (float)buttonPressed.getRegionHeight() * this.scale;
        this.fontXOffset = this.width / 2.0f - this.fontSize.x * 120.0f / 2.0f;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ UIButton(String string2, Vector2 vector2, float f, BitmapFont bitmapFont, float f2, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f = 3.0f;
        }
        if ((n & 8) != 0) {
            BitmapFont bitmapFont2;
            AssetManager assetManager = PPresentationKt.getAm();
            AssetRef assetRef$iv = Asset.Font.INSTANCE.getJbr20();
            boolean $i$f$get = false;
            try {
                void this_$iv;
                Object object = this_$iv.getAssets().get(assetRef$iv);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
                }
                bitmapFont2 = (BitmapFont)object;
            }
            catch (Exception ex$iv) {
                Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                throw ex$iv;
            }
            bitmapFont = bitmapFont2;
        }
        if ((n & 0x10) != 0) {
            f2 = 0.0f;
        }
        if ((n & 0x20) != 0) {
            function0 = 1.INSTANCE;
        }
        this(string2, vector2, f, bitmapFont, f2, function0);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    public final float getScale() {
        return this.scale;
    }

    @NotNull
    public final BitmapFont getFont() {
        return this.font$1;
    }

    public final float getFontOffset() {
        return this.fontOffset;
    }

    @NotNull
    public final Function0<Unit> getF() {
        return this.f;
    }

    public final boolean getHovered() {
        return this.hovered;
    }

    public final void setHovered(boolean bl) {
        this.hovered = bl;
    }

    public final boolean getClicked() {
        return this.clicked;
    }

    public final void setClicked(boolean bl) {
        this.clicked = bl;
    }

    @Override
    public void draw(float delta) {
        Vector2 vector2 = Vector2Kt.dw(this.position);
        float x = Vector2Kt.component1(vector2);
        float y = Vector2Kt.component2(vector2);
        SpriteBatch sb = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
        TextureRegion graphic = this.clicked ? buttonPressed : (this.hovered ? buttonHovered : buttonDefault);
        float fontYOffset = this.clicked ? this.height / 1.65f : this.height / 1.55f;
        sb.begin();
        sb.draw(graphic, x, y, this.width, this.height);
        this.font$1.setColor(ColorKt.color(0.835f, 0.949f, 0.984f, 1.0f));
        this.font$1.draw((Batch)sb, this.text, x + this.fontXOffset, y + fontYOffset + this.fontOffset);
        sb.end();
    }

    private final boolean hovered() {
        return Vector2Kt.uiPointerWithinSquare(this.position, Vector2Kt.gfxToWorld(Vector2Kt.x(this.width, this.height)));
    }

    private final void handleMove() {
        boolean _hovered = this.hovered();
        if (this.clicked && !_hovered) {
            this.clicked = false;
        }
        if (_hovered && !this.hovered) {
            SoundPlayer.playEffect$default(TBEngineKt.getGlobals().getSoundPlayer(), hoverSound, GameFilesKt.getGameConfig().getVolumeUi(), 0.0f, 0.0f, 12, null);
            Log.INSTANCE.debug("Button [" + this.text + "] hovered");
        }
        this.hovered = _hovered;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        this.handleMove();
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        this.handleMove();
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        this.hovered = this.hovered();
        if (this.hovered && button == 0) {
            Log.INSTANCE.debug("Button [" + this.text + "] pressed");
            hoverSound.stop();
            SoundPlayer.playEffect$default(TBEngineKt.getGlobals().getSoundPlayer(), clickSound, GameFilesKt.getGameConfig().getVolumeUi(), 0.0f, 0.0f, 12, null);
            this.clicked = true;
        }
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        this.hovered = this.hovered();
        if (this.hovered && this.clicked && button == 0) {
            Log.INSTANCE.debug("Button [" + this.text + "] clicked");
            this.f.invoke();
            this.clicked = false;
        } else if (button == 0) {
            this.clicked = false;
        }
        return false;
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final Vector2 component2() {
        return this.position;
    }

    public final float component3() {
        return this.scale;
    }

    @NotNull
    public final BitmapFont component4() {
        return this.font$1;
    }

    public final float component5() {
        return this.fontOffset;
    }

    @NotNull
    public final Function0<Unit> component6() {
        return this.f;
    }

    @NotNull
    public final UIButton copy(@NotNull String text, @NotNull Vector2 position, float scale, @NotNull BitmapFont font, float fontOffset, @NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(font, "font");
        Intrinsics.checkNotNullParameter(f, "f");
        return new UIButton(text, position, scale, font, fontOffset, f);
    }

    public static /* synthetic */ UIButton copy$default(UIButton uIButton, String string2, Vector2 vector2, float f, BitmapFont bitmapFont, float f2, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = uIButton.text;
        }
        if ((n & 2) != 0) {
            vector2 = uIButton.position;
        }
        if ((n & 4) != 0) {
            f = uIButton.scale;
        }
        if ((n & 8) != 0) {
            bitmapFont = uIButton.font$1;
        }
        if ((n & 0x10) != 0) {
            f2 = uIButton.fontOffset;
        }
        if ((n & 0x20) != 0) {
            function0 = uIButton.f;
        }
        return uIButton.copy(string2, vector2, f, bitmapFont, f2, function0);
    }

    @NotNull
    public String toString() {
        return "UIButton(text=" + this.text + ", position=" + this.position + ", scale=" + this.scale + ", font=" + this.font$1 + ", fontOffset=" + this.fontOffset + ", f=" + this.f + ')';
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        result2 = result2 * 31 + this.position.hashCode();
        result2 = result2 * 31 + Float.hashCode(this.scale);
        result2 = result2 * 31 + this.font$1.hashCode();
        result2 = result2 * 31 + Float.hashCode(this.fontOffset);
        result2 = result2 * 31 + this.f.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UIButton)) {
            return false;
        }
        UIButton uIButton = (UIButton)other;
        if (!Intrinsics.areEqual(this.text, uIButton.text)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.position, uIButton.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.scale), (Object)Float.valueOf(uIButton.scale))) {
            return false;
        }
        if (!Intrinsics.areEqual(this.font$1, uIButton.font$1)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.fontOffset), (Object)Float.valueOf(uIButton.fontOffset))) {
            return false;
        }
        return Intrinsics.areEqual(this.f, uIButton.f);
    }

    static {
        Sound sound;
        Sound sound2;
        TextureRegion textureRegion;
        TextureRegion textureRegion2;
        TextureRegion textureRegion3;
        BitmapFont bitmapFont;
        AssetManager this_$iv;
        Companion = new Companion(null);
        AssetManager assetManager = PPresentationKt.getAm();
        AssetRef assetRef$iv = Asset.Font.INSTANCE.getJbr20();
        boolean $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        font = bitmapFont;
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.UI.INSTANCE.getButtonDefault();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion3 = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        buttonDefault = textureRegion3;
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.UI.INSTANCE.getButtonPressed();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion2 = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        buttonPressed = textureRegion2;
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.UI.INSTANCE.getButtonHover();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        buttonHovered = textureRegion;
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.Sound.INSTANCE.getButtonClick();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.audio.Sound");
            }
            sound2 = (Sound)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        clickSound = sound2;
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.Sound.INSTANCE.getHover();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.audio.Sound");
            }
            sound = (Sound)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        hoverSound = sound;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/veiset/kgame/engine/ui/component/UIButton$Companion;", "", "()V", "buttonDefault", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "getButtonDefault", "()Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "buttonHovered", "getButtonHovered", "buttonPressed", "getButtonPressed", "clickSound", "Lcom/badlogic/gdx/audio/Sound;", "getClickSound", "()Lcom/badlogic/gdx/audio/Sound;", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "getFont", "()Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "hoverSound", "getHoverSound", "kgame2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BitmapFont getFont() {
            return font;
        }

        @NotNull
        public final TextureRegion getButtonDefault() {
            return buttonDefault;
        }

        @NotNull
        public final TextureRegion getButtonPressed() {
            return buttonPressed;
        }

        @NotNull
        public final TextureRegion getButtonHovered() {
            return buttonHovered;
        }

        @NotNull
        public final Sound getClickSound() {
            return clickSound;
        }

        @NotNull
        public final Sound getHoverSound() {
            return hoverSound;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

