/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ui.component;

import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.sound.SoundPlayer;
import org.veiset.kgame.engine.ui.component.UIComponent;
import org.veiset.kgame.engine.util.FontUtilsKt;
import org.veiset.kgame.engine.values.Asset;
import org.veiset.kgame.presentation.PPresentationKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\b\u0086\b\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0002>?BL\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012#\b\u0002\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\f\u00a2\u0006\u0002\u0010\u0011J\t\u0010'\u001a\u00020\u0004H\u00c6\u0003J\t\u0010(\u001a\u00020\u0006H\u00c6\u0003J\t\u0010)\u001a\u00020\bH\u00c6\u0003J\t\u0010*\u001a\u00020\nH\u00c6\u0003J$\u0010+\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\fH\u00c6\u0003JV\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2#\b\u0002\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\fH\u00c6\u0001J\u0010\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\nH\u0016J\u0013\u0010/\u001a\u00020\u00042\b\u00100\u001a\u0004\u0018\u000101H\u00d6\u0003J\b\u00102\u001a\u00020\u0010H\u0002J\t\u00103\u001a\u000204H\u00d6\u0001J\b\u00105\u001a\u00020\u0004H\u0002J\u0018\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u0002042\u0006\u00108\u001a\u000204H\u0016J\t\u00109\u001a\u00020\u0006H\u00d6\u0001J(\u0010:\u001a\u00020\u00042\u0006\u00107\u001a\u0002042\u0006\u00108\u001a\u0002042\u0006\u0010;\u001a\u0002042\u0006\u0010<\u001a\u000204H\u0016J \u0010=\u001a\u00020\u00042\u0006\u00107\u001a\u0002042\u0006\u00108\u001a\u0002042\u0006\u0010;\u001a\u000204H\u0016R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R,\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/veiset/kgame/engine/ui/component/UICheckbox;", "Lorg/veiset/kgame/engine/ui/component/UIComponent;", "Lcom/badlogic/gdx/InputAdapter;", "value", "", "text", "", "position", "Lcom/badlogic/gdx/math/Vector2;", "scale", "", "f", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "newValue", "", "(ZLjava/lang/String;Lcom/badlogic/gdx/math/Vector2;FLkotlin/jvm/functions/Function1;)V", "currentState", "Lorg/veiset/kgame/engine/ui/component/UICheckbox$CheckboxState;", "getCurrentState", "()Lorg/veiset/kgame/engine/ui/component/UICheckbox$CheckboxState;", "setCurrentState", "(Lorg/veiset/kgame/engine/ui/component/UICheckbox$CheckboxState;)V", "getF", "()Lkotlin/jvm/functions/Function1;", "height", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "getScale", "()F", "getText", "()Ljava/lang/String;", "textLength", "getValue", "()Z", "setValue", "(Z)V", "width", "component1", "component2", "component3", "component4", "component5", "copy", "draw", "delta", "equals", "other", "", "handleMove", "hashCode", "", "hovered", "mouseMoved", "screenX", "screenY", "toString", "touchDown", "pointer", "button", "touchDragged", "CheckboxState", "Companion", "kgame2"})
public final class UICheckbox
extends InputAdapter
implements UIComponent {
    @NotNull
    public static final Companion Companion;
    private boolean value;
    @NotNull
    private final String text;
    @NotNull
    private final Vector2 position;
    private final float scale;
    @NotNull
    private final Function1<Boolean, Unit> f;
    @NotNull
    private CheckboxState currentState;
    private final float width;
    private final float height;
    private final float textLength;
    @NotNull
    private static final BitmapFont font;
    @NotNull
    private static final TextureRegion checked;
    @NotNull
    private static final TextureRegion unchecked;
    @NotNull
    private static final TextureRegion checkedHover;
    @NotNull
    private static final TextureRegion uncheckedHover;
    @NotNull
    private static final Sound clickSound;
    @NotNull
    private static final Sound hoverSound;

    public UICheckbox(boolean value, @NotNull String text, @NotNull Vector2 position, float scale, @NotNull Function1<? super Boolean, Unit> f) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(f, "f");
        this.value = value;
        this.text = text;
        this.position = position;
        this.scale = scale;
        this.f = f;
        this.currentState = this.value ? CheckboxState.CHECKED : CheckboxState.UNCHECKED;
        this.width = (float)checked.getRegionWidth() * this.scale;
        this.height = (float)checked.getRegionHeight() * this.scale;
        this.textLength = FontUtilsKt.sizeX(font, this.text);
    }

    public /* synthetic */ UICheckbox(boolean bl, String string2, Vector2 vector2, float f, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f = 3.0f;
        }
        if ((n & 0x10) != 0) {
            function1 = 1.INSTANCE;
        }
        this(bl, string2, vector2, f, function1);
    }

    public final boolean getValue() {
        return this.value;
    }

    public final void setValue(boolean bl) {
        this.value = bl;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    public final float getScale() {
        return this.scale;
    }

    @NotNull
    public final Function1<Boolean, Unit> getF() {
        return this.f;
    }

    @NotNull
    public final CheckboxState getCurrentState() {
        return this.currentState;
    }

    public final void setCurrentState(@NotNull CheckboxState checkboxState) {
        Intrinsics.checkNotNullParameter((Object)checkboxState, "<set-?>");
        this.currentState = checkboxState;
    }

    private final boolean hovered() {
        return Vector2Kt.uiPointerWithinSquare(this.position, Vector2Kt.plus(Vector2Kt.gfxToWorld(Vector2Kt.x(this.width * 1.1f, this.height)), Vector2Kt.x(this.textLength, 0.0f)));
    }

    @Override
    public void draw(float delta) {
        Color color;
        TextureRegion textureRegion;
        Vector2 vector2 = Vector2Kt.dw(this.position);
        float x = Vector2Kt.component1(vector2);
        float y = Vector2Kt.component2(vector2);
        SpriteBatch sb = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentState.ordinal()]) {
            case 1: {
                textureRegion = checked;
                break;
            }
            case 2: {
                textureRegion = unchecked;
                break;
            }
            case 3: {
                textureRegion = checkedHover;
                break;
            }
            case 4: {
                textureRegion = uncheckedHover;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        TextureRegion graphic = textureRegion;
        sb.begin();
        sb.draw(graphic, x, y, this.width, this.height);
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentState.ordinal()]) {
            case 1: {
                color = ColorKt.color(1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 2: {
                color = ColorKt.color(0.9f, 0.9f, 0.9f, 1.0f);
                break;
            }
            case 3: {
                color = ColorKt.color(1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 4: {
                color = ColorKt.color(0.9f, 0.9f, 0.9f, 1.0f);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        font.setColor(color);
        font.draw((Batch)sb, this.text, x + this.width * 1.1f, y + this.height / 1.5f);
        sb.end();
    }

    private final void handleMove() {
        boolean hovered = this.hovered();
        if (hovered && (this.currentState == CheckboxState.CHECKED || this.currentState == CheckboxState.UNCHECKED)) {
            SoundPlayer.playEffect$default(TBEngineKt.getGlobals().getSoundPlayer(), hoverSound, GameFilesKt.getGameConfig().getVolumeUi(), 0.0f, 0.0f, 12, null);
            this.currentState = this.value ? CheckboxState.CHECKED_HOVER : CheckboxState.UNCHECKED_HOVER;
        } else if (!(hovered || this.currentState != CheckboxState.CHECKED_HOVER && this.currentState != CheckboxState.UNCHECKED_HOVER)) {
            this.currentState = this.value ? CheckboxState.CHECKED : CheckboxState.UNCHECKED;
        }
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        this.handleMove();
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        this.handleMove();
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        boolean hovered = this.hovered();
        if (hovered && button == 0) {
            Log.INSTANCE.debug("Checkbox pressed");
            this.value = !this.value;
            this.f.invoke(this.value);
            this.currentState = this.value ? CheckboxState.CHECKED_HOVER : CheckboxState.UNCHECKED_HOVER;
        }
        return false;
    }

    public final boolean component1() {
        return this.value;
    }

    @NotNull
    public final String component2() {
        return this.text;
    }

    @NotNull
    public final Vector2 component3() {
        return this.position;
    }

    public final float component4() {
        return this.scale;
    }

    @NotNull
    public final Function1<Boolean, Unit> component5() {
        return this.f;
    }

    @NotNull
    public final UICheckbox copy(boolean value, @NotNull String text, @NotNull Vector2 position, float scale, @NotNull Function1<? super Boolean, Unit> f) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(f, "f");
        return new UICheckbox(value, text, position, scale, f);
    }

    public static /* synthetic */ UICheckbox copy$default(UICheckbox uICheckbox, boolean bl, String string2, Vector2 vector2, float f, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = uICheckbox.value;
        }
        if ((n & 2) != 0) {
            string2 = uICheckbox.text;
        }
        if ((n & 4) != 0) {
            vector2 = uICheckbox.position;
        }
        if ((n & 8) != 0) {
            f = uICheckbox.scale;
        }
        if ((n & 0x10) != 0) {
            function1 = uICheckbox.f;
        }
        return uICheckbox.copy(bl, string2, vector2, f, function1);
    }

    @NotNull
    public String toString() {
        return "UICheckbox(value=" + this.value + ", text=" + this.text + ", position=" + this.position + ", scale=" + this.scale + ", f=" + this.f + ')';
    }

    public int hashCode() {
        int n = this.value ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int result2 = n;
        result2 = result2 * 31 + this.text.hashCode();
        result2 = result2 * 31 + this.position.hashCode();
        result2 = result2 * 31 + Float.hashCode(this.scale);
        result2 = result2 * 31 + this.f.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UICheckbox)) {
            return false;
        }
        UICheckbox uICheckbox = (UICheckbox)other;
        if (this.value != uICheckbox.value) {
            return false;
        }
        if (!Intrinsics.areEqual(this.text, uICheckbox.text)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.position, uICheckbox.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.scale), (Object)Float.valueOf(uICheckbox.scale))) {
            return false;
        }
        return Intrinsics.areEqual(this.f, uICheckbox.f);
    }

    static {
        Sound sound;
        Sound sound2;
        TextureRegion textureRegion;
        TextureRegion textureRegion2;
        TextureRegion textureRegion3;
        TextureRegion textureRegion4;
        BitmapFont bitmapFont;
        AssetManager this_$iv;
        Companion = new Companion(null);
        AssetManager assetManager = PPresentationKt.getAm();
        AssetRef assetRef$iv = Asset.Font.INSTANCE.getJbr18();
        boolean $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        font = bitmapFont;
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.UI.INSTANCE.getCheckboxChecked();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion4 = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        checked = textureRegion4;
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.UI.INSTANCE.getCheckboxUnchecked();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion3 = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        unchecked = textureRegion3;
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.UI.INSTANCE.getCheckboxCheckedHovered();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion2 = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        checkedHover = textureRegion2;
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.UI.INSTANCE.getCheckboxUncheckedHover();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        uncheckedHover = textureRegion;
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.Sound.INSTANCE.getButtonClick();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.audio.Sound");
            }
            sound2 = (Sound)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        clickSound = sound2;
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.Sound.INSTANCE.getHover();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.audio.Sound");
            }
            sound = (Sound)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        hoverSound = sound;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/veiset/kgame/engine/ui/component/UICheckbox$CheckboxState;", "", "(Ljava/lang/String;I)V", "CHECKED", "UNCHECKED", "CHECKED_HOVER", "UNCHECKED_HOVER", "kgame2"})
    public static final class CheckboxState
    extends Enum<CheckboxState> {
        public static final /* enum */ CheckboxState CHECKED = new CheckboxState();
        public static final /* enum */ CheckboxState UNCHECKED = new CheckboxState();
        public static final /* enum */ CheckboxState CHECKED_HOVER = new CheckboxState();
        public static final /* enum */ CheckboxState UNCHECKED_HOVER = new CheckboxState();
        private static final /* synthetic */ CheckboxState[] $VALUES;

        public static CheckboxState[] values() {
            return (CheckboxState[])$VALUES.clone();
        }

        public static CheckboxState valueOf(String value) {
            return Enum.valueOf(CheckboxState.class, value);
        }

        static {
            $VALUES = checkboxStateArray = new CheckboxState[]{CheckboxState.CHECKED, CheckboxState.UNCHECKED, CheckboxState.CHECKED_HOVER, CheckboxState.UNCHECKED_HOVER};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/veiset/kgame/engine/ui/component/UICheckbox$Companion;", "", "()V", "checked", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "getChecked", "()Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "checkedHover", "getCheckedHover", "clickSound", "Lcom/badlogic/gdx/audio/Sound;", "getClickSound", "()Lcom/badlogic/gdx/audio/Sound;", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "getFont", "()Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "hoverSound", "getHoverSound", "unchecked", "getUnchecked", "uncheckedHover", "getUncheckedHover", "kgame2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BitmapFont getFont() {
            return font;
        }

        @NotNull
        public final TextureRegion getChecked() {
            return checked;
        }

        @NotNull
        public final TextureRegion getUnchecked() {
            return unchecked;
        }

        @NotNull
        public final TextureRegion getCheckedHover() {
            return checkedHover;
        }

        @NotNull
        public final TextureRegion getUncheckedHover() {
            return uncheckedHover;
        }

        @NotNull
        public final Sound getClickSound() {
            return clickSound;
        }

        @NotNull
        public final Sound getHoverSound() {
            return hoverSound;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CheckboxState.values().length];
            nArray[CheckboxState.CHECKED.ordinal()] = 1;
            nArray[CheckboxState.UNCHECKED.ordinal()] = 2;
            nArray[CheckboxState.CHECKED_HOVER.ordinal()] = 3;
            nArray[CheckboxState.UNCHECKED_HOVER.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

