/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ui.component;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.ui.component.UISimpleComponent;
import org.veiset.kgame.engine.util.GdxUtilsKt;
import org.veiset.kgame.engine.values.Asset;
import org.veiset.kgame.presentation.PPresentationKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J1\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Lorg/veiset/kgame/engine/ui/component/UILabel;", "Lorg/veiset/kgame/engine/ui/component/UISimpleComponent;", "text", "", "position", "Lcom/badlogic/gdx/math/Vector2;", "color", "Lcom/badlogic/gdx/graphics/Color;", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "(Ljava/lang/String;Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/graphics/Color;Lcom/badlogic/gdx/graphics/g2d/BitmapFont;)V", "getColor", "()Lcom/badlogic/gdx/graphics/Color;", "getFont", "()Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "sb", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "getSb", "()Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "component1", "component2", "component3", "component4", "copy", "draw", "", "delta", "", "equals", "", "other", "", "hashCode", "", "toString", "kgame2"})
public final class UILabel
implements UISimpleComponent {
    @NotNull
    private String text;
    @NotNull
    private final Vector2 position;
    @NotNull
    private final Color color;
    @NotNull
    private final BitmapFont font;
    @NotNull
    private final SpriteBatch sb;

    public UILabel(@NotNull String text, @NotNull Vector2 position, @NotNull Color color, @NotNull BitmapFont font) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(font, "font");
        this.text = text;
        this.position = position;
        this.color = color;
        this.font = font;
        this.sb = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ UILabel(String string2, Vector2 vector2, Color color, BitmapFont bitmapFont, int n, DefaultConstructorMarker defaultConstructorMarker) {
        Object object;
        if ((n & 4) != 0) {
            object = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(object, "WHITE");
            color = object;
        }
        if ((n & 8) != 0) {
            BitmapFont bitmapFont2;
            object = PPresentationKt.getAm();
            AssetRef assetRef$iv = Asset.Font.INSTANCE.getJbr18();
            boolean $i$f$get = false;
            try {
                void this_$iv;
                Object object2 = this_$iv.getAssets().get(assetRef$iv);
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
                }
                bitmapFont2 = (BitmapFont)object2;
            }
            catch (Exception ex$iv) {
                Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                throw ex$iv;
            }
            bitmapFont = bitmapFont2;
        }
        this(string2, vector2, color, bitmapFont);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.text = string2;
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    @NotNull
    public final BitmapFont getFont() {
        return this.font;
    }

    @NotNull
    public final SpriteBatch getSb() {
        return this.sb;
    }

    @Override
    public void draw(float delta) {
        this.sb.begin();
        this.font.setColor(this.color);
        GdxUtilsKt.draw(this.font, this.sb, this.text, Vector2Kt.plus(Vector2Kt.dw(this.position), Vector2Kt.x(0.0f, 14.0f)));
        this.sb.end();
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final Vector2 component2() {
        return this.position;
    }

    @NotNull
    public final Color component3() {
        return this.color;
    }

    @NotNull
    public final BitmapFont component4() {
        return this.font;
    }

    @NotNull
    public final UILabel copy(@NotNull String text, @NotNull Vector2 position, @NotNull Color color, @NotNull BitmapFont font) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(font, "font");
        return new UILabel(text, position, color, font);
    }

    public static /* synthetic */ UILabel copy$default(UILabel uILabel, String string2, Vector2 vector2, Color color, BitmapFont bitmapFont, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = uILabel.text;
        }
        if ((n & 2) != 0) {
            vector2 = uILabel.position;
        }
        if ((n & 4) != 0) {
            color = uILabel.color;
        }
        if ((n & 8) != 0) {
            bitmapFont = uILabel.font;
        }
        return uILabel.copy(string2, vector2, color, bitmapFont);
    }

    @NotNull
    public String toString() {
        return "UILabel(text=" + this.text + ", position=" + this.position + ", color=" + this.color + ", font=" + this.font + ')';
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        result2 = result2 * 31 + this.position.hashCode();
        result2 = result2 * 31 + this.color.hashCode();
        result2 = result2 * 31 + this.font.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UILabel)) {
            return false;
        }
        UILabel uILabel = (UILabel)other;
        if (!Intrinsics.areEqual(this.text, uILabel.text)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.position, uILabel.position)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.color, uILabel.color)) {
            return false;
        }
        return Intrinsics.areEqual(this.font, uILabel.font);
    }
}

