/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ui.component;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.ui.component.UISimpleComponent;
import org.veiset.kgame.engine.util.FontUtilsKt;
import org.veiset.kgame.engine.util.GdxUtilsKt;
import org.veiset.kgame.engine.values.Asset;
import org.veiset.kgame.presentation.PPresentationKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\bH\u00c6\u0003J\t\u0010%\u001a\u00020\nH\u00c6\u0003J\t\u0010&\u001a\u00020\fH\u00c6\u0003JE\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\bH\u0016J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00062"}, d2={"Lorg/veiset/kgame/engine/ui/component/UILabelGroup;", "Lorg/veiset/kgame/engine/ui/component/UISimpleComponent;", "text", "", "position", "Lcom/badlogic/gdx/math/Vector2;", "size", "opacity", "", "color", "Lcom/badlogic/gdx/graphics/Color;", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "(Ljava/lang/String;Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;FLcom/badlogic/gdx/graphics/Color;Lcom/badlogic/gdx/graphics/g2d/BitmapFont;)V", "getColor", "()Lcom/badlogic/gdx/graphics/Color;", "getFont", "()Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "getOpacity", "()F", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "sb", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "getSb", "()Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "getSize", "sr", "Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "getSr", "()Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "getText", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "draw", "", "delta", "equals", "", "other", "", "hashCode", "", "toString", "kgame2"})
public final class UILabelGroup
implements UISimpleComponent {
    @NotNull
    private final String text;
    @NotNull
    private final Vector2 position;
    @NotNull
    private final Vector2 size;
    private final float opacity;
    @NotNull
    private final Color color;
    @NotNull
    private final BitmapFont font;
    @NotNull
    private final SpriteBatch sb;
    @NotNull
    private final ShapeRenderer sr;

    public UILabelGroup(@NotNull String text, @NotNull Vector2 position, @NotNull Vector2 size, float opacity, @NotNull Color color, @NotNull BitmapFont font) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(size, "size");
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(font, "font");
        this.text = text;
        this.position = position;
        this.size = size;
        this.opacity = opacity;
        this.color = color;
        this.font = font;
        this.sb = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
        this.sr = TBEngineKt.getGlobals().getDrawUi().getShapeRenderer();
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ UILabelGroup(String string2, Vector2 vector2, Vector2 vector22, float f, Color color, BitmapFont bitmapFont, int n, DefaultConstructorMarker defaultConstructorMarker) {
        Object object;
        if ((n & 8) != 0) {
            f = 0.7f;
        }
        if ((n & 0x10) != 0) {
            object = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(object, "WHITE");
            color = object;
        }
        if ((n & 0x20) != 0) {
            BitmapFont bitmapFont2;
            object = PPresentationKt.getAm();
            AssetRef assetRef$iv = Asset.Font.INSTANCE.getJbb18();
            boolean $i$f$get = false;
            try {
                void this_$iv;
                Object object2 = this_$iv.getAssets().get(assetRef$iv);
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
                }
                bitmapFont2 = (BitmapFont)object2;
            }
            catch (Exception ex$iv) {
                Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                throw ex$iv;
            }
            bitmapFont = bitmapFont2;
        }
        this(string2, vector2, vector22, f, color, bitmapFont);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    @NotNull
    public final Vector2 getSize() {
        return this.size;
    }

    public final float getOpacity() {
        return this.opacity;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    @NotNull
    public final BitmapFont getFont() {
        return this.font;
    }

    @NotNull
    public final SpriteBatch getSb() {
        return this.sb;
    }

    @NotNull
    public final ShapeRenderer getSr() {
        return this.sr;
    }

    @Override
    public void draw(float delta) {
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(ColorKt.color(0.0f, 0.0f, 0.0f, this.opacity));
        Vector2 position1 = Vector2Kt.dw(Vector2Kt.plus(this.position, Vector2Kt.x(-0.1f, FontUtilsKt.sizeY(this.font, this.text) + 0.14f)));
        Vector2 size1 = Vector2Kt.copy(Vector2Kt.dw(this.size)).scl(1.0f, -1.0f);
        Intrinsics.checkNotNullExpressionValue(size1, "size1");
        ShapeRendererKt.rect(this.sr, position1, size1);
        this.sr.end();
        this.sr.begin(ShapeRenderer.ShapeType.Line);
        this.sr.setColor(Color.TEAL);
        ShapeRendererKt.rect(this.sr, position1, size1);
        this.sr.end();
        Gdx.gl.glDisable(3042);
        this.sb.begin();
        this.font.setColor(this.color);
        GdxUtilsKt.draw(this.font, this.sb, this.text, Vector2Kt.plus(Vector2Kt.dw(this.position), Vector2Kt.x(0.0f, 14.0f)));
        this.sb.end();
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final Vector2 component2() {
        return this.position;
    }

    @NotNull
    public final Vector2 component3() {
        return this.size;
    }

    public final float component4() {
        return this.opacity;
    }

    @NotNull
    public final Color component5() {
        return this.color;
    }

    @NotNull
    public final BitmapFont component6() {
        return this.font;
    }

    @NotNull
    public final UILabelGroup copy(@NotNull String text, @NotNull Vector2 position, @NotNull Vector2 size, float opacity, @NotNull Color color, @NotNull BitmapFont font) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(size, "size");
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(font, "font");
        return new UILabelGroup(text, position, size, opacity, color, font);
    }

    public static /* synthetic */ UILabelGroup copy$default(UILabelGroup uILabelGroup, String string2, Vector2 vector2, Vector2 vector22, float f, Color color, BitmapFont bitmapFont, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = uILabelGroup.text;
        }
        if ((n & 2) != 0) {
            vector2 = uILabelGroup.position;
        }
        if ((n & 4) != 0) {
            vector22 = uILabelGroup.size;
        }
        if ((n & 8) != 0) {
            f = uILabelGroup.opacity;
        }
        if ((n & 0x10) != 0) {
            color = uILabelGroup.color;
        }
        if ((n & 0x20) != 0) {
            bitmapFont = uILabelGroup.font;
        }
        return uILabelGroup.copy(string2, vector2, vector22, f, color, bitmapFont);
    }

    @NotNull
    public String toString() {
        return "UILabelGroup(text=" + this.text + ", position=" + this.position + ", size=" + this.size + ", opacity=" + this.opacity + ", color=" + this.color + ", font=" + this.font + ')';
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        result2 = result2 * 31 + this.position.hashCode();
        result2 = result2 * 31 + this.size.hashCode();
        result2 = result2 * 31 + Float.hashCode(this.opacity);
        result2 = result2 * 31 + this.color.hashCode();
        result2 = result2 * 31 + this.font.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UILabelGroup)) {
            return false;
        }
        UILabelGroup uILabelGroup = (UILabelGroup)other;
        if (!Intrinsics.areEqual(this.text, uILabelGroup.text)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.position, uILabelGroup.position)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.size, uILabelGroup.size)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.opacity), (Object)Float.valueOf(uILabelGroup.opacity))) {
            return false;
        }
        if (!Intrinsics.areEqual(this.color, uILabelGroup.color)) {
            return false;
        }
        return Intrinsics.areEqual(this.font, uILabelGroup.font);
    }
}

