/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.util.ANode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001:\u0001'B[\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0002J \u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000eH\u0002J(\u0010$\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u000eH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010&\u001a\u00020\u0004H\u0002R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00040\u00040\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/veiset/kgame/engine/util/AStar;", "", "searchArea", "", "Lorg/veiset/kgame/engine/util/ANode;", "indexedNodes", "", "", "start", "end", "rowRange", "Lorg/veiset/kgame/engine/util/AStar$Range;", "colRange", "hvCost", "", "diagonalCost", "(Ljava/util/List;Ljava/util/Map;Lorg/veiset/kgame/engine/util/ANode;Lorg/veiset/kgame/engine/util/ANode;Lorg/veiset/kgame/engine/util/AStar$Range;Lorg/veiset/kgame/engine/util/AStar$Range;II)V", "closedSet", "Ljava/util/HashSet;", "openList", "Ljava/util/PriorityQueue;", "kotlin.jvm.PlatformType", "path", "", "getPath", "()Ljava/util/List;", "addAdjacentLowerRow", "", "currentNode", "addAdjacentMiddleRow", "addAdjacentNodes", "addAdjacentUpperRow", "calculatePath", "checkAdjacentRow", "col", "row", "checkNode", "cost", "current", "Range", "kgame2"})
public final class AStar {
    @NotNull
    private final Map<String, ANode> indexedNodes;
    @NotNull
    private final ANode start;
    @NotNull
    private final ANode end;
    @NotNull
    private final Range rowRange;
    @NotNull
    private final Range colRange;
    private final int hvCost;
    private final int diagonalCost;
    @NotNull
    private final PriorityQueue<ANode> openList;
    @NotNull
    private final HashSet<ANode> closedSet;
    @NotNull
    private final List<ANode> path;

    public AStar(@NotNull List<ANode> searchArea2, @NotNull Map<String, ANode> indexedNodes, @NotNull ANode start, @NotNull ANode end, @NotNull Range rowRange, @NotNull Range colRange, int hvCost, int diagonalCost) {
        Intrinsics.checkNotNullParameter(searchArea2, "searchArea");
        Intrinsics.checkNotNullParameter(indexedNodes, "indexedNodes");
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(end, "end");
        Intrinsics.checkNotNullParameter(rowRange, "rowRange");
        Intrinsics.checkNotNullParameter(colRange, "colRange");
        this.indexedNodes = indexedNodes;
        this.start = start;
        this.end = end;
        this.rowRange = rowRange;
        this.colRange = colRange;
        this.hvCost = hvCost;
        this.diagonalCost = diagonalCost;
        Iterable $this$forEach$iv = searchArea2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ANode it = (ANode)element$iv;
            boolean bl = false;
            it.calculateHeuristic(this.end);
        }
        this.openList = new PriorityQueue(AStar::openList$lambda-1);
        this.closedSet = new HashSet();
        this.path = this.calculatePath();
    }

    public /* synthetic */ AStar(List list, Map map2, ANode aNode, ANode aNode2, Range range, Range range2, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x40) != 0) {
            n = 10;
        }
        if ((n3 & 0x80) != 0) {
            n2 = 10;
        }
        this(list, map2, aNode, aNode2, range, range2, n, n2);
    }

    @NotNull
    public final List<ANode> getPath() {
        return this.path;
    }

    private final List<ANode> calculatePath() {
        this.openList.add(this.start);
        while (!this.openList.isEmpty()) {
            ANode current = this.openList.poll();
            this.closedSet.add(current);
            if (Intrinsics.areEqual(current, this.end)) {
                Intrinsics.checkNotNullExpressionValue(current, "current");
                return this.getPath(current);
            }
            Intrinsics.checkNotNullExpressionValue(current, "current");
            this.addAdjacentNodes(current);
        }
        return new ArrayList();
    }

    private final List<ANode> getPath(ANode current) {
        List path = new ArrayList();
        path.add(current);
        for (ANode parent = current.getParent(); parent != null; parent = parent.getParent()) {
            path.add(0, parent);
        }
        return path;
    }

    private final void addAdjacentNodes(ANode currentNode) {
        this.addAdjacentUpperRow(currentNode);
        this.addAdjacentMiddleRow(currentNode);
        this.addAdjacentLowerRow(currentNode);
    }

    private final void checkAdjacentRow(ANode currentNode, int col, int row) {
        if (col - 1 >= this.colRange.getMin()) {
            this.checkNode(currentNode, col - 1, row, this.diagonalCost);
        }
        if (col + 1 <= this.colRange.getMax()) {
            this.checkNode(currentNode, col + 1, row, this.diagonalCost);
        }
        this.checkNode(currentNode, col, row, this.hvCost);
    }

    private final void addAdjacentLowerRow(ANode currentNode) {
        int row = currentNode.getRow();
        int col = currentNode.getCol();
        int lowerRow = row + 1;
        if (lowerRow <= this.rowRange.getMax()) {
            this.checkAdjacentRow(currentNode, col, lowerRow);
        }
    }

    private final void addAdjacentMiddleRow(ANode currentNode) {
        int row = currentNode.getRow();
        int col = currentNode.getCol();
        if (col - 1 >= this.colRange.getMin()) {
            this.checkNode(currentNode, col - 1, row, this.hvCost);
        }
        if (col + 1 <= this.colRange.getMax()) {
            this.checkNode(currentNode, col + 1, row, this.hvCost);
        }
    }

    private final void addAdjacentUpperRow(ANode currentNode) {
        int row = currentNode.getRow();
        int col = currentNode.getCol();
        int upperRow = row - 1;
        if (upperRow >= 0) {
            this.checkAdjacentRow(currentNode, col, upperRow);
        }
    }

    private final void checkNode(ANode currentNode, int col, int row, int cost) {
        ANode aNode = this.indexedNodes.get("" + col + ',' + row);
        if (aNode == null) {
            return;
        }
        ANode adjacentNode = aNode;
        if (!(adjacentNode.getBlock() && !Intrinsics.areEqual(adjacentNode, this.end) || this.closedSet.contains(adjacentNode))) {
            if (!this.openList.contains(adjacentNode)) {
                adjacentNode.update(currentNode, cost);
                this.openList.add(adjacentNode);
            } else {
                boolean changed = adjacentNode.betterPath(currentNode, cost);
                if (changed) {
                    this.openList.remove(adjacentNode);
                    this.openList.add(adjacentNode);
                }
            }
        }
    }

    private static final int openList$lambda-1(ANode node0, ANode node1) {
        return Intrinsics.compare(node0.getF(), node1.getF());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/veiset/kgame/engine/util/AStar$Range;", "", "min", "", "max", "(II)V", "getMax", "()I", "getMin", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "kgame2"})
    public static final class Range {
        private final int min;
        private final int max;

        public Range(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public final int getMin() {
            return this.min;
        }

        public final int getMax() {
            return this.max;
        }

        public final int component1() {
            return this.min;
        }

        public final int component2() {
            return this.max;
        }

        @NotNull
        public final Range copy(int min, int max) {
            return new Range(min, max);
        }

        public static /* synthetic */ Range copy$default(Range range, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = range.min;
            }
            if ((n3 & 2) != 0) {
                n2 = range.max;
            }
            return range.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Range(min=" + this.min + ", max=" + this.max + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.min);
            result2 = result2 * 31 + Integer.hashCode(this.max);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Range)) {
                return false;
            }
            Range range = (Range)other;
            if (this.min != range.min) {
                return false;
            }
            return this.max == range.max;
        }
    }
}

