/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.module;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentMapper;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ktx.box2d.WorldsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.GameModule;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.ecs.attack.component.AttackType;
import org.veiset.kgame.engine.ecs.attack.component.skills.ChainComponent;
import org.veiset.kgame.engine.ecs.attack.component.skills.HomingComponent;
import org.veiset.kgame.engine.ecs.attack.entity.BallAttackEntity;
import org.veiset.kgame.engine.ecs.attack.entity.BurningGroundEntity;
import org.veiset.kgame.engine.ecs.attack.system.ProjectileAttackSystem;
import org.veiset.kgame.engine.ecs.collision.system.AreaCollisionResolveSystem;
import org.veiset.kgame.engine.ecs.collision.system.AttackCollisionResolveSystem;
import org.veiset.kgame.engine.ecs.collision.system.Box2dSystem;
import org.veiset.kgame.engine.ecs.collision.system.CollisionResolveSystem;
import org.veiset.kgame.engine.ecs.collision.system.SensorCollisionResolveSystem;
import org.veiset.kgame.engine.ecs.core.component.PositionComponent;
import org.veiset.kgame.engine.ecs.core.component.ai.PatrollingAIComponent;
import org.veiset.kgame.engine.ecs.core.component.enemy.MonsterComponent;
import org.veiset.kgame.engine.ecs.core.entity.PlayerEntity;
import org.veiset.kgame.engine.ecs.core.entity.enemy.DummyZombie;
import org.veiset.kgame.engine.ecs.core.system.FixedDurationSystem;
import org.veiset.kgame.engine.ecs.core.system.GamePauseSystem;
import org.veiset.kgame.engine.ecs.core.system.MoveGfxToTargetSystem;
import org.veiset.kgame.engine.ecs.core.system.ai.PatrollingSystem;
import org.veiset.kgame.engine.ecs.core.system.debug.DebugControlSystem;
import org.veiset.kgame.engine.ecs.core.system.debug.EngineSpeedSystem;
import org.veiset.kgame.engine.ecs.core.system.debug.ProfilerSystem;
import org.veiset.kgame.engine.ecs.core.system.graphics.AnimationSystem;
import org.veiset.kgame.engine.ecs.core.system.graphics.BackgroundTilesSystem;
import org.veiset.kgame.engine.ecs.core.system.graphics.DrawSystem;
import org.veiset.kgame.engine.ecs.core.system.graphics.UpdateAnimationStateSystem;
import org.veiset.kgame.engine.ecs.core.system.physics.VelocityPositionSystem;
import org.veiset.kgame.engine.ecs.core.system.ui.DrawUiGfxSystem;
import org.veiset.kgame.engine.ecs.modifier.AddModifierSystem;
import org.veiset.kgame.engine.ecs.modifier.DisplayPlayerModifiersSystem;
import org.veiset.kgame.engine.ecs.sound.system.SoundSystem;
import org.veiset.kgame.engine.input.InputKey;
import org.veiset.kgame.engine.input.InputKeyKt;
import org.veiset.kgame.engine.input.MouseKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.modifier.BaseAttack;
import org.veiset.kgame.engine.state.GameLevelState;
import org.veiset.kgame.engine.util.EntityUtilsKt;
import org.veiset.kgame.engine.world.WorldMap;
import org.veiset.kgame.module.AttackTestModule$closestMonsterEntity$lambda-3$;
import org.veiset.kgame.module.AttackTestModule$closestMonsterPos$;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\bJ\b\u0010\u000f\u001a\u00020\u0001H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/veiset/kgame/module/AttackTestModule;", "Lorg/veiset/kgame/engine/GameModule;", "engine", "Lcom/badlogic/ashley/core/Engine;", "(Lcom/badlogic/ashley/core/Engine;)V", "getEngine", "()Lcom/badlogic/ashley/core/Engine;", "playerStartPos", "Lcom/badlogic/gdx/math/Vector2;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "closestMonsterEntity", "Lcom/badlogic/ashley/core/Entity;", "position", "closestMonsterPos", "nextState", "teardown", "", "update", "delta", "", "kgame2"})
public final class AttackTestModule
extends GameModule {
    @NotNull
    private final Engine engine;
    @NotNull
    private final World world;
    @NotNull
    private final Vector2 playerStartPos;

    public AttackTestModule(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        this.engine = engine;
        this.world = WorldsKt.createWorld$default(null, false, 3, null);
        this.playerStartPos = Vector2Kt.x(6.0f, 6.0f);
        GameLevelState gameState = new GameLevelState(null, null, null, null, 15, null);
        WorldMap worldMap2 = new WorldMap(gameState.getSelectedLevel().getArea(), 3.0f, 0L, 4, null);
        GamePauseSystem gamePauseSystem = new GamePauseSystem();
        this.getEngine().addSystem(new Box2dSystem(this.world));
        this.getEngine().addSystem(new SensorCollisionResolveSystem());
        this.getEngine().addSystem(new CollisionResolveSystem());
        this.getEngine().addSystem(new AttackCollisionResolveSystem(this.world));
        this.getEngine().addSystem(new AreaCollisionResolveSystem(this.world));
        this.getEngine().addSystem(new FixedDurationSystem());
        this.getEngine().addSystem(new BackgroundTilesSystem(worldMap2));
        this.getEngine().addSystem(new DrawSystem(gamePauseSystem));
        this.getEngine().addSystem(new VelocityPositionSystem());
        this.getEngine().addSystem(new UpdateAnimationStateSystem());
        this.getEngine().addSystem(new AnimationSystem());
        this.getEngine().addSystem(new SoundSystem());
        this.getEngine().addSystem(new ProfilerSystem());
        this.getEngine().addSystem(new MoveGfxToTargetSystem());
        this.getEngine().addSystem(new DisplayPlayerModifiersSystem());
        this.getEngine().addSystem(new DrawUiGfxSystem());
        this.getEngine().addSystem(new DebugControlSystem(this.world));
        this.getEngine().addSystem(new PatrollingSystem());
        this.getEngine().addSystem(new GamePauseSystem());
        this.getEngine().addSystem(new ProjectileAttackSystem());
        this.getEngine().addSystem(new EngineSpeedSystem());
        EngineConfig.Debug.INSTANCE.setDISPLAY_PHYSICS_SCALED(true);
        this.getEngine().addEntity(new PlayerEntity(this.world, this.playerStartPos, this.getEngine(), null, 8, null));
        Vector2[] vector2Array = new Vector2[]{Vector2Kt.x(1.0f, 5.0f), Vector2Kt.x(5.0f, 5.0f)};
        this.getEngine().addEntity(new DummyZombie(this.world, Vector2Kt.x(5.0f, 5.0f)).add(new PatrollingAIComponent(CollectionsKt.listOf(vector2Array), 2.0f, false, null, 12, null)));
        vector2Array = new Vector2[]{Vector2Kt.x(7.0f, 3.0f), Vector2Kt.x(1.0f, 3.0f)};
        this.getEngine().addEntity(new DummyZombie(this.world, Vector2Kt.x(2.0f, 3.0f)).add(new PatrollingAIComponent(CollectionsKt.listOf(vector2Array), 1.5f, false, null, 12, null)));
        vector2Array = new Vector2[]{Vector2Kt.x(7.0f, 1.0f), Vector2Kt.x(10.0f, 1.0f), Vector2Kt.x(10.0f, 4.0f), Vector2Kt.x(7.0f, 4.0f)};
        this.getEngine().addEntity(new DummyZombie(this.world, Vector2Kt.x(7.0f, 3.0f)).add(new PatrollingAIComponent(CollectionsKt.listOf(vector2Array), 1.5f, false, null, 12, null)));
    }

    public /* synthetic */ AttackTestModule(Engine engine, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            engine = new Engine();
        }
        this(engine);
    }

    @Override
    @NotNull
    public Engine getEngine() {
        return this.engine;
    }

    @Override
    public void teardown() {
    }

    @Override
    public void update(float delta) {
        this.getEngine().update(delta);
        if (InputKeyKt.clicked(InputKey.ATTACK)) {
            BallAttackEntity it;
            BallAttackEntity ballAttackEntity;
            Vector2 target = MouseKt.scaledPointer();
            BallAttackEntity ballAttackEntity2 = ballAttackEntity = new BallAttackEntity(this.world, this.playerStartPos, target, 5.0f, 3.0f, new BaseAttack(AttackType.Projectile.INSTANCE, 10.0f, 0.3f, 1.0f, 0.05f, CollectionsKt.emptyList()));
            Engine engine = this.getEngine();
            boolean bl = false;
            it.add(new ChainComponent(3));
            it = ballAttackEntity;
            boolean bl2 = false;
            Vector2 vector2 = this.closestMonsterPos(target);
            if (vector2 != null) {
                Vector2 pos = vector2;
                boolean bl3 = false;
                it.add(new HomingComponent(pos, 10.0f, 1.0f));
            }
            engine.addEntity(ballAttackEntity);
        }
        if (Gdx.input.isKeyJustPressed(8)) {
            this.getEngine().addEntity(new BurningGroundEntity(this.world, MouseKt.scaledPointer(), 3.0f));
            Log.INSTANCE.info("Pressed");
        }
        if (Gdx.input.isKeyJustPressed(131)) {
            this.getEngine().addSystem(new AddModifierSystem(null, 1, null));
        }
    }

    @Nullable
    public final Entity closestMonsterEntity(@NotNull Vector2 position) {
        Object v0;
        Intrinsics.checkNotNullParameter(position, "position");
        Class[] classArray = new Class[]{MonsterComponent.class, PositionComponent.class};
        ImmutableArray<Entity> monsters = this.getEngine().getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(monsters, "monsters");
        Iterable $this$minByOrNull$iv = monsters;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                Entity it = (Entity)minElem$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                Entity $this$get$iv = it;
                boolean $i$f$get = false;
                boolean $i$f$addMapperIfNone = false;
                if (!EntityUtilsKt.getMappers().containsKey(PositionComponent.class)) {
                    LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", PositionComponent.class), null, null, 0, closestMonsterEntity$lambda-3$$inlined$get$1.INSTANCE, 14, null);
                }
                ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(PositionComponent.class);
                Intrinsics.checkNotNull(componentMapper);
                Object obj = componentMapper.get($this$get$iv);
                if (obj == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.PositionComponent");
                }
                float minValue$iv = ((PositionComponent)((Component)((PositionComponent)obj))).getPos().dst(position);
                do {
                    Object e$iv = iterator$iv.next();
                    Entity it2 = (Entity)e$iv;
                    $i$a$-minByOrNull-AttackTestModule$closestMonsterEntity$1 = false;
                    Intrinsics.checkNotNullExpressionValue(it2, "it");
                    Entity $this$get$iv2 = it2;
                    boolean $i$f$get2 = false;
                    boolean $i$f$addMapperIfNone2 = false;
                    if (!EntityUtilsKt.getMappers().containsKey(PositionComponent.class)) {
                        LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", PositionComponent.class), null, null, 0, closestMonsterEntity$lambda-3$$inlined$get$1.INSTANCE, 14, null);
                    }
                    ComponentMapper<?> componentMapper2 = EntityUtilsKt.getMappers().get(PositionComponent.class);
                    Intrinsics.checkNotNull(componentMapper2);
                    Object obj2 = componentMapper2.get($this$get$iv2);
                    if (obj2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.PositionComponent");
                    }
                    float v$iv = ((PositionComponent)((Component)((PositionComponent)obj2))).getPos().dst(position);
                    if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    @Nullable
    public final Vector2 closestMonsterPos(@NotNull Vector2 position) {
        Vector2 vector2;
        Intrinsics.checkNotNullParameter(position, "position");
        Entity entity = this.closestMonsterEntity(position);
        if (entity == null) {
            vector2 = null;
        } else {
            Entity $this$get$iv = entity;
            boolean $i$f$get = false;
            boolean $i$f$addMapperIfNone = false;
            if (!EntityUtilsKt.getMappers().containsKey(PositionComponent.class)) {
                LoggerKt.logTimed$default(Intrinsics.stringPlus("Added new mapper for ", PositionComponent.class), null, null, 0, closestMonsterPos$$inlined$get$1.INSTANCE, 14, null);
            }
            ComponentMapper<?> componentMapper = EntityUtilsKt.getMappers().get(PositionComponent.class);
            Intrinsics.checkNotNull(componentMapper);
            Object obj = componentMapper.get($this$get$iv);
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.veiset.kgame.engine.ecs.core.component.PositionComponent");
            }
            PositionComponent positionComponent = (PositionComponent)((Component)((PositionComponent)obj));
            vector2 = positionComponent == null ? null : positionComponent.getPos();
        }
        return vector2;
    }

    @Override
    @NotNull
    public GameModule nextState() {
        if (InputKeyKt.clicked(InputKey.RESET)) {
            return new AttackTestModule(null, 1, null);
        }
        return this;
    }

    public AttackTestModule() {
        this(null, 1, null);
    }
}

