/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.module;

import com.badlogic.ashley.core.Engine;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.utils.ScreenUtils;
import java.time.LocalDate;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.GameModule;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.core.system.graphics.DrawSystem;
import org.veiset.kgame.engine.ecs.core.system.graphics.effect.WeatherSystem;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.state.GameLevelState;
import org.veiset.kgame.engine.ui.MainMenuUI;
import org.veiset.kgame.engine.ui.SettingsUI;
import org.veiset.kgame.engine.ui.component.UILayout;
import org.veiset.kgame.engine.ui.component.UILayoutKt;
import org.veiset.kgame.engine.util.GdxUtilsKt;
import org.veiset.kgame.engine.values.Asset;
import org.veiset.kgame.module.GameWorldModule;
import org.veiset.kgame.module.LevelSelectModule;
import org.veiset.kgame.module.Parallax;
import org.veiset.kgame.module.transition.FadeModuleLoader;
import org.veiset.kgame.presentation.PPresentationKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020\u0001H\u0016J\b\u0010+\u001a\u00020)H\u0016J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020.H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006/"}, d2={"Lorg/veiset/kgame/module/MainMenuModule;", "Lorg/veiset/kgame/engine/GameModule;", "engine", "Lcom/badlogic/ashley/core/Engine;", "(Lcom/badlogic/ashley/core/Engine;)V", "getEngine", "()Lcom/badlogic/ashley/core/Engine;", "fontBig", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "getFontBig", "()Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "fontSmall", "getFontSmall", "mainMenuUI", "Lorg/veiset/kgame/engine/ui/MainMenuUI;", "getMainMenuUI", "()Lorg/veiset/kgame/engine/ui/MainMenuUI;", "music", "Lcom/badlogic/gdx/audio/Music;", "parallax", "Lorg/veiset/kgame/module/Parallax;", "getParallax", "()Lorg/veiset/kgame/module/Parallax;", "sb", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "getSb", "()Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "settingsUI", "Lorg/veiset/kgame/engine/ui/SettingsUI;", "getSettingsUI", "()Lorg/veiset/kgame/engine/ui/SettingsUI;", "sr", "Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "getSr", "()Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "uiLayouts", "", "Lorg/veiset/kgame/engine/ui/component/UILayout;", "getUiLayouts", "()Ljava/util/List;", "handleMenuState", "", "nextState", "teardown", "update", "delta", "", "kgame2"})
public final class MainMenuModule
extends GameModule {
    @NotNull
    private final Engine engine;
    @NotNull
    private final ShapeRenderer sr;
    @NotNull
    private final SpriteBatch sb;
    @NotNull
    private final Music music;
    @NotNull
    private final MainMenuUI mainMenuUI;
    @NotNull
    private final SettingsUI settingsUI;
    @NotNull
    private final List<UILayout> uiLayouts;
    @NotNull
    private final Parallax parallax;
    @NotNull
    private final BitmapFont fontBig;
    @NotNull
    private final BitmapFont fontSmall;

    public MainMenuModule(@NotNull Engine engine) {
        BitmapFont bitmapFont;
        BitmapFont bitmapFont2;
        Music music;
        AssetRef assetRef$iv;
        Object this_$iv;
        Intrinsics.checkNotNullParameter(engine, "engine");
        this.engine = engine;
        this.sr = TBEngineKt.getGlobals().getDrawGfx().getShapeRenderer();
        this.sb = TBEngineKt.getGlobals().getDrawGfx().getSpriteBatch();
        AssetManager assetManager = PPresentationKt.getAm();
        AssetRef assetRef = Asset.Music.INSTANCE.getMenu();
        MainMenuModule mainMenuModule = this;
        boolean $i$f$get = false;
        try {
            Object object = ((AssetManager)this_$iv).getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.audio.Music");
            }
            music = (Music)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        mainMenuModule.music = music;
        this.mainMenuUI = new MainMenuUI(null, false, 3, null);
        this.settingsUI = new SettingsUI(false, false, 3, null);
        this_$iv = new UILayout[]{this.mainMenuUI, this.settingsUI};
        this.uiLayouts = CollectionsKt.listOf(this_$iv);
        this.parallax = new Parallax(0.0f, 1, null);
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.Font.INSTANCE.getJbt80();
        mainMenuModule = this;
        $i$f$get = false;
        try {
            Object object = ((AssetManager)this_$iv).getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont2 = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        mainMenuModule.fontBig = bitmapFont2;
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.Font.INSTANCE.getJbt16();
        mainMenuModule = this;
        $i$f$get = false;
        try {
            Object object = ((AssetManager)this_$iv).getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        mainMenuModule.fontSmall = bitmapFont;
        this.mainMenuUI.open();
        TBEngineKt.getGlobals().getDrawGfx().getCamera().position.x = 1920.0f;
        TBEngineKt.getGlobals().getDrawGfx().getCamera().position.y = 1080.0f;
        TBEngineKt.getGlobals().updateDrawMatrix();
        this.getEngine().addSystem(new DrawSystem(null, 1, null));
        this.getEngine().addSystem(new WeatherSystem());
        this.music.setVolume(GameFilesKt.getGameConfig().getVolumeMusic() * GameFilesKt.getGameConfig().getVolumeMaster());
        this.music.play();
    }

    @Override
    @NotNull
    public Engine getEngine() {
        return this.engine;
    }

    @NotNull
    public final ShapeRenderer getSr() {
        return this.sr;
    }

    @NotNull
    public final SpriteBatch getSb() {
        return this.sb;
    }

    @NotNull
    public final MainMenuUI getMainMenuUI() {
        return this.mainMenuUI;
    }

    @NotNull
    public final SettingsUI getSettingsUI() {
        return this.settingsUI;
    }

    @NotNull
    public final List<UILayout> getUiLayouts() {
        return this.uiLayouts;
    }

    @NotNull
    public final Parallax getParallax() {
        return this.parallax;
    }

    @NotNull
    public final BitmapFont getFontBig() {
        return this.fontBig;
    }

    @NotNull
    public final BitmapFont getFontSmall() {
        return this.fontSmall;
    }

    @Override
    public void teardown() {
        this.music.stop();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(float delta) {
        void blue$iv;
        void green$iv;
        void red$iv;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float alpha$iv = 0.0f;
        boolean clearDepth$iv = true;
        boolean $i$f$clearScreen = false;
        ScreenUtils.clear((float)red$iv, (float)green$iv, (float)blue$iv, alpha$iv, clearDepth$iv);
        this.parallax.update(delta);
        this.parallax.draw();
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(ColorKt.color$default(0.08627451f, 0.1882353f, 0.23529412f, 0.0f, 8, null));
        ShapeRendererKt.rect(this.sr, Vector2Kt.dw(Vector2Kt.x(7.0f, 1.0f)), Vector2Kt.dw(Vector2Kt.x(30.0f, 6.0f)));
        this.sr.end();
        this.getEngine().update(delta);
        this.handleMenuState();
        UILayoutKt.drawActive(this.uiLayouts, delta);
        this.sb.begin();
        this.fontBig.setColor(Color.WHITE);
        GdxUtilsKt.draw(this.fontBig, this.sb, "Bleak Aether", Vector2Kt.dw(Vector2Kt.x(13.7f, 13.1f)));
        this.fontSmall.setColor(Color.LIGHT_GRAY);
        GdxUtilsKt.draw(this.fontSmall, this.sb, Intrinsics.stringPlus("v0.19a-dev ", LocalDate.now()), Vector2Kt.dw(Vector2Kt.x(22.2f, 4.7f)));
        this.sb.end();
    }

    private final void handleMenuState() {
        if (this.mainMenuUI.getState().getStatistics()) {
            UILayoutKt.openOnly(this.uiLayouts, this.settingsUI);
        }
        if (TBEngineKt.getGlobals().getKeyMapper().cancel() || this.settingsUI.getConfirmed()) {
            UILayoutKt.openOnly(this.uiLayouts, this.mainMenuUI);
        }
    }

    @Override
    @NotNull
    public GameModule nextState() {
        if (Gdx.input.isKeyJustPressed(47)) {
            return new FadeModuleLoader(this, 3.0f, null, new LevelSelectModule(new Engine(), new GameLevelState(null, null, null, null, 15, null)), 4, null);
        }
        if (this.mainMenuUI.getState().getNewGame()) {
            return new FadeModuleLoader(this, 3.0f, null, new GameWorldModule(null, null, null, 7, null), 4, null);
        }
        return this;
    }
}

