/*
 * Decompiled with CFR 0.152.
 */
package com.badlogicgames.packr;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

class PackrFileUtils {
    PackrFileUtils() {
    }

    static void chmodX(File path) {
        if (!path.setExecutable(true)) {
            System.err.println("Warning! Failed setting executable flag for: " + path);
        }
    }

    static void copyDirectory(File sourceDirectory, File targetDirectory) throws IOException {
        final Path sourcePath = Paths.get(sourceDirectory.toURI()).toRealPath(new LinkOption[0]);
        final Path targetPath = Paths.get(targetDirectory.toURI());
        Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path relative = sourcePath.relativize(dir);
                Path target = targetPath.resolve(relative);
                Files.createDirectories(target, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (attrs.isSymbolicLink()) {
                    Path linkTargetPath = Files.readSymbolicLink(file);
                    Path linkTargetRelativePath = linkTargetPath.isAbsolute() ? sourcePath.relativize(linkTargetPath) : linkTargetPath;
                    Files.createSymbolicLink(targetPath.resolve(sourcePath.relativize(file)), linkTargetRelativePath, new FileAttribute[0]);
                } else {
                    Path relative = sourcePath.relativize(file);
                    Path target = targetPath.resolve(relative);
                    Files.copy(file, target, StandardCopyOption.COPY_ATTRIBUTES);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static void deleteDirectory(File directory) throws IOException {
        Files.walkFileTree(directory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.deleteIfExists(file);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.deleteIfExists(dir);
                return super.postVisitDirectory(dir, exc);
            }
        });
    }
}

