/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.component.physics;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.Shape;
import com.badlogic.gdx.physics.box2d.World;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ktx.box2d.FixturesKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a8\u0006\f"}, d2={"createDynamicBody", "Lcom/badlogic/gdx/physics/box2d/Body;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "size", "Lcom/badlogic/gdx/math/Vector2;", "position", "filter", "Lcom/badlogic/gdx/physics/box2d/Filter;", "restitution", "", "density", "kgame2"})
public final class DynamicBodyComponentKt {
    @NotNull
    public static final Body createDynamicBody(@NotNull World world, @NotNull Vector2 size, @NotNull Vector2 position, @NotNull Filter filter, float restitution, float density) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Vector2 vector2 = size;
        float xs = Vector2Kt.component1(vector2);
        float ys = Vector2Kt.component2(vector2);
        BodyDef boxBodyDef = new BodyDef();
        Vector2 vector22 = boxBodyDef.position;
        Vector2 vector23 = Vector2Kt.copy(size).scl(0.5f);
        Intrinsics.checkNotNullExpressionValue((Object)vector23, (String)"size.copy().scl(0.5f)");
        vector22.set(Vector2Kt.minus(position, vector23));
        boxBodyDef.type = BodyDef.BodyType.DynamicBody;
        PolygonShape boxShape = new PolygonShape();
        boxShape.setAsBox(xs / (float)2, ys / (float)2);
        FixtureDef boxFixtureDef = new FixtureDef();
        boxFixtureDef.shape = (Shape)boxShape;
        boxFixtureDef.restitution = restitution;
        boxFixtureDef.density = density;
        FixturesKt.filter((FixtureDef)boxFixtureDef, (Filter)filter);
        Body boxBody = world.createBody(boxBodyDef);
        boxBody.setFixedRotation(true);
        boxBody.createFixture(boxFixtureDef);
        boxShape.dispose();
        Intrinsics.checkNotNullExpressionValue((Object)boxBody, (String)"boxBody");
        return boxBody;
    }

    public static /* synthetic */ Body createDynamicBody$default(World world, Vector2 vector2, Vector2 vector22, Filter filter, float f, float f2, int n, Object object) {
        if ((n & 0x20) != 0) {
            f2 = 1.0f;
        }
        return DynamicBodyComponentKt.createDynamicBody(world, vector2, vector22, filter, f, f2);
    }
}

