/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.entity.enemy;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.ai.LinearMoveAIComponent;
import org.veiset.kgame.engine.ecs.component.attack.AttackPlayerComponent;
import org.veiset.kgame.engine.ecs.component.attack.AttackType;
import org.veiset.kgame.engine.ecs.component.attack.AttackTypeComponent;
import org.veiset.kgame.engine.ecs.component.draw.DynamicAnimationComponent;
import org.veiset.kgame.engine.ecs.component.draw.ShadowComponent;
import org.veiset.kgame.engine.ecs.component.draw.TextLabelComponent;
import org.veiset.kgame.engine.ecs.component.enemy.DebrisComponent;
import org.veiset.kgame.engine.ecs.component.enemy.MonsterComponent;
import org.veiset.kgame.engine.ecs.component.loot.LootTableComponent;
import org.veiset.kgame.engine.ecs.component.physics.DynamicBodyComponent;
import org.veiset.kgame.engine.ecs.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.component.scenario.BossScenarioComponent;
import org.veiset.kgame.engine.ecs.component.stats.HealthBarComponent;
import org.veiset.kgame.engine.ecs.component.stats.HealthComponent;
import org.veiset.kgame.engine.input.DynamicAnimation;
import org.veiset.kgame.engine.input.ZombieBehaviour;
import org.veiset.kgame.engine.item.LootTable;
import org.veiset.kgame.engine.item.LootTablesKt;
import org.veiset.kgame.engine.item.SimpleLootSystem;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.storage.AnimationStoreKt;
import org.veiset.kgame.engine.util.TargetType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/veiset/kgame/engine/ecs/entity/enemy/ZombieBossEntity;", "Lcom/badlogic/ashley/core/Entity;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "startPos", "Lcom/badlogic/gdx/math/Vector2;", "(Lcom/badlogic/gdx/physics/box2d/World;Lcom/badlogic/gdx/math/Vector2;)V", "kgame2"})
public final class ZombieBossEntity
extends Entity {
    public ZombieBossEntity(@NotNull World world, @NotNull Vector2 startPos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
        this.add(new MonsterComponent());
        Collection collection = TBEngineKt.getGlobals().getTextureStore().getZombieDebris();
        boolean bl = false;
        this.add(new DebrisComponent((TextureRegion)CollectionsKt.random((Collection)collection, (Random)((Random)Random.Default))));
        this.add(new DynamicBodyComponent(world, this, Vector2Kt.x(0.7f, 1.0f), startPos, null, 0.0f, 48, null));
        this.add(new PositionComponent(startPos));
        this.add(new VelocityComponent(Vector2Kt.x(0.0f, 0.0f)));
        this.add(new HealthComponent(400.0f));
        this.add(new HealthBarComponent(Vector2Kt.x(0.8f, 0.1f), Vector2Kt.x(-0.4f, 0.7f)));
        this.add(new TextLabelComponent("Zombie Boss", Vector2Kt.x(-0.4f, 0.65f), null, null, 0, 28, null));
        this.add(new BossScenarioComponent(new TargetType.XYDistance(Vector2Kt.x(7.0f, 4.0f)), "BLaRrrGghH!!.. ?", 0, this, null, 20, null));
        this.add(new LinearMoveAIComponent(new TargetType.XYDistance(Vector2Kt.x(7.0f, 4.0f)), 2.0f, false, 4, null));
        this.add(new ShadowComponent(0.2f, null, null, 0.0f, false, 30, null));
        this.add(new LootTableComponent(new LootTable(new SimpleLootSystem(10.0f, 10.0f, 10), LootTablesKt.getBigTable())));
        this.add(new AttackPlayerComponent(4.0f, 0.2f));
        this.add(new AttackTypeComponent(new AttackType.PoisonCloud(3.0f)));
        this.add(new DynamicAnimationComponent(new DynamicAnimation(AnimationStoreKt.generateZomieAnimationSet(), new ZombieBehaviour(this)), Vector2Kt.x(1.4f, 1.4f), null, 0, 0.0f, 0.0f, null, 124, null));
    }
}

