/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.entity.gameobjects;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.draw.BackgroundGfxComponent;
import org.veiset.kgame.engine.ecs.component.draw.SpriteGfxComponent;
import org.veiset.kgame.engine.ecs.entity.gameobjects.GrassEntityKt;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/veiset/kgame/engine/ecs/entity/gameobjects/GrassEntity;", "Lcom/badlogic/ashley/core/Entity;", "position", "Lcom/badlogic/gdx/math/Vector2;", "size", "(Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;)V", "getSize", "()Lcom/badlogic/gdx/math/Vector2;", "kgame2"})
public final class GrassEntity
extends Entity {
    @NotNull
    private final Vector2 size;

    public GrassEntity(@NotNull Vector2 position, @NotNull Vector2 size) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        this.size = size;
        float weightedTexture = Vector2Kt.expLerp(Random.Default.nextFloat(), 0.0f, (float)GrassEntityKt.access$getTextureStore$p().getGrassTiles().size() - 1.0f, 5.0f);
        TextureRegion texture = GrassEntityKt.access$getTextureStore$p().getGrassTiles().get(MathKt.roundToInt((float)weightedTexture));
        this.add(new SpriteGfxComponent(texture, this.size, -10, 0.0f, 0.0f, 24, null));
        this.add(new PositionComponent(position));
        this.add(new BackgroundGfxComponent());
    }

    @NotNull
    public final Vector2 getSize() {
        return this.size;
    }
}

