/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IteratingSystem;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.camera.CameraShake;
import org.veiset.kgame.engine.ecs.component.draw.Direction;
import org.veiset.kgame.engine.ecs.component.draw.DynamicAnimationComponent;
import org.veiset.kgame.engine.ecs.component.enemy.DebrisComponent;
import org.veiset.kgame.engine.ecs.component.loot.LootTableComponent;
import org.veiset.kgame.engine.ecs.component.stats.HealthComponent;
import org.veiset.kgame.engine.ecs.entity.DelayAddEntity;
import org.veiset.kgame.engine.ecs.entity.ItemDropEntity;
import org.veiset.kgame.engine.ecs.entity.PlayerEntity;
import org.veiset.kgame.engine.ecs.entity.attack.SelfExplodeAttackEntity;
import org.veiset.kgame.engine.ecs.entity.camera.CameraMoveEntity;
import org.veiset.kgame.engine.ecs.entity.effect.SingleEffectAnimationEntity;
import org.veiset.kgame.engine.ecs.entity.effect.SingleEffectEntity;
import org.veiset.kgame.engine.ecs.entity.enemy.SpeedyDumbZombie;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.ecs.system.MapperNullable;
import org.veiset.kgame.engine.input.Animation;
import org.veiset.kgame.engine.item.Item;
import org.veiset.kgame.engine.item.Loot;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/veiset/kgame/engine/ecs/system/DeathSystem;", "Lcom/badlogic/ashley/systems/IteratingSystem;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "(Lcom/badlogic/gdx/physics/box2d/World;)V", "getWorld", "()Lcom/badlogic/gdx/physics/box2d/World;", "processEntity", "", "entity", "Lcom/badlogic/ashley/core/Entity;", "deltaTime", "", "kgame2"})
public final class DeathSystem
extends IteratingSystem {
    @NotNull
    private final World world;

    public DeathSystem(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Class[] classArray = new Class[]{HealthComponent.class};
        super(Family.all((Class[])classArray).get());
        this.world = world;
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    protected void processEntity(@NotNull Entity entity, float deltaTime) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        HealthComponent health = (HealthComponent)Mapper.INSTANCE.getHealth().get(entity);
        if (entity instanceof PlayerEntity) {
            float f = 0.1f;
            float f2 = health.getCurrentHealth();
            boolean bl = false;
            health.setCurrentHealth(Math.max(f, f2));
        }
        if (health.getCurrentHealth() <= 0.0f) {
            DynamicAnimationComponent animationSet;
            if (entity instanceof SpeedyDumbZombie) {
                Vector2 pos = ((PositionComponent)Mapper.INSTANCE.getPosition().get(entity)).getPos();
                this.getEngine().addEntity((Entity)new SelfExplodeAttackEntity(this.world, Vector2Kt.copy(pos), 1.0f));
                this.getEngine().addEntity((Entity)new CameraMoveEntity(new CameraShake(Vector2Kt.x(0.5f - Random.Default.nextFloat(), 0.5f - Random.Default.nextFloat()), 0.5f, 0.1f)));
            }
            if ((animationSet = (DynamicAnimationComponent)MapperNullable.Gfx.INSTANCE.getDynamicAnimation().get(entity)) != null) {
                Vector2 pos = ((PositionComponent)Mapper.INSTANCE.getPosition().get(entity)).getPos();
                DynamicAnimationComponent animationSet2 = (DynamicAnimationComponent)Mapper.INSTANCE.getDynamicAnimation().get(entity);
                LootTableComponent lootTable = (LootTableComponent)Mapper.INSTANCE.getLootTable().get(entity);
                if (lootTable != null) {
                    List<Loot<Item>> loot = lootTable.getLootTable().generateItems();
                    Iterable $this$forEach$iv = loot;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Loot loot2 = (Loot)element$iv;
                        boolean bl = false;
                        this.getEngine().addEntity((Entity)new ItemDropEntity((Item)loot2.getItem(), Vector2Kt.copy(pos)));
                    }
                }
                Animation deathAnimation = animationSet2.getDynamicAnimation().getAnimationSet().getDeath();
                this.getEngine().addEntity((Entity)new SingleEffectAnimationEntity(deathAnimation.toGdxAnimation(), Vector2Kt.copy(pos), animationSet2.getSize(), animationSet2.getDirection(), 0, 16, null));
                DebrisComponent debris = (DebrisComponent)MapperNullable.INSTANCE.getDebris().get(entity);
                if (debris != null) {
                    float directionOffset = animationSet2.getDirection() == Direction.LEFT ? 0.0f : animationSet2.getSize().x / 4.0f;
                    Vector2 debrisPos = Vector2Kt.plus(Vector2Kt.copy(pos), new Vector2(directionOffset, -animationSet2.getSize().y / 3.0f));
                    Engine engine = this.getEngine();
                    float f = animationSet2.getDynamicAnimation().getAnimationSet().getDeath().getBaseDuration();
                    TextureRegion textureRegion = debris.getTexture();
                    Vector2 vector2 = Vector2Kt.copy(animationSet2.getSize()).scl(0.9f);
                    Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"animationSet.size.copy().scl(0.9f)");
                    engine.addEntity((Entity)new DelayAddEntity(f, new SingleEffectEntity(textureRegion, debrisPos, vector2, -3, Vector2Kt.lerp(Random.Default.nextFloat(), 0.0f, 360.0f), Vector2Kt.lerp(Random.Default.nextFloat(), 0.7f, 1.0f))));
                }
            }
            this.getEngine().removeEntity(entity);
        }
    }
}

