/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.debug;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.camera.CameraEffectComponent;
import org.veiset.kgame.engine.ecs.component.camera.CameraFollowComponent;
import org.veiset.kgame.engine.ecs.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/veiset/kgame/engine/ecs/system/debug/CameraDebugSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "camera", "Lcom/badlogic/gdx/graphics/OrthographicCamera;", "cameraFollowEntities", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "cameraMovements", "playerCharacter", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "debugDraw", "t", "Lcom/badlogic/gdx/math/Vector2;", "cm", "cameraFollow", "Lorg/veiset/kgame/engine/ecs/component/camera/CameraFollowComponent;", "update", "delta", "", "kgame2"})
public final class CameraDebugSystem
extends EntitySystem {
    @NotNull
    private final OrthographicCamera camera = TBEngineKt.getGlobals().getDrawGfx().getCamera();
    private ImmutableArray<Entity> cameraFollowEntities;
    private ImmutableArray<Entity> cameraMovements;
    private ImmutableArray<Entity> playerCharacter;

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{PositionComponent.class, CameraFollowComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(PositionComponent::class.java, CameraFollowComponent::class.java).get())");
        this.cameraFollowEntities = immutableArray;
        classArray = new Class[]{CameraEffectComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(CameraEffectComponent::class.java).get())");
        this.cameraMovements = immutableArray;
        classArray = new Class[]{PlayerCharacterComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(PlayerCharacterComponent::class.java).get())");
        this.playerCharacter = immutableArray;
    }

    public void update(float delta) {
        if (!EngineConfig.Debug.INSTANCE.getDISPLAY_CAMERA_DEBUG()) {
            return;
        }
        ImmutableArray<Entity> immutableArray = this.cameraFollowEntities;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraFollowEntities");
            throw null;
        }
        Entity cameraFollowEntity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)immutableArray));
        if (cameraFollowEntity == null) {
            ImmutableArray<Entity> immutableArray2 = this.playerCharacter;
            if (immutableArray2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"playerCharacter");
                throw null;
            }
            Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)immutableArray2));
            ImmutableArray<Entity> immutableArray3 = immutableArray = entity == null ? null : entity.add((Component)new CameraFollowComponent(0.0f, 0.0f, 0.0f, 0.0f, 15, null));
            if (immutableArray == null) {
                return;
            }
            return;
        }
        Vector2 targetPos = ((PositionComponent)Mapper.INSTANCE.getPosition().get(cameraFollowEntity)).getPos();
        CameraFollowComponent cameraFollow = (CameraFollowComponent)Mapper.INSTANCE.getCameraFollow().get(cameraFollowEntity);
        Vector3 vector3 = this.camera.position;
        Intrinsics.checkNotNullExpressionValue((Object)vector3, (String)"camera.position");
        Vector2 cameraPos = Vector2Kt.gfxToWorld(Vector2Kt.v2(vector3));
        Intrinsics.checkNotNullExpressionValue((Object)cameraFollow, (String)"cameraFollow");
        this.debugDraw(targetPos, cameraPos, cameraFollow);
    }

    public final void debugDraw(@NotNull Vector2 t, @NotNull Vector2 cm, @NotNull CameraFollowComponent cameraFollow) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)cm, (String)"cm");
        Intrinsics.checkNotNullParameter((Object)cameraFollow, (String)"cameraFollow");
        ShapeRenderer sr = TBEngineKt.getGlobals().getDrawGfx().getShapeRenderer();
        sr.begin(ShapeRenderer.ShapeType.Line);
        sr.setColor(Color.RED);
        sr.line(Vector2Kt.dw(cm), Vector2Kt.dw(t));
        sr.setColor(Color.WHITE);
        ShapeRendererKt.circle((ShapeRenderer)sr, (Vector2)Vector2Kt.dw(cm), (float)(cameraFollow.getNoFollow() * 120.0f));
        sr.setColor(Color.ORANGE);
        ShapeRendererKt.circle((ShapeRenderer)sr, (Vector2)Vector2Kt.dw(cm), (float)(cameraFollow.getSoftMaxDistance() * 120.0f));
        sr.setColor(Color.RED);
        ShapeRendererKt.circle((ShapeRenderer)sr, (Vector2)Vector2Kt.dw(cm), (float)(cameraFollow.getMaxDistance() * 120.0f));
        sr.setColor(Color.BLUE);
        sr.line(Vector2Kt.dw(cm), Vector2Kt.dw(t));
        Vector2 vector2 = Vector2Kt.minus(t, cm).nor().scl(cameraFollow.getMaxDistance());
        Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"t - cm).nor().scl(cameraFollow.maxDistance)");
        Vector2 maxTarget = Vector2Kt.dw(Vector2Kt.plus(cm, vector2));
        ShapeRendererKt.circle((ShapeRenderer)sr, (Vector2)maxTarget, (float)5.0f);
        sr.end();
    }
}

