/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.enemy;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.ecs.component.levelselect.GameLevelComponent;
import org.veiset.kgame.engine.ecs.entity.enemy.BigBadBossEntity;
import org.veiset.kgame.engine.ecs.entity.enemy.DumbZombieEntity;
import org.veiset.kgame.engine.ecs.entity.enemy.SpeedyDumbZombie;
import org.veiset.kgame.engine.ecs.entity.enemy.ZombieBossEntity;
import org.veiset.kgame.engine.ecs.entity.enemy.ZombieEntity;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.state.LevelMonsters;
import org.veiset.kgame.engine.world.WorldMapBounds;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/veiset/kgame/engine/ecs/system/enemy/EnemySpawnSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "selectedLevel", "Lorg/veiset/kgame/engine/ecs/component/levelselect/GameLevelComponent;", "bounds", "Lorg/veiset/kgame/engine/world/WorldMapBounds;", "(Lcom/badlogic/gdx/physics/box2d/World;Lorg/veiset/kgame/engine/ecs/component/levelselect/GameLevelComponent;Lorg/veiset/kgame/engine/world/WorldMapBounds;)V", "getBounds", "()Lorg/veiset/kgame/engine/world/WorldMapBounds;", "getSelectedLevel", "()Lorg/veiset/kgame/engine/ecs/component/levelselect/GameLevelComponent;", "getWorld", "()Lcom/badlogic/gdx/physics/box2d/World;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "kgame2"})
public final class EnemySpawnSystem
extends EntitySystem {
    @NotNull
    private final World world;
    @NotNull
    private final GameLevelComponent selectedLevel;
    @NotNull
    private final WorldMapBounds bounds;

    public EnemySpawnSystem(@NotNull World world, @NotNull GameLevelComponent selectedLevel, @NotNull WorldMapBounds bounds) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)selectedLevel, (String)"selectedLevel");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.world = world;
        this.selectedLevel = selectedLevel;
        this.bounds = bounds;
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    @NotNull
    public final GameLevelComponent getSelectedLevel() {
        return this.selectedLevel;
    }

    @NotNull
    public final WorldMapBounds getBounds() {
        return this.bounds;
    }

    public void addedToEngine(@NotNull Engine engine) {
        int it;
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        LevelMonsters monsters = this.selectedLevel.getMonsters();
        Vector2 startPos = Vector2Kt.plus(EngineConfig.Game.INSTANCE.getPlayerStartPos(), Vector2Kt.x(16.7f, 9.0f));
        Vector2 worldSize = Vector2Kt.x(this.bounds.getMapX(), this.bounds.getMapY());
        Log.INSTANCE.info("Spawning monsters");
        Log.INSTANCE.info("Spawning " + monsters.getMonsters() + " regular monsters");
        int n = monsters.getMonsters();
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            it = n2;
            boolean bl2 = false;
            Vector2 spawnPosition = Vector2Kt.copy(worldSize).scl(Random.Default.nextFloat(), Random.Default.nextFloat());
            IntRange intRange = new IntRange(0, 2);
            boolean bl3 = false;
            int n4 = RangesKt.random((IntRange)intRange, (Random)((Random)Random.Default));
            if (n4 == 0) {
                World world = this.getWorld();
                Intrinsics.checkNotNullExpressionValue((Object)spawnPosition, (String)"spawnPosition");
                engine.addEntity((Entity)new ZombieEntity(world, spawnPosition));
                continue;
            }
            if (n4 == 1) {
                World world = this.getWorld();
                Intrinsics.checkNotNullExpressionValue((Object)spawnPosition, (String)"spawnPosition");
                engine.addEntity((Entity)new DumbZombieEntity(world, spawnPosition));
                continue;
            }
            boolean bl4 = 2 <= n4 ? n4 <= 3 : false;
            if (!bl4) continue;
            World world = this.getWorld();
            Intrinsics.checkNotNullExpressionValue((Object)spawnPosition, (String)"spawnPosition");
            engine.addEntity((Entity)new SpeedyDumbZombie(world, spawnPosition));
        }
        Log.INSTANCE.info("Spawning " + monsters.getMiniBosses() + " mini bosses");
        n = monsters.getMiniBosses();
        bl = false;
        n2 = 0;
        n2 = 0;
        n3 = n;
        while (n2 < n3) {
            it = n2++;
            boolean bl5 = false;
            engine.addEntity((Entity)new ZombieBossEntity(this.getWorld(), Vector2Kt.plus(EngineConfig.Game.INSTANCE.getPlayerStartPos(), Vector2Kt.x(15.0f, 7.0f))));
        }
        Log.INSTANCE.info("Spawning " + monsters.getMiniBosses() + " bosses");
        n = monsters.getBosses();
        bl = false;
        n2 = 0;
        n2 = 0;
        n3 = n;
        while (n2 < n3) {
            it = n2++;
            boolean bl6 = false;
            engine.addEntity((Entity)new BigBadBossEntity(this.getWorld(), Vector2Kt.x(10.0f, 10.0f)));
        }
    }

    public void update(float deltaTime) {
    }
}

