/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.graphics;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.ecs.system.graphics.DrawInstruction;
import org.veiset.kgame.engine.ecs.system.graphics.DrawSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\tH\u00c6\u0003JO\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\tH\u00c6\u0001J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0016J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020\u0005H\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011\u00a8\u0006+"}, d2={"Lorg/veiset/kgame/engine/ecs/system/graphics/DrawTextureShadow;", "Lorg/veiset/kgame/engine/ecs/system/graphics/DrawInstruction;", "y", "", "layer", "", "texture", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "position", "Lcom/badlogic/gdx/math/Vector2;", "size", "opacity", "warp", "(FILcom/badlogic/gdx/graphics/g2d/TextureRegion;Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;FLcom/badlogic/gdx/math/Vector2;)V", "getLayer", "()I", "getOpacity", "()F", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "getSize", "getTexture", "()Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "getWarp", "getY", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "draw", "", "delta", "equals", "", "other", "", "hashCode", "toString", "", "kgame2"})
public final class DrawTextureShadow
implements DrawInstruction {
    private final float y;
    private final int layer;
    @NotNull
    private final TextureRegion texture;
    @NotNull
    private final Vector2 position;
    @NotNull
    private final Vector2 size;
    private final float opacity;
    @NotNull
    private final Vector2 warp;

    public DrawTextureShadow(float y, int layer, @NotNull TextureRegion texture, @NotNull Vector2 position, @NotNull Vector2 size, float opacity, @NotNull Vector2 warp) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)warp, (String)"warp");
        this.y = y;
        this.layer = layer;
        this.texture = texture;
        this.position = position;
        this.size = size;
        this.opacity = opacity;
        this.warp = warp;
    }

    public /* synthetic */ DrawTextureShadow(float f, int n, TextureRegion textureRegion, Vector2 vector2, Vector2 vector22, float f2, Vector2 vector23, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            vector23 = Vector2Kt.x(1.0f, 1.0f);
        }
        this(f, n, textureRegion, vector2, vector22, f2, vector23);
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public int getLayer() {
        return this.layer;
    }

    @NotNull
    public final TextureRegion getTexture() {
        return this.texture;
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    @NotNull
    public final Vector2 getSize() {
        return this.size;
    }

    public final float getOpacity() {
        return this.opacity;
    }

    @NotNull
    public final Vector2 getWarp() {
        return this.warp;
    }

    @Override
    public void draw(float delta) {
        Color c = DrawSystemKt.access$getSpriteBatch$p().getColor();
        float r = c.r;
        float g = c.g;
        float b = c.b;
        Vector2 vector2 = this.position;
        float x = Vector2Kt.component1(vector2);
        float y = Vector2Kt.component2(vector2);
        Vector2 vector22 = this.size;
        float sx = Vector2Kt.component1(vector22);
        float sy = Vector2Kt.component2(vector22);
        Vector2 vector23 = this.warp;
        float warpx = Vector2Kt.component1(vector23);
        float warpy = Vector2Kt.component2(vector23);
        TextureRegion gfx = this.texture;
        DrawSystemKt.access$getSpriteBatch$p().setColor(0.0f, 0.0f, 0.0f, this.opacity);
        DrawSystemKt.access$getSpriteBatch$p().draw(gfx, (x - sx / 2.0f) * 120.0f, (y - sy / 2.0f) * 120.0f, sx / 2.0f * 120.0f, 0.0f, sx * 120.0f * warpx, sy * 120.0f * warpy, 1.0f, 1.0f, 0.0f);
        DrawSystemKt.access$getSpriteBatch$p().setColor(r, g, b, 1.0f);
    }

    public final float component1() {
        return this.getY();
    }

    public final int component2() {
        return this.getLayer();
    }

    @NotNull
    public final TextureRegion component3() {
        return this.texture;
    }

    @NotNull
    public final Vector2 component4() {
        return this.position;
    }

    @NotNull
    public final Vector2 component5() {
        return this.size;
    }

    public final float component6() {
        return this.opacity;
    }

    @NotNull
    public final Vector2 component7() {
        return this.warp;
    }

    @NotNull
    public final DrawTextureShadow copy(float y, int layer, @NotNull TextureRegion texture, @NotNull Vector2 position, @NotNull Vector2 size, float opacity, @NotNull Vector2 warp) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)warp, (String)"warp");
        return new DrawTextureShadow(y, layer, texture, position, size, opacity, warp);
    }

    public static /* synthetic */ DrawTextureShadow copy$default(DrawTextureShadow drawTextureShadow, float f, int n, TextureRegion textureRegion, Vector2 vector2, Vector2 vector22, float f2, Vector2 vector23, int n2, Object object) {
        if ((n2 & 1) != 0) {
            f = drawTextureShadow.getY();
        }
        if ((n2 & 2) != 0) {
            n = drawTextureShadow.getLayer();
        }
        if ((n2 & 4) != 0) {
            textureRegion = drawTextureShadow.texture;
        }
        if ((n2 & 8) != 0) {
            vector2 = drawTextureShadow.position;
        }
        if ((n2 & 0x10) != 0) {
            vector22 = drawTextureShadow.size;
        }
        if ((n2 & 0x20) != 0) {
            f2 = drawTextureShadow.opacity;
        }
        if ((n2 & 0x40) != 0) {
            vector23 = drawTextureShadow.warp;
        }
        return drawTextureShadow.copy(f, n, textureRegion, vector2, vector22, f2, vector23);
    }

    @NotNull
    public String toString() {
        return "DrawTextureShadow(y=" + this.getY() + ", layer=" + this.getLayer() + ", texture=" + this.texture + ", position=" + this.position + ", size=" + this.size + ", opacity=" + this.opacity + ", warp=" + this.warp + ')';
    }

    public int hashCode() {
        int result = Float.hashCode(this.getY());
        result = result * 31 + Integer.hashCode(this.getLayer());
        result = result * 31 + this.texture.hashCode();
        result = result * 31 + this.position.hashCode();
        result = result * 31 + this.size.hashCode();
        result = result * 31 + Float.hashCode(this.opacity);
        result = result * 31 + this.warp.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DrawTextureShadow)) {
            return false;
        }
        DrawTextureShadow drawTextureShadow = (DrawTextureShadow)other;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.getY()), (Object)Float.valueOf(drawTextureShadow.getY()))) {
            return false;
        }
        if (this.getLayer() != drawTextureShadow.getLayer()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.texture, (Object)drawTextureShadow.texture)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.position, (Object)drawTextureShadow.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.size, (Object)drawTextureShadow.size)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.opacity), (Object)Float.valueOf(drawTextureShadow.opacity))) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.warp, (Object)drawTextureShadow.warp);
    }
}

