/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.graphics;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.ecs.component.draw.Direction;
import org.veiset.kgame.engine.ecs.component.draw.DynamicAnimationComponent;
import org.veiset.kgame.engine.ecs.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.entity.PlayerEntity;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.input.AnimationSpeedModifier;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/veiset/kgame/engine/ecs/system/graphics/UpdateAnimationStateSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "()V", "entities", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "kgame2"})
public final class UpdateAnimationStateSystem
extends EntitySystem {
    private ImmutableArray<Entity> entities;

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{DynamicAnimationComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.all((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.all(DynamicAnimationComponent::class.java).get())");
        this.entities = immutableArray;
    }

    public void update(float deltaTime) {
        ImmutableArray<Entity> immutableArray = this.entities;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"entities");
            throw null;
        }
        Iterable $this$forEach$iv = (Iterable)immutableArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            if (it instanceof PlayerEntity) continue;
            DynamicAnimationComponent dynamicAnimationC = (DynamicAnimationComponent)Mapper.INSTANCE.getDynamicAnimation().get(it);
            VelocityComponent velocity = (VelocityComponent)Mapper.INSTANCE.getVelocity().get(it);
            float f = velocity.getSpeed().x;
            boolean bl2 = false;
            float f2 = Math.abs(f);
            f = velocity.getSpeed().y;
            bl2 = false;
            float moveSpeed = (f2 + Math.abs(f)) / 2.0f;
            dynamicAnimationC.getDynamicAnimation().update(deltaTime, new AnimationSpeedModifier(0.0f, 0.0f, 1.0f + moveSpeed, 0.0f, 0.0f, 0.0f, 59, null));
            if (velocity.getSpeed().x == 0.0f) continue;
            dynamicAnimationC.setDirection(velocity.getSpeed().x > 0.0f ? Direction.RIGHT : Direction.LEFT);
        }
    }
}

