/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.player;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.system.player.ColoredMods;
import org.veiset.kgame.engine.item.Equipment;
import org.veiset.kgame.engine.item.ItemKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.modifier.Modifier;
import org.veiset.kgame.engine.storage.TextureStore;
import org.veiset.kgame.engine.util.FontUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a6\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a$\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010\u001a$\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a&\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"font32", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "shapeRenderer", "Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "spriteBatch", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "textureStore", "Lorg/veiset/kgame/engine/storage/TextureStore;", "displayEquipmentInfo", "", "equipped", "Lorg/veiset/kgame/engine/item/Equipment;", "mods", "", "Lorg/veiset/kgame/engine/ecs/system/player/ColoredMods;", "position", "Lcom/badlogic/gdx/math/Vector2;", "drawEquipment", "drawEquipmentUI", "drawInventoryItem", "drawTriangle", "scale", "", "spacing", "yoffset", "index", "", "kgame2"})
public final class InventorySystemKt {
    @NotNull
    private static final TextureStore textureStore = TBEngineKt.getGlobals().getTextureStore();
    @NotNull
    private static final ShapeRenderer shapeRenderer = TBEngineKt.getGlobals().getDrawUi().getShapeRenderer();
    @NotNull
    private static final SpriteBatch spriteBatch = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
    @NotNull
    private static final BitmapFont font32 = TBEngineKt.getGlobals().getFonts().getFont32();

    public static final void drawTriangle(float scale, float spacing2, float yoffset, int index) {
        float gameWidth = 16.0f;
        Vector2 vector2 = InventorySystemKt.drawTriangle$trianglePos(gameWidth, scale, spacing2, index);
        float x = Vector2Kt.component1(vector2);
        float y = Vector2Kt.component2(vector2);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        shapeRenderer.setColor(ColorKt.color((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7f));
        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        shapeRenderer.triangle((x + scale / 2.0f - scale / 4.0f) * 120.0f, (y + yoffset) * 120.0f, (x + scale / 2.0f + scale / 4.0f) * 120.0f, (y + yoffset) * 120.0f, (x + scale / 2.0f) * 120.0f, (y - spacing2) * 120.0f);
        shapeRenderer.end();
        Gdx.gl.glDisable(3042);
    }

    /*
     * WARNING - void declaration
     */
    private static final void drawInventoryItem(Equipment equipped) {
        String it;
        Iterable $this$mapTo$iv$iv;
        Object object;
        Object object2;
        Collection collection;
        Object item$iv$iv22;
        void $this$mapTo$iv$iv2;
        float spacing2 = 0.05f;
        float yoffset = 0.15f;
        float padding = 0.2f;
        float gameWidth = 16.0f;
        List<Modifier> mods = equipped.getMods();
        Iterable $this$map$iv = mods;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv22 : $this$mapTo$iv$iv2) {
            void it2;
            Modifier modifier = (Modifier)item$iv$iv22;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it2.getDescription();
            object2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"WHITE");
            object = new ColoredMods(string, (Color)object2, Float.valueOf(0.0f));
            collection.add(object);
        }
        List coloredMods = (List)destination$iv$iv;
        BitmapFont font = TBEngineKt.getGlobals().getFonts().getFont24();
        BitmapFont modFont = TBEngineKt.getGlobals().getFonts().getFont24();
        Equipment.DrawTextInfo textSizes = equipped.textSizes(font, modFont);
        float nameSizeY = textSizes.getNameSize().y;
        float nameSizeX = textSizes.getNameSize().x;
        Iterable $this$map$iv2 = mods;
        boolean $i$f$map2 = false;
        object2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Modifier modifier = (Modifier)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = ((Modifier)((Object)it)).getDescription();
            collection.add(object);
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = Float.valueOf(FontUtilsKt.sizeX(font, it));
            collection.add(object);
        }
        item$iv$iv22 = CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
        float item$iv$iv22 = item$iv$iv22 == null ? 0.0f : ((Float)item$iv$iv22).floatValue();
        float $this$map$iv22 = nameSizeY * 2.0f + nameSizeX;
        boolean bl = false;
        float longestText = Math.max(item$iv$iv22, $this$map$iv22);
        float startWidth = gameWidth - (longestText + spacing2) - padding * 2.0f;
        float startHeight = 0.65f + spacing2 * (float)2 + yoffset;
        InventorySystemKt.drawEquipmentUI(equipped, coloredMods, Vector2Kt.x(startWidth, startHeight));
    }

    public static final void drawEquipmentUI(@NotNull Equipment equipped, @NotNull List<ColoredMods> mods, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter((Object)equipped, (String)"equipped");
        Intrinsics.checkNotNullParameter(mods, (String)"mods");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        InventorySystemKt.displayEquipmentInfo(equipped, mods, position, TBEngineKt.getGlobals().getDrawUi().getSpriteBatch(), TBEngineKt.getGlobals().getDrawUi().getShapeRenderer());
    }

    public static final void drawEquipment(@NotNull Equipment equipped, @NotNull List<ColoredMods> mods, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter((Object)equipped, (String)"equipped");
        Intrinsics.checkNotNullParameter(mods, (String)"mods");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        InventorySystemKt.displayEquipmentInfo(equipped, mods, position, TBEngineKt.getGlobals().getDrawGfx().getSpriteBatch(), TBEngineKt.getGlobals().getDrawGfx().getShapeRenderer());
    }

    /*
     * WARNING - void declaration
     */
    private static final void displayEquipmentInfo(Equipment equipped, List<ColoredMods> mods, Vector2 position, SpriteBatch spriteBatch, ShapeRenderer shapeRenderer) {
        String it;
        Iterable $this$mapTo$iv$iv;
        Iterable it2;
        Collection<String> collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        float padding = 0.2f;
        float modPadding = 0.15f;
        Vector2 vector2 = position;
        float startWidth = Vector2Kt.component1(vector2);
        float startHeight = Vector2Kt.component2(vector2);
        BitmapFont font = TBEngineKt.getGlobals().getFonts().getFont24();
        BitmapFont modFont = TBEngineKt.getGlobals().getFonts().getFont24();
        Iterable iterable = mods;
        String string = equipped.getName();
        Object object = modFont;
        Object object2 = font;
        boolean $i$f$map = false;
        void var15_19 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo322 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            ColoredMods coloredMods = (ColoredMods)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = ((ColoredMods)((Object)it2)).getDescription();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        Equipment.DrawTextInfo textSizes = ItemKt.textSizeInfo((BitmapFont)object2, object, string, (List<String>)collection);
        float modSizeY = mods.isEmpty() ? 0.0f : (textSizes.getMaxModSize().y + modPadding) * (float)mods.size() + modPadding * 0.3f;
        float nameSizeY = textSizes.getNameSize().y;
        float nameSizeX = textSizes.getNameSize().x;
        Iterable $this$map$iv2 = mods;
        boolean $i$f$map2 = false;
        it2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ColoredMods coloredMods = (ColoredMods)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            object = ((ColoredMods)((Object)it)).getDescription();
            object2.add(object);
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            object = Float.valueOf(FontUtilsKt.sizeX(font, it));
            object2.add(object);
        }
        Float $i$f$mapTo322 = CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
        float $i$f$mapTo322 = $i$f$mapTo322 == null ? 0.0f : $i$f$mapTo322.floatValue();
        float $this$map$iv22 = nameSizeY * 2.0f + nameSizeX;
        $i$f$map2 = false;
        float longestText = Math.max($i$f$mapTo322, $this$map$iv22);
        float height = modSizeY + nameSizeY + padding * 2.0f;
        float yStartPos = startHeight + height - padding;
        float xStartPos = startWidth + padding;
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        shapeRenderer.setColor(ColorKt.color((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7f));
        ShapeRendererKt.rect((ShapeRenderer)shapeRenderer, (Vector2)Vector2Kt.dw(Vector2Kt.x(startWidth, startHeight)), (Vector2)Vector2Kt.x((longestText + padding * 2.0f) * 120.0f, height * 120.0f));
        shapeRenderer.end();
        shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        shapeRenderer.setColor(ColorKt.color((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        ShapeRendererKt.rect((ShapeRenderer)shapeRenderer, (Vector2)Vector2Kt.dw(Vector2Kt.x(startWidth, startHeight)), (Vector2)Vector2Kt.x((longestText + padding * 2.0f) * 120.0f, height * 120.0f));
        shapeRenderer.end();
        Gdx.gl.glDisable(3042);
        spriteBatch.begin();
        font.setColor(Color.GOLD);
        font.draw((Batch)spriteBatch, (CharSequence)equipped.getName(), xStartPos * 120.0f, yStartPos * 120.0f);
        spriteBatch.draw(equipped.getGfx(), (xStartPos + nameSizeX + nameSizeY - padding / 2.0f) * 120.0f, (yStartPos - nameSizeY - padding / 2.0f) * 120.0f, (nameSizeY + padding) * 120.0f, (nameSizeY + padding) * 120.0f);
        Iterable $this$forEachIndexed$iv = mods;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void mod;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ColoredMods coloredMods = (ColoredMods)item$iv;
            int i = n;
            boolean bl2 = false;
            font.setColor(mod.getColor());
            font.draw((Batch)spriteBatch, (CharSequence)mod.getDescription(), xStartPos * 120.0f, (yStartPos - modPadding * 1.3f - nameSizeY - (float)i * (textSizes.getMaxModSize().y + modPadding)) * 120.0f);
        }
        spriteBatch.end();
    }

    private static final Vector2 drawTriangle$trianglePos(float gameWidth, float $scale, float $spacing, int index) {
        float x = gameWidth - $scale * (float)index - $spacing * (float)index;
        return new Vector2(x, $spacing * (float)2 + $scale);
    }

    public static final /* synthetic */ ShapeRenderer access$getShapeRenderer$p() {
        return shapeRenderer;
    }

    public static final /* synthetic */ SpriteBatch access$getSpriteBatch$p() {
        return spriteBatch;
    }

    public static final /* synthetic */ void access$drawInventoryItem(Equipment equipped) {
        InventorySystemKt.drawInventoryItem(equipped);
    }
}

