/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.system.player;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.draw.Direction;
import org.veiset.kgame.engine.ecs.component.draw.DynamicAnimationComponent;
import org.veiset.kgame.engine.ecs.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.component.player.InventoryComponent;
import org.veiset.kgame.engine.ecs.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.input.AnimationSpeedModifier;
import org.veiset.kgame.engine.input.DynamicAnimation;
import org.veiset.kgame.engine.input.MouseKt;
import org.veiset.kgame.engine.modifier.ModifierEngine;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/veiset/kgame/engine/ecs/system/player/PlayerInputSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "(Lcom/badlogic/gdx/physics/box2d/World;)V", "inventories", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "players", "target", "Lcom/badlogic/gdx/math/Vector2;", "getTarget", "()Lcom/badlogic/gdx/math/Vector2;", "setTarget", "(Lcom/badlogic/gdx/math/Vector2;)V", "targetPosition", "getTargetPosition", "setTargetPosition", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "delta", "", "kgame2"})
public final class PlayerInputSystem
extends EntitySystem {
    @NotNull
    private final World world;
    @NotNull
    private Vector2 targetPosition;
    @Nullable
    private Vector2 target;
    private ImmutableArray<Entity> players;
    private ImmutableArray<Entity> inventories;

    public PlayerInputSystem(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world = world;
        this.targetPosition = new Vector2(0.0f, 0.0f);
    }

    @NotNull
    public final Vector2 getTargetPosition() {
        return this.targetPosition;
    }

    public final void setTargetPosition(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter((Object)vector2, (String)"<set-?>");
        this.targetPosition = vector2;
    }

    @Nullable
    public final Vector2 getTarget() {
        return this.target;
    }

    public final void setTarget(@Nullable Vector2 vector2) {
        this.target = vector2;
    }

    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Class[] classArray = new Class[]{PlayerCharacterComponent.class};
        ImmutableArray immutableArray = engine.getEntitiesFor(Family.one((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.one(PlayerCharacterComponent::class.java).get())");
        this.players = immutableArray;
        classArray = new Class[]{InventoryComponent.class};
        immutableArray = engine.getEntitiesFor(Family.one((Class[])classArray).get());
        Intrinsics.checkNotNullExpressionValue((Object)immutableArray, (String)"engine.getEntitiesFor(Family.one(InventoryComponent::class.java).get())");
        this.inventories = immutableArray;
    }

    public void update(float delta) {
        Entity entity = this.players;
        if (entity == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"players");
            throw null;
        }
        Entity entity2 = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)entity));
        if (entity2 == null) {
            return;
        }
        Entity player = entity2;
        Object object = this.inventories;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inventories");
            throw null;
        }
        entity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)object));
        if (entity == null) {
            return;
        }
        Entity inventoryEntity = entity;
        object = (InventoryComponent)Mapper.INSTANCE.getInventory().get(inventoryEntity);
        if (object == null) {
            return;
        }
        Object inventory = object;
        DynamicAnimationComponent animation = (DynamicAnimationComponent)Mapper.INSTANCE.getDynamicAnimation().get(player);
        DynamicAnimation playerState = animation.getDynamicAnimation();
        playerState.update(delta, new AnimationSpeedModifier(0.0f, 1.0f + ModifierEngine.Attack.INSTANCE.attackSpeed(((InventoryComponent)inventory).getWeapon().getMods()), ModifierEngine.INSTANCE.speed(((InventoryComponent)inventory).getBoots().getMods(), 2.0f), 0.0f, 0.0f, 0.0f, 57, null));
        Vector2 position = ((PositionComponent)Mapper.INSTANCE.getPosition().get(player)).getPos();
        VelocityComponent velocity = (VelocityComponent)Mapper.INSTANCE.getVelocity().get(player);
        if (Gdx.input.isButtonPressed(1)) {
            Vector2 sp = MouseKt.scaledPointer();
            animation.setDirection(sp.x > position.x ? Direction.RIGHT : Direction.LEFT);
        }
        if (!(velocity.getSpeed().x == 0.0f)) {
            animation.setDirection(velocity.getSpeed().x > 0.0f ? Direction.RIGHT : Direction.LEFT);
        }
    }
}

