/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.input;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.input.ActionType;
import org.veiset.kgame.engine.input.Animation;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\""}, d2={"Lorg/veiset/kgame/engine/input/AnimationSet;", "", "idle", "Lorg/veiset/kgame/engine/input/Animation;", "moving", "attack", "dodge", "stagger", "death", "(Lorg/veiset/kgame/engine/input/Animation;Lorg/veiset/kgame/engine/input/Animation;Lorg/veiset/kgame/engine/input/Animation;Lorg/veiset/kgame/engine/input/Animation;Lorg/veiset/kgame/engine/input/Animation;Lorg/veiset/kgame/engine/input/Animation;)V", "getAttack", "()Lorg/veiset/kgame/engine/input/Animation;", "getDeath", "getDodge", "getIdle", "getMoving", "getStagger", "animationForAction", "actionType", "Lorg/veiset/kgame/engine/input/ActionType;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kgame2"})
public final class AnimationSet {
    @NotNull
    private final Animation idle;
    @NotNull
    private final Animation moving;
    @NotNull
    private final Animation attack;
    @NotNull
    private final Animation dodge;
    @NotNull
    private final Animation stagger;
    @NotNull
    private final Animation death;

    public AnimationSet(@NotNull Animation idle, @NotNull Animation moving, @NotNull Animation attack, @NotNull Animation dodge, @NotNull Animation stagger, @NotNull Animation death) {
        Intrinsics.checkNotNullParameter((Object)idle, (String)"idle");
        Intrinsics.checkNotNullParameter((Object)moving, (String)"moving");
        Intrinsics.checkNotNullParameter((Object)attack, (String)"attack");
        Intrinsics.checkNotNullParameter((Object)dodge, (String)"dodge");
        Intrinsics.checkNotNullParameter((Object)stagger, (String)"stagger");
        Intrinsics.checkNotNullParameter((Object)death, (String)"death");
        this.idle = idle;
        this.moving = moving;
        this.attack = attack;
        this.dodge = dodge;
        this.stagger = stagger;
        this.death = death;
    }

    @NotNull
    public final Animation getIdle() {
        return this.idle;
    }

    @NotNull
    public final Animation getMoving() {
        return this.moving;
    }

    @NotNull
    public final Animation getAttack() {
        return this.attack;
    }

    @NotNull
    public final Animation getDodge() {
        return this.dodge;
    }

    @NotNull
    public final Animation getStagger() {
        return this.stagger;
    }

    @NotNull
    public final Animation getDeath() {
        return this.death;
    }

    @NotNull
    public final Animation animationForAction(@NotNull ActionType actionType) {
        Animation animation;
        Intrinsics.checkNotNullParameter((Object)actionType, (String)"actionType");
        ActionType actionType2 = actionType;
        if (Intrinsics.areEqual((Object)actionType2, (Object)ActionType.Idle.INSTANCE)) {
            animation = this.idle;
        } else if (Intrinsics.areEqual((Object)actionType2, (Object)ActionType.Stagger.INSTANCE)) {
            animation = this.stagger;
        } else if (Intrinsics.areEqual((Object)actionType2, (Object)ActionType.Death.INSTANCE)) {
            animation = this.death;
        } else if (actionType2 instanceof ActionType.Moving) {
            animation = this.moving;
        } else if (actionType2 instanceof ActionType.Dodge) {
            animation = this.dodge;
        } else if (actionType2 instanceof ActionType.Attack) {
            animation = this.attack;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return animation;
    }

    @NotNull
    public final Animation component1() {
        return this.idle;
    }

    @NotNull
    public final Animation component2() {
        return this.moving;
    }

    @NotNull
    public final Animation component3() {
        return this.attack;
    }

    @NotNull
    public final Animation component4() {
        return this.dodge;
    }

    @NotNull
    public final Animation component5() {
        return this.stagger;
    }

    @NotNull
    public final Animation component6() {
        return this.death;
    }

    @NotNull
    public final AnimationSet copy(@NotNull Animation idle, @NotNull Animation moving, @NotNull Animation attack, @NotNull Animation dodge, @NotNull Animation stagger, @NotNull Animation death) {
        Intrinsics.checkNotNullParameter((Object)idle, (String)"idle");
        Intrinsics.checkNotNullParameter((Object)moving, (String)"moving");
        Intrinsics.checkNotNullParameter((Object)attack, (String)"attack");
        Intrinsics.checkNotNullParameter((Object)dodge, (String)"dodge");
        Intrinsics.checkNotNullParameter((Object)stagger, (String)"stagger");
        Intrinsics.checkNotNullParameter((Object)death, (String)"death");
        return new AnimationSet(idle, moving, attack, dodge, stagger, death);
    }

    public static /* synthetic */ AnimationSet copy$default(AnimationSet animationSet, Animation animation, Animation animation2, Animation animation3, Animation animation4, Animation animation5, Animation animation6, int n, Object object) {
        if ((n & 1) != 0) {
            animation = animationSet.idle;
        }
        if ((n & 2) != 0) {
            animation2 = animationSet.moving;
        }
        if ((n & 4) != 0) {
            animation3 = animationSet.attack;
        }
        if ((n & 8) != 0) {
            animation4 = animationSet.dodge;
        }
        if ((n & 0x10) != 0) {
            animation5 = animationSet.stagger;
        }
        if ((n & 0x20) != 0) {
            animation6 = animationSet.death;
        }
        return animationSet.copy(animation, animation2, animation3, animation4, animation5, animation6);
    }

    @NotNull
    public String toString() {
        return "AnimationSet(idle=" + this.idle + ", moving=" + this.moving + ", attack=" + this.attack + ", dodge=" + this.dodge + ", stagger=" + this.stagger + ", death=" + this.death + ')';
    }

    public int hashCode() {
        int result = this.idle.hashCode();
        result = result * 31 + this.moving.hashCode();
        result = result * 31 + this.attack.hashCode();
        result = result * 31 + this.dodge.hashCode();
        result = result * 31 + this.stagger.hashCode();
        result = result * 31 + this.death.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnimationSet)) {
            return false;
        }
        AnimationSet animationSet = (AnimationSet)other;
        if (!Intrinsics.areEqual((Object)this.idle, (Object)animationSet.idle)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.moving, (Object)animationSet.moving)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.attack, (Object)animationSet.attack)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dodge, (Object)animationSet.dodge)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stagger, (Object)animationSet.stagger)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.death, (Object)animationSet.death);
    }
}

