/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.input;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.input.ActionType;
import org.veiset.kgame.engine.input.Animation;
import org.veiset.kgame.engine.input.AnimationSet;
import org.veiset.kgame.engine.input.AnimationSpeedModifier;
import org.veiset.kgame.engine.input.AnimationStateChange;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bJ\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\u0016\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lorg/veiset/kgame/engine/input/DynamicAnimation;", "", "animationSet", "Lorg/veiset/kgame/engine/input/AnimationSet;", "stateChanged", "Lorg/veiset/kgame/engine/input/AnimationStateChange;", "(Lorg/veiset/kgame/engine/input/AnimationSet;Lorg/veiset/kgame/engine/input/AnimationStateChange;)V", "action", "Lorg/veiset/kgame/engine/input/ActionType;", "getAnimationSet", "()Lorg/veiset/kgame/engine/input/AnimationSet;", "cancelableActions", "", "Lkotlin/reflect/KClass;", "currentAnimation", "Lorg/veiset/kgame/engine/input/Animation;", "queuedAction", "getStateChanged", "()Lorg/veiset/kgame/engine/input/AnimationStateChange;", "component1", "component2", "copy", "equals", "", "other", "frame", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "hashCode", "", "queueAction", "", "newAction", "setNewAction", "toString", "", "update", "delta", "", "speed", "Lorg/veiset/kgame/engine/input/AnimationSpeedModifier;", "kgame2"})
public final class DynamicAnimation {
    @NotNull
    private final AnimationSet animationSet;
    @NotNull
    private final AnimationStateChange stateChanged;
    @NotNull
    private ActionType action;
    @Nullable
    private ActionType queuedAction;
    @NotNull
    private Animation currentAnimation;
    @NotNull
    private final List<KClass<? extends ActionType>> cancelableActions;

    public DynamicAnimation(@NotNull AnimationSet animationSet, @NotNull AnimationStateChange stateChanged) {
        Intrinsics.checkNotNullParameter((Object)animationSet, (String)"animationSet");
        Intrinsics.checkNotNullParameter((Object)stateChanged, (String)"stateChanged");
        this.animationSet = animationSet;
        this.stateChanged = stateChanged;
        this.action = ActionType.Idle.INSTANCE;
        this.currentAnimation = this.animationSet.animationForAction(this.action);
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(ActionType.Idle.class), Reflection.getOrCreateKotlinClass(ActionType.Moving.class)};
        this.cancelableActions = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final AnimationSet getAnimationSet() {
        return this.animationSet;
    }

    @NotNull
    public final AnimationStateChange getStateChanged() {
        return this.stateChanged;
    }

    public final void queueAction(@NotNull ActionType newAction) {
        Intrinsics.checkNotNullParameter((Object)newAction, (String)"newAction");
        if (this.cancelableActions.contains(Reflection.getOrCreateKotlinClass(this.action.getClass())) || Intrinsics.areEqual((Object)newAction, (Object)ActionType.Stagger.INSTANCE)) {
            this.setNewAction(newAction);
        } else {
            this.queuedAction = newAction;
        }
    }

    @NotNull
    public final ActionType action() {
        return this.action;
    }

    @NotNull
    public final TextureRegion frame() {
        return this.currentAnimation.frame();
    }

    public final void update(float delta, @NotNull AnimationSpeedModifier speed) {
        Intrinsics.checkNotNullParameter((Object)speed, (String)"speed");
        this.currentAnimation.update(delta, speed.speedForAction(this.action));
        if (this.currentAnimation.done()) {
            ActionType actionType = this.queuedAction;
            this.setNewAction(actionType == null ? (ActionType)ActionType.Idle.INSTANCE : actionType);
            this.queuedAction = null;
        }
        this.stateChanged.update(this, delta, speed);
    }

    private final void setNewAction(ActionType newAction) {
        ActionType currentAction = this.action;
        if (currentAction instanceof ActionType.Moving && newAction instanceof ActionType.Moving) {
            ((ActionType.Moving)currentAction).setTarget(((ActionType.Moving)newAction).getTarget());
        }
        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(newAction.getClass()), (Object)Reflection.getOrCreateKotlinClass(this.action.getClass())) || !this.currentAnimation.getLooping()) {
            this.stateChanged.completedState(this.action);
            this.stateChanged.newState(newAction);
            this.action = newAction;
            this.currentAnimation = this.animationSet.animationForAction(this.action).reset();
            Log.INSTANCE.info(Intrinsics.stringPlus((String)"New State: ", (Object)newAction));
        }
    }

    @NotNull
    public final AnimationSet component1() {
        return this.animationSet;
    }

    @NotNull
    public final AnimationStateChange component2() {
        return this.stateChanged;
    }

    @NotNull
    public final DynamicAnimation copy(@NotNull AnimationSet animationSet, @NotNull AnimationStateChange stateChanged) {
        Intrinsics.checkNotNullParameter((Object)animationSet, (String)"animationSet");
        Intrinsics.checkNotNullParameter((Object)stateChanged, (String)"stateChanged");
        return new DynamicAnimation(animationSet, stateChanged);
    }

    public static /* synthetic */ DynamicAnimation copy$default(DynamicAnimation dynamicAnimation, AnimationSet animationSet, AnimationStateChange animationStateChange, int n, Object object) {
        if ((n & 1) != 0) {
            animationSet = dynamicAnimation.animationSet;
        }
        if ((n & 2) != 0) {
            animationStateChange = dynamicAnimation.stateChanged;
        }
        return dynamicAnimation.copy(animationSet, animationStateChange);
    }

    @NotNull
    public String toString() {
        return "DynamicAnimation(animationSet=" + this.animationSet + ", stateChanged=" + this.stateChanged + ')';
    }

    public int hashCode() {
        int result = this.animationSet.hashCode();
        result = result * 31 + this.stateChanged.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DynamicAnimation)) {
            return false;
        }
        DynamicAnimation dynamicAnimation = (DynamicAnimation)other;
        if (!Intrinsics.areEqual((Object)this.animationSet, (Object)dynamicAnimation.animationSet)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.stateChanged, (Object)dynamicAnimation.stateChanged);
    }
}

