/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.input;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.ecs.component.PositionComponent;
import org.veiset.kgame.engine.ecs.component.physics.DynamicBodyComponent;
import org.veiset.kgame.engine.ecs.component.physics.VelocityComponent;
import org.veiset.kgame.engine.ecs.component.player.InventoryComponent;
import org.veiset.kgame.engine.ecs.entity.PlayerEntity;
import org.veiset.kgame.engine.ecs.entity.attack.PlayerAttackEntity;
import org.veiset.kgame.engine.ecs.entity.effect.PermaEffectAnimationEntity;
import org.veiset.kgame.engine.ecs.system.Mapper;
import org.veiset.kgame.engine.input.ActionType;
import org.veiset.kgame.engine.input.AnimationSpeedModifier;
import org.veiset.kgame.engine.input.AnimationStateChange;
import org.veiset.kgame.engine.input.DynamicAnimation;
import org.veiset.kgame.engine.input.DynamicAnimationKt;
import org.veiset.kgame.engine.input.InputKey;
import org.veiset.kgame.engine.input.InputKeyKt;
import org.veiset.kgame.engine.input.MouseKt;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020#H\u0016J \u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020+H\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0019\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006,"}, d2={"Lorg/veiset/kgame/engine/input/PlayerBehaviour;", "Lorg/veiset/kgame/engine/input/AnimationStateChange;", "engine", "Lcom/badlogic/ashley/core/Engine;", "player", "Lorg/veiset/kgame/engine/ecs/entity/PlayerEntity;", "(Lcom/badlogic/ashley/core/Engine;Lorg/veiset/kgame/engine/ecs/entity/PlayerEntity;)V", "body", "Lcom/badlogic/gdx/physics/box2d/Body;", "getBody", "()Lcom/badlogic/gdx/physics/box2d/Body;", "currentDodgeCooldown", "", "getCurrentDodgeCooldown", "()F", "setCurrentDodgeCooldown", "(F)V", "dodgeCooldown", "getDodgeCooldown", "getEngine", "()Lcom/badlogic/ashley/core/Engine;", "getPlayer", "()Lorg/veiset/kgame/engine/ecs/entity/PlayerEntity;", "targetEntity", "Lorg/veiset/kgame/engine/ecs/entity/effect/PermaEffectAnimationEntity;", "getTargetEntity", "()Lorg/veiset/kgame/engine/ecs/entity/effect/PermaEffectAnimationEntity;", "targetEntityPos", "Lorg/veiset/kgame/engine/ecs/component/PositionComponent;", "kotlin.jvm.PlatformType", "getTargetEntityPos", "()Lorg/veiset/kgame/engine/ecs/component/PositionComponent;", "completedState", "", "completedAction", "Lorg/veiset/kgame/engine/input/ActionType;", "newState", "newAction", "update", "dynamicAnimation", "Lorg/veiset/kgame/engine/input/DynamicAnimation;", "delta", "speed", "Lorg/veiset/kgame/engine/input/AnimationSpeedModifier;", "kgame2"})
public final class PlayerBehaviour
implements AnimationStateChange {
    @NotNull
    private final Engine engine;
    @NotNull
    private final PlayerEntity player;
    @NotNull
    private final PermaEffectAnimationEntity targetEntity;
    private final PositionComponent targetEntityPos;
    @Nullable
    private final Body body;
    private final float dodgeCooldown;
    private float currentDodgeCooldown;

    public PlayerBehaviour(@NotNull Engine engine, @NotNull PlayerEntity player) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)((Object)player), (String)"player");
        this.engine = engine;
        this.player = player;
        this.targetEntity = new PermaEffectAnimationEntity(DynamicAnimationKt.getAnimations().getMouseClick(), MouseKt.scaledPointer(), Vector2Kt.x(0.18f, 0.18f), null, 10, 8, null);
        this.targetEntityPos = (PositionComponent)Mapper.INSTANCE.getPosition().get((Entity)this.targetEntity);
        DynamicBodyComponent dynamicBodyComponent = (DynamicBodyComponent)Mapper.INSTANCE.getDynamicBody().get((Entity)this.targetEntity);
        this.body = dynamicBodyComponent == null ? null : dynamicBodyComponent.getBody();
        this.dodgeCooldown = 0.5f;
        this.engine.addEntity((Entity)this.targetEntity);
    }

    @NotNull
    public final Engine getEngine() {
        return this.engine;
    }

    @NotNull
    public final PlayerEntity getPlayer() {
        return this.player;
    }

    @NotNull
    public final PermaEffectAnimationEntity getTargetEntity() {
        return this.targetEntity;
    }

    public final PositionComponent getTargetEntityPos() {
        return this.targetEntityPos;
    }

    @Nullable
    public final Body getBody() {
        return this.body;
    }

    public final float getDodgeCooldown() {
        return this.dodgeCooldown;
    }

    public final float getCurrentDodgeCooldown() {
        return this.currentDodgeCooldown;
    }

    public final void setCurrentDodgeCooldown(float f) {
        this.currentDodgeCooldown = f;
    }

    @Override
    public void update(@NotNull DynamicAnimation dynamicAnimation, float delta, @NotNull AnimationSpeedModifier speed) {
        Vector2 vector2;
        Vector2 targetPos;
        Intrinsics.checkNotNullParameter((Object)dynamicAnimation, (String)"dynamicAnimation");
        Intrinsics.checkNotNullParameter((Object)speed, (String)"speed");
        ActionType currentAction = dynamicAnimation.action();
        Vector2 position = ((PositionComponent)Mapper.INSTANCE.getPosition().get((Entity)this.player)).getPos();
        VelocityComponent velocity = (VelocityComponent)Mapper.INSTANCE.getVelocity().get((Entity)this.player);
        PlayerBehaviour playerBehaviour = this;
        playerBehaviour.currentDodgeCooldown -= delta;
        if (velocity.getSpeed().x == 0.0f && velocity.getSpeed().y == 0.0f) {
            dynamicAnimation.queueAction(ActionType.Idle.INSTANCE);
        }
        if (InputKeyKt.clicked(InputKey.DODGE) && this.currentDodgeCooldown <= 0.0f) {
            this.currentDodgeCooldown = this.dodgeCooldown;
            velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
            dynamicAnimation.queueAction(new ActionType.Dodge(MouseKt.scaledPointer()));
        } else if (InputKeyKt.pressed(InputKey.ATTACK)) {
            velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
            dynamicAnimation.queueAction(new ActionType.Attack(MouseKt.scaledPointer()));
        } else if (InputKeyKt.pressed(InputKey.MOVE)) {
            Vector2 target = MouseKt.scaledPointer();
            this.targetEntityPos.setPos(Vector2Kt.copy(target));
            if (target.dst(position) >= 0.2f) {
                dynamicAnimation.queueAction(new ActionType.Moving(target));
            }
        }
        if (currentAction instanceof ActionType.Dodge) {
            targetPos = ((ActionType.Dodge)currentAction).getTarget();
            vector2 = Vector2Kt.minus(targetPos, position).nor().scl(5.0f);
            Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"targetPos - position).nor().scl(5f)");
            velocity.setSpeed(vector2);
            if (targetPos.dst(position) <= 0.2f) {
                dynamicAnimation.queueAction(ActionType.Idle.INSTANCE);
                velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
            }
        }
        if (currentAction instanceof ActionType.Moving) {
            targetPos = ((ActionType.Moving)currentAction).getTarget();
            this.targetEntityPos.setPos(Vector2Kt.copy(targetPos));
            vector2 = Vector2Kt.minus(targetPos, position).nor().scl(speed.getMove());
            Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"targetPos - position).nor().scl(speed.move)");
            velocity.setSpeed(vector2);
            if (targetPos.dst(position) <= 0.2f) {
                dynamicAnimation.queueAction(ActionType.Idle.INSTANCE);
                velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
            }
        }
    }

    @Override
    public void newState(@NotNull ActionType newAction) {
        Intrinsics.checkNotNullParameter((Object)newAction, (String)"newAction");
        ActionType actionType = newAction;
        if (actionType instanceof ActionType.Moving) {
            this.targetEntity.enable();
        } else if (!(actionType instanceof ActionType.Dodge) && Intrinsics.areEqual((Object)actionType, (Object)ActionType.Idle.INSTANCE)) {
            VelocityComponent velocity = (VelocityComponent)Mapper.INSTANCE.getVelocity().get((Entity)this.player);
            velocity.setSpeed(Vector2Kt.x(0.0f, 0.0f));
        }
    }

    @Override
    public void completedState(@NotNull ActionType completedAction) {
        Intrinsics.checkNotNullParameter((Object)completedAction, (String)"completedAction");
        InventoryComponent inventoryComponent = (InventoryComponent)Mapper.INSTANCE.getInventory().get((Entity)this.player);
        if (inventoryComponent == null) {
            throw new IllegalStateException("No inventory");
        }
        InventoryComponent inventory = inventoryComponent;
        Vector2 position = ((PositionComponent)Mapper.INSTANCE.getPosition().get((Entity)this.player)).getPos();
        ActionType actionType = completedAction;
        if (actionType instanceof ActionType.Attack) {
            this.engine.addEntity((Entity)new PlayerAttackEntity(inventory.allMods(), position, ((ActionType.Attack)completedAction).getTarget()));
        } else if (actionType instanceof ActionType.Moving) {
            this.targetEntity.disable();
        } else if (actionType instanceof ActionType.Dodge) {
            // empty if block
        }
    }
}

